/*
 * Decompiled with CFR 0.152.
 */
package io.github.bluesheep2804.jaopcaextras.modules;

import io.github.bluesheep2804.jaopcaextras.recipes.ShapedRecipeSerializer;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import thelm.jaopca.api.JAOPCAApi;
import thelm.jaopca.api.forms.IForm;
import thelm.jaopca.api.forms.IFormRequest;
import thelm.jaopca.api.forms.IFormType;
import thelm.jaopca.api.helpers.IMiscHelper;
import thelm.jaopca.api.items.IItemInfo;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.api.materials.MaterialType;
import thelm.jaopca.api.modules.IModule;
import thelm.jaopca.api.modules.IModuleData;
import thelm.jaopca.api.modules.JAOPCAModule;
import thelm.jaopca.api.recipes.IRecipeSerializer;

@JAOPCAModule
public class PlatesModule
implements IModule {
    private final JAOPCAApi api = JAOPCAApi.instance();
    private final IForm plateForm = this.api.newForm((IModule)this, "plates", (IFormType)this.api.itemFormType()).setMaterialTypes(MaterialType.INGOTS);

    public String getName() {
        return "extras_plates";
    }

    public Set<MaterialType> getMaterialTypes() {
        return EnumSet.allOf(MaterialType.class);
    }

    public List<IFormRequest> getFormRequests() {
        return Collections.singletonList(this.api.newFormRequest((IModule)this, new IForm[]{this.plateForm}));
    }

    public void onCommonSetup(IModuleData moduleData, FMLCommonSetupEvent event) {
        IMiscHelper miscHelper = this.api.miscHelper();
        for (IMaterial material : this.plateForm.getMaterials()) {
            ResourceLocation materialLocation = miscHelper.getTagLocation(material.getType().getFormName(), material.getName());
            IItemInfo plateInfo = this.api.itemFormType().getMaterialFormInfo(this.plateForm, material);
            this.api.registerRecipe(new ResourceLocation("jaopcaextras", "plates.from_material." + material.getName()), (IRecipeSerializer)new ShapedRecipeSerializer(new String[]{"M ", " M"}, Map.of("M", materialLocation), plateInfo, 1));
        }
    }
}

