/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.utils;

import com.communi.suggestu.scena.core.registries.IPlatformRegistryManager;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Optional;
import mod.chiselsandbits.api.block.state.id.IBlockStateIdManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StringStateUtils {
    private static final Logger LOGGER = LogManager.getLogger();

    private StringStateUtils() {
        throw new IllegalStateException("Can not instantiate an instance of: StringStateUtils. This is a utility class");
    }

    public static int getStateIDFromName(String name) {
        String[] parts = name.split("[?&]");
        parts[0] = URLDecoder.decode(parts[0], StandardCharsets.UTF_8);
        Optional blk = IPlatformRegistryManager.getInstance().getBlockRegistry().getValue(new ResourceLocation(parts[0]));
        if (blk.isEmpty() || blk.get() instanceof AirBlock) {
            return 0;
        }
        BlockState state = ((Block)blk.get()).m_49966_();
        for (int x = 1; x < parts.length; ++x) {
            try {
                String[] nameValues;
                if (parts[x].length() <= 0 || (nameValues = parts[x].split("[=]")).length != 2) continue;
                nameValues[0] = URLDecoder.decode(nameValues[0], StandardCharsets.UTF_8);
                nameValues[1] = URLDecoder.decode(nameValues[1], StandardCharsets.UTF_8);
                state = StringStateUtils.withState(state, (Block)blk.get(), nameValues);
                continue;
            }
            catch (Exception err) {
                LOGGER.error("Failed to reload Property from store data : " + name, (Throwable)err);
            }
        }
        return IBlockStateIdManager.getInstance().getIdFrom(state);
    }

    private static BlockState withState(BlockState state, Block blk, String[] nameval) {
        Property prop = blk.m_49965_().m_61081_(nameval[0]);
        if (prop == null) {
            LOGGER.info(nameval[0] + " is not a valid property for " + IPlatformRegistryManager.getInstance().getBlockRegistry().getKey((Object)blk));
            return state;
        }
        return StringStateUtils.setPropValue(state, prop, nameval[1]);
    }

    public static <T extends Comparable<T>> BlockState setPropValue(BlockState blockState, Property<T> property, String value) {
        Optional pv = property.m_6215_(value);
        if (pv.isPresent()) {
            return (BlockState)blockState.m_61124_(property, (Comparable)pv.get());
        }
        LOGGER.info(value + " is not a valid value of " + property.m_61708_() + " for " + IPlatformRegistryManager.getInstance().getBlockRegistry().getKey((Object)blockState.m_60734_()));
        return blockState;
    }

    public static String getNameFromStateID(int key) {
        BlockState state = IBlockStateIdManager.getInstance().getBlockStateFrom(key);
        Block blk = state.m_60734_();
        String sname = "air?";
        StringBuilder stateName = new StringBuilder(URLEncoder.encode(Objects.requireNonNull(IPlatformRegistryManager.getInstance().getBlockRegistry().getKey((Object)blk)).toString(), StandardCharsets.UTF_8));
        stateName.append('?');
        boolean first = true;
        for (Property p : state.m_60734_().m_49965_().m_61092_()) {
            if (!first) {
                stateName.append('&');
            }
            first = false;
            Comparable propVal = state.m_61143_(p);
            String saveAs = propVal instanceof StringRepresentable ? ((StringRepresentable)propVal).m_7912_() : propVal.toString();
            stateName.append(URLEncoder.encode(p.m_61708_(), StandardCharsets.UTF_8));
            stateName.append('=');
            stateName.append(URLEncoder.encode(saveAs, StandardCharsets.UTF_8));
        }
        sname = stateName.toString();
        return sname;
    }
}

