/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.vinery.core.block;

import java.util.Iterator;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.vinery.core.util.GrapeType;
import net.satisfy.vinery.platform.PlatformHelper;
import org.jetbrains.annotations.NotNull;

public class GrapeBush
extends BushBlock
implements BonemealableBlock {
    public static final IntegerProperty AGE = BlockStateProperties.f_61407_;
    private static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    public final GrapeType type;

    public GrapeBush(BlockBehaviour.Properties settings, GrapeType type) {
        super(settings);
        this.type = type;
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    @NotNull
    public ItemStack m_7397_(BlockGetter world, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)this.getType().getSeeds());
    }

    @NotNull
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        boolean bl;
        int i = (Integer)state.m_61143_((Property)AGE);
        boolean bl2 = bl = i == 3;
        if (!bl && player.m_21120_(hand).m_150930_(Items.f_42499_)) {
            return InteractionResult.PASS;
        }
        if (i > 1) {
            int x = world.f_46441_.m_188503_(2);
            GrapeBush.m_49840_((Level)world, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)this.getGrapeType().m_41720_(), x + (bl ? 1 : 0)));
            world.m_5594_(null, pos, SoundEvents.f_12457_, SoundSource.BLOCKS, 1.0f, 0.8f + world.f_46441_.m_188501_() * 0.4f);
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(1)), 2);
            return InteractionResult.m_19078_((boolean)world.f_46443_);
        }
        return super.m_6227_(state, world, pos, player, hand, hit);
    }

    public void m_213898_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        int age = (Integer)state.m_61143_((Property)AGE);
        double growthChance = PlatformHelper.getGrapeGrowthChance();
        if (age < 3 && random.m_188500_() < growthChance && this.canGrowPlace((LevelReader)world, pos, state)) {
            BlockState newState = (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(age + 1));
            world.m_7731_(pos, newState, 2);
            world.m_220407_(GameEvent.f_157792_, pos, GameEvent.Context.m_223722_((BlockState)newState));
        }
    }

    public boolean m_6724_(BlockState state) {
        return (Integer)state.m_61143_((Property)AGE) < 3;
    }

    public boolean m_7370_(LevelReader levelReader, BlockPos blockPos, BlockState blockState, boolean bl) {
        return (Integer)blockState.m_61143_((Property)AGE) < 3;
    }

    public boolean m_214167_(Level world, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public boolean canGrowPlace(LevelReader world, BlockPos blockPos, BlockState blockState) {
        return world.m_45524_(blockPos, 0) > 9;
    }

    public boolean m_7898_(BlockState blockState, LevelReader world, BlockPos blockPos) {
        return this.canGrowPlace(world, blockPos, blockState) && this.m_6266_(world.m_8055_(blockPos.m_7495_()), (BlockGetter)world, blockPos);
    }

    protected boolean m_6266_(BlockState floor, BlockGetter world, BlockPos pos) {
        return floor.m_60804_(world, pos);
    }

    public GrapeType getType() {
        return this.type;
    }

    public ItemStack getGrapeType() {
        return new ItemStack((ItemLike)this.getType().getFruit());
    }

    public void m_214148_(ServerLevel world, RandomSource random, BlockPos pos, BlockState state) {
        int i = Math.min(3, (Integer)state.m_61143_((Property)AGE) + 1);
        world.m_7731_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(i)), 2);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{AGE});
    }

    public static class TaigaGrapeBush
    extends GrapeBush {
        public TaigaGrapeBush(BlockBehaviour.Properties settings, GrapeType type) {
            super(settings, type);
        }

        @Override
        public boolean canGrowPlace(LevelReader world, BlockPos blockPos, BlockState blockState) {
            BlockPos pos;
            if (world.m_45524_(blockPos, 0) <= 4) {
                return false;
            }
            int size = 4;
            Iterator var2 = BlockPos.m_121940_((BlockPos)blockPos.m_7918_(-size, -2, -size), (BlockPos)blockPos.m_7918_(size, 1, size)).iterator();
            do {
                if (var2.hasNext()) continue;
                return false;
            } while (world.m_8055_(pos = (BlockPos)var2.next()).m_60734_() != Blocks.f_50599_ && world.m_8055_(pos).m_60734_() != Blocks.f_50546_ && world.m_8055_(pos).m_60734_() != Blocks.f_50440_);
            return true;
        }

        public boolean m_7357_(BlockState arg, BlockGetter arg2, BlockPos arg3, PathComputationType arg4) {
            return false;
        }
    }

    public static class SavannaGrapeBush
    extends GrapeBush {
        public SavannaGrapeBush(BlockBehaviour.Properties settings, GrapeType type) {
            super(settings, type);
        }

        @Override
        public boolean canGrowPlace(LevelReader world, BlockPos blockPos, BlockState blockState) {
            return world.m_45524_(blockPos, 0) >= 14;
        }
    }
}

