/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.vinery.core.block;

import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.vinery.core.block.StemBlock;
import net.satisfy.vinery.core.item.GrapeBushSeedItem;
import net.satisfy.vinery.core.registry.GrapeTypeRegistry;
import net.satisfy.vinery.core.registry.ObjectRegistry;
import net.satisfy.vinery.core.util.GrapeType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3i;

public class PaleStemBlock
extends StemBlock {
    private static final VoxelShape PALE_SHAPE = Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    public static final BooleanProperty LEAVES_PENDING = BooleanProperty.m_61465_((String)"leaves_pending");
    public static final BooleanProperty LEAVES_DONE = BooleanProperty.m_61465_((String)"leaves_done");

    public PaleStemBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)GRAPE, (Comparable)GrapeTypeRegistry.NONE)).m_61124_((Property)AGE, (Comparable)Integer.valueOf(0))).m_61124_((Property)LEAVES_PENDING, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LEAVES_DONE, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return PALE_SHAPE;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        BlockState blockState = this.m_49966_();
        if (blockState.m_60710_((LevelReader)ctx.m_43725_(), ctx.m_8083_())) {
            return blockState;
        }
        return null;
    }

    public void m_6402_(Level level, BlockPos blockPos, BlockState blockState, @Nullable LivingEntity livingEntity, ItemStack itemStack) {
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (itemStack != null && (player.m_7500_() || itemStack.m_41613_() >= 2) && level.m_8055_(blockPos.m_7495_()).m_60734_() != this && blockPos.m_123342_() < level.m_151558_() - 1 && level.m_8055_(blockPos.m_7494_()).m_247087_()) {
                level.m_7731_(blockPos.m_7494_(), this.m_49966_(), 3);
                itemStack.m_41774_(1);
            }
        }
    }

    @Override
    @NotNull
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (hand == InteractionHand.OFF_HAND) {
            return super.m_6227_(state, world, pos, player, hand, hit);
        }
        int age = (Integer)state.m_61143_((Property)AGE);
        if (age > 0 && player.m_21120_(hand).m_41720_() == Items.f_42574_) {
            if (age > 2) {
                this.dropGrapes(world, state, pos, hit.m_82434_());
            }
            this.dropGrapeSeeds(world, state, pos, hit.m_82434_());
            world.m_7731_(pos, this.withAge(state, Math.max(0, age - 1), (GrapeType)state.m_61143_((Property)GRAPE)), 3);
            world.m_5594_(player, pos, SoundEvents.f_12455_, SoundSource.AMBIENT, 1.0f, 1.0f);
            return InteractionResult.m_19078_((boolean)world.f_46443_);
        }
        ItemStack stack = player.m_21120_(hand);
        Item item = stack.m_41720_();
        if (item instanceof GrapeBushSeedItem) {
            GrapeBushSeedItem seed = (GrapeBushSeedItem)item;
            if (this.hasTrunk(world, pos) && age == 0 && !seed.getType().isLattice()) {
                boolean schedule = seed.getType() == GrapeTypeRegistry.WHITE || seed.getType() == GrapeTypeRegistry.RED;
                BlockState ns = this.withAge(state, 1, seed.getType());
                if (schedule && !((Boolean)state.m_61143_((Property)LEAVES_PENDING)).booleanValue() && !((Boolean)state.m_61143_((Property)LEAVES_DONE)).booleanValue()) {
                    ns = (BlockState)ns.m_61124_((Property)LEAVES_PENDING, (Comparable)Boolean.valueOf(true));
                    int delay = 4800 + world.f_46441_.m_188503_(4801);
                    world.m_186460_(pos, (Block)this, delay);
                }
                world.m_7731_(pos, ns, 3);
                if (!player.m_7500_()) {
                    stack.m_41774_(1);
                }
                world.m_5594_(player, pos, SoundEvents.f_12456_, SoundSource.AMBIENT, 1.0f, 1.0f);
                return InteractionResult.SUCCESS;
            }
        }
        return super.m_6227_(state, world, pos, player, hand, hit);
    }

    public void m_6807_(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean moved) {
        super.m_6807_(state, world, pos, oldState, moved);
        if (!(world.f_46443_ || state.m_61143_((Property)GRAPE) != GrapeTypeRegistry.WHITE && state.m_61143_((Property)GRAPE) != GrapeTypeRegistry.RED || ((Boolean)state.m_61143_((Property)LEAVES_PENDING)).booleanValue() || ((Boolean)state.m_61143_((Property)LEAVES_DONE)).booleanValue())) {
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)LEAVES_PENDING, (Comparable)Boolean.valueOf(true)), 3);
            int delay = 4800 + world.f_46441_.m_188503_(4801);
            world.m_186460_(pos, (Block)this, delay);
        }
    }

    public void m_213897_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (!state.m_60710_((LevelReader)world, pos)) {
            if ((Integer)state.m_61143_((Property)AGE) > 0) {
                this.dropGrapeSeeds((Level)world, state, pos, null);
            }
            if ((Integer)state.m_61143_((Property)AGE) > 2) {
                this.dropGrapes((Level)world, state, pos, null);
            }
            world.m_46961_(pos, true);
            return;
        }
        if (((Boolean)state.m_61143_((Property)LEAVES_PENDING)).booleanValue()) {
            boolean isRed;
            boolean isWhite = state.m_61143_((Property)GRAPE) == GrapeTypeRegistry.WHITE;
            boolean bl = isRed = state.m_61143_((Property)GRAPE) == GrapeTypeRegistry.RED;
            if (isWhite || isRed) {
                List<Vector3i> offsets = Arrays.asList(new Vector3i(-2, 0, -1), new Vector3i(-1, 0, -2), new Vector3i(1, 0, -2), new Vector3i(2, 0, -1), new Vector3i(-2, 0, 1), new Vector3i(-1, 0, 0), new Vector3i(1, 0, 0), new Vector3i(2, 0, 1), new Vector3i(-1, 0, 2), new Vector3i(0, 0, 1), new Vector3i(1, 0, 2));
                for (Vector3i v : offsets) {
                    if (random.m_188501_() > 0.4f) continue;
                    BlockPos ground = pos.m_7918_(v.x, 0, v.z);
                    while (world.m_46739_(ground) && world.m_8055_(ground).m_60795_()) {
                        ground = ground.m_7495_();
                    }
                    BlockPos placePos = ground.m_7494_();
                    if (!world.m_8055_(placePos).m_247087_()) continue;
                    world.m_7731_(placePos, (BlockState)((Block)ObjectRegistry.GRAPEVINE_LEAVES.get()).m_49966_().m_61124_((Property)LeavesBlock.f_54419_, (Comparable)Boolean.valueOf(true)), 3);
                }
            }
            world.m_7731_(pos, (BlockState)((BlockState)state.m_61124_((Property)LEAVES_PENDING, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LEAVES_DONE, (Comparable)Boolean.valueOf(true)), 3);
        }
    }

    public void m_213898_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        int i;
        Random rand = new Random();
        if (rand.nextInt(100) >= 98) {
            return;
        }
        if (!this.isMature(state) && this.hasTrunk((Level)world, pos) && (Integer)state.m_61143_((Property)AGE) > 0 && world.m_45524_(pos, 0) >= 9 && (i = ((Integer)state.m_61143_((Property)AGE)).intValue()) < 4) {
            world.m_7731_(pos, this.withAge(state, i + 1, (GrapeType)state.m_61143_((Property)GRAPE)), 2);
        }
        super.m_213898_(state, world, pos, random);
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        return world.m_8055_(pos.m_7495_()).m_60796_((BlockGetter)world, pos) || world.m_8055_(pos.m_7495_()).m_60734_() == this;
    }

    @NotNull
    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (!state.m_60710_((LevelReader)world, pos)) {
            world.m_186460_(pos, (Block)this, 1);
        }
        return super.m_7417_(state, direction, neighborState, world, pos, neighborPos);
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{LEAVES_PENDING, LEAVES_DONE});
    }
}

