/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.vinery.platform.forge;

import java.util.List;
import java.util.function.Supplier;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.satisfy.vinery.forge.core.config.VineryForgeConfig;

public class PlatformHelperImpl {
    public static final DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)"vinery");

    public static int getTotalFermentationTime() {
        return (Integer)VineryForgeConfig.TOTAL_FERMENTATION_TIME.get();
    }

    public static int getMaxFluidLevel() {
        return (Integer)VineryForgeConfig.MAX_FLUID_LEVEL.get();
    }

    public static int getMaxFluidIncrease() {
        return (Integer)VineryForgeConfig.MAX_FLUID_INCREASE.get();
    }

    public static int getApplePressMashingTime() {
        return (Integer)VineryForgeConfig.APPLE_PRESS_MASHING_TIME.get();
    }

    public static int getApplePressFermentationTime() {
        return (Integer)VineryForgeConfig.APPLE_PRESS_FERMENTING_TIME.get();
    }

    public static double getCherryGrowthChance() {
        return (Double)VineryForgeConfig.CHERRY_GROWTH_CHANCE.get();
    }

    public static double getAppleGrowthChance() {
        return (Double)VineryForgeConfig.APPLE_GROWTH_CHANCE.get();
    }

    public static double getGrapeGrowthChance() {
        return (Double)VineryForgeConfig.GRAPE_GROWTH_CHANCE.get();
    }

    public static int getWineMaxLevel() {
        return (Integer)VineryForgeConfig.MAX_LEVEL.get();
    }

    public static int getWineStartDuration() {
        return (Integer)VineryForgeConfig.START_DURATION.get();
    }

    public static int getWineDurationPerYear() {
        return (Integer)VineryForgeConfig.DURATION_PER_YEAR.get();
    }

    public static int getWineDaysPerYear() {
        return (Integer)VineryForgeConfig.DAYS_PER_YEAR.get();
    }

    public static int getWineYearsPerEffectLevel() {
        return (Integer)VineryForgeConfig.YEARS_PER_EFFECT_LEVEL.get();
    }

    public static int getWineMaxDuration() {
        return (Integer)VineryForgeConfig.MAX_DURATION.get();
    }

    public static boolean shouldGiveEffect() {
        return (Boolean)VineryForgeConfig.GIVE_EFFECT.get();
    }

    public static boolean shouldShowTooltip() {
        return (Boolean)VineryForgeConfig.GIVE_EFFECT.get() != false && (Boolean)VineryForgeConfig.SHOW_TOOLTIP.get() != false;
    }

    public static List<? extends String> getBasketBlacklist() {
        return (List)VineryForgeConfig.BASKET_BLACKLIST.get();
    }

    public static double getTraderSpawnChance() {
        return (Double)VineryForgeConfig.TRADER_SPAWN_CHANCE.get();
    }

    public static boolean shouldSpawnWithMules() {
        return (Boolean)VineryForgeConfig.SPAWN_WITH_MULES.get();
    }

    public static int getTraderSpawnDelay() {
        return (Integer)VineryForgeConfig.TRADER_SPAWN_DELAY.get();
    }

    public static <T extends Entity> Supplier<EntityType<T>> registerBoatType(String name, EntityType.EntityFactory<T> factory, MobCategory category, float width, float height, int clientTrackingRange) {
        return ENTITY_TYPES.register(name, () -> EntityType.Builder.m_20704_((EntityType.EntityFactory)factory, (MobCategory)category).m_20699_(width, height).m_20712_(name));
    }
}

