/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.dynamiclights.server;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.Logger;

public class ItemConfigHelper {
    private Map<ItemStack, Integer> itemStackList = new HashMap<ItemStack, Integer>();

    public ItemConfigHelper(List<? extends String> items, Logger logger) {
        for (String string : items) {
            try {
                CompoundTag nbt = TagParser.m_129359_((String)string);
                ResourceLocation resourceLocation = new ResourceLocation(nbt.m_128461_("nameId"));
                Item item = (Item)ForgeRegistries.ITEMS.getValue(resourceLocation);
                if (item != null) {
                    ItemStack itemStack = new ItemStack((ItemLike)item);
                    nbt.m_128473_("nameId");
                    int lightLevel = 15;
                    if (nbt.m_128441_("lightLevel")) {
                        lightLevel = nbt.m_128448_("lightLevel");
                        nbt.m_128473_("lightLevel");
                    }
                    if (!nbt.m_128456_()) {
                        itemStack.m_41751_(nbt);
                    }
                    this.itemStackList.put(itemStack, lightLevel);
                    logger.info("item config parser identified itemstack {}", (Object)itemStack);
                    continue;
                }
                logger.error("item config parser could not identify item by resourcelocation {}", (Object)resourceLocation);
            }
            catch (CommandSyntaxException e) {
                e.printStackTrace();
            }
        }
        logger.info("item config parser finished, item count: {}", (Object)this.itemStackList.size());
    }

    public static String fromItemStack(ItemStack itemStack, int lightLevel) {
        CompoundTag resultTag = itemStack.m_41784_();
        resultTag.m_128359_("nameId", ForgeRegistries.ITEMS.getKey((Object)itemStack.m_41720_()).toString());
        if (lightLevel > 0) {
            resultTag.m_128376_("lightLevel", (short)lightLevel);
        }
        return resultTag.toString();
    }

    public int getLightLevel(ItemStack stack) {
        if (stack == null || stack.m_41619_()) {
            return 0;
        }
        for (Map.Entry<ItemStack, Integer> entry : this.itemStackList.entrySet()) {
            ItemStack is = entry.getKey();
            if (is.m_41720_() != stack.m_41720_() || !this.tagsMatchWithWildcard(is, stack)) continue;
            return entry.getValue();
        }
        return 0;
    }

    private boolean tagsMatchWithWildcard(ItemStack configuredStack, ItemStack ingameStack) {
        if (configuredStack.m_41783_() != null && configuredStack.m_41783_().m_128441_("anyNbtMatch")) {
            return true;
        }
        return ItemStack.m_150942_((ItemStack)configuredStack, (ItemStack)ingameStack);
    }
}

