/*
 * Decompiled with CFR 0.152.
 */
package com.cinemamod.mcef;

import com.cinemamod.mcef.MCEF;
import com.cinemamod.mcef.MCEFPlatform;
import com.cinemamod.mcef.internal.MCEFDownloadListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.io.FileUtils;

public class MCEFDownloader {
    private static final String JAVA_CEF_DOWNLOAD_URL = "${host}/java-cef-builds/${java-cef-commit}/${platform}.tar.gz";
    private static final String JAVA_CEF_CHECKSUM_DOWNLOAD_URL = "${host}/java-cef-builds/${java-cef-commit}/${platform}.tar.gz.sha256";
    private final String host;
    private final String javaCefCommitHash;
    private final MCEFPlatform platform;

    public MCEFDownloader(String host, String javaCefCommitHash, MCEFPlatform platform) {
        this.host = host;
        this.javaCefCommitHash = javaCefCommitHash;
        this.platform = platform;
    }

    public String getHost() {
        return this.host;
    }

    public String getJavaCefDownloadUrl() {
        return this.formatURL(JAVA_CEF_DOWNLOAD_URL);
    }

    public String getJavaCefChecksumDownloadUrl() {
        return this.formatURL(JAVA_CEF_CHECKSUM_DOWNLOAD_URL);
    }

    private String formatURL(String url) {
        return url.replace("${host}", this.host).replace("${java-cef-commit}", this.javaCefCommitHash).replace("${platform}", this.platform.getNormalizedName());
    }

    public void downloadJavaCefBuild() throws IOException {
        File mcefLibrariesPath = new File(System.getProperty("mcef.libraries.path"));
        MCEFDownloadListener.INSTANCE.setTask("Downloading Chromium Embedded Framework");
        MCEFDownloader.downloadFile(this.getJavaCefDownloadUrl(), new File(mcefLibrariesPath, this.platform.getNormalizedName() + ".tar.gz"));
    }

    public boolean downloadJavaCefChecksum() throws IOException {
        File mcefLibrariesPath = new File(System.getProperty("mcef.libraries.path"));
        File jcefBuildHashFileTemp = new File(mcefLibrariesPath, this.platform.getNormalizedName() + ".tar.gz.sha256.temp");
        File jcefBuildHashFile = new File(mcefLibrariesPath, this.platform.getNormalizedName() + ".tar.gz.sha256");
        MCEFDownloadListener.INSTANCE.setTask("Downloading Checksum");
        MCEFDownloader.downloadFile(this.getJavaCefChecksumDownloadUrl(), jcefBuildHashFileTemp);
        if (jcefBuildHashFile.exists()) {
            boolean sameContent = FileUtils.contentEquals((File)jcefBuildHashFile, (File)jcefBuildHashFileTemp);
            if (sameContent) {
                jcefBuildHashFileTemp.delete();
                return true;
            }
            MCEF.getLogger().warn("JCEF Hash does not match.");
        } else {
            MCEF.getLogger().warn("Failed to download JCEF hash.");
        }
        jcefBuildHashFileTemp.renameTo(jcefBuildHashFile);
        return false;
    }

    public void extractJavaCefBuild(boolean delete) {
        File mcefLibrariesPath = new File(System.getProperty("mcef.libraries.path"));
        File tarGzArchive = new File(mcefLibrariesPath, this.platform.getNormalizedName() + ".tar.gz");
        MCEFDownloader.extractTarGz(tarGzArchive, mcefLibrariesPath);
        if (delete && tarGzArchive.exists()) {
            tarGzArchive.delete();
        }
    }

    private static void downloadFile(String urlString, File outputFile) throws IOException {
        try {
            int count;
            MCEF.getLogger().info(urlString + " -> " + outputFile.getCanonicalPath());
            URL url = new URL(urlString);
            HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
            if (urlConnection.getResponseCode() != 200) {
                throw new IOException();
            }
            int fileSize = urlConnection.getContentLength();
            BufferedInputStream inputStream = new BufferedInputStream(url.openStream());
            FileOutputStream outputStream = new FileOutputStream(outputFile);
            byte[] buffer = new byte[2048];
            int readBytes = 0;
            while ((count = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, count);
                float percentComplete = (float)(readBytes += count) / (float)fileSize;
                MCEFDownloadListener.INSTANCE.setProgress(percentComplete);
                buffer = new byte[Math.max(2048, inputStream.available())];
            }
            inputStream.close();
            outputStream.close();
        }
        catch (IOException e) {
            throw new IOException("Failed to download " + urlString);
        }
    }

    private static void extractTarGz(File tarGzFile, File outputDirectory) {
        MCEFDownloadListener.INSTANCE.setTask("Extracting");
        outputDirectory.mkdirs();
        long fileSize = tarGzFile.length();
        long totalBytesRead = 0L;
        try (TarArchiveInputStream tarInput = new TarArchiveInputStream((InputStream)new GzipCompressorInputStream((InputStream)new FileInputStream(tarGzFile)));){
            TarArchiveEntry entry;
            while ((entry = tarInput.getNextTarEntry()) != null) {
                if (entry.isDirectory()) continue;
                File outputFile = new File(outputDirectory, entry.getName());
                outputFile.getParentFile().mkdirs();
                try (FileOutputStream outputStream = new FileOutputStream(outputFile);){
                    int bytesRead;
                    byte[] buffer = new byte[4096];
                    while ((bytesRead = tarInput.read(buffer)) != -1) {
                        ((OutputStream)outputStream).write(buffer, 0, bytesRead);
                        float percentComplete = (float)(totalBytesRead += (long)bytesRead) / (float)fileSize / 2.6158204f;
                        MCEFDownloadListener.INSTANCE.setProgress(percentComplete);
                        buffer = new byte[Math.max(4096, tarInput.available())];
                    }
                }
            }
        }
        catch (IOException e) {
            MCEF.getLogger().error("Failed to extract gzip file to " + outputDirectory, (Throwable)e);
        }
        MCEFDownloadListener.INSTANCE.setProgress(1.0f);
    }
}

