/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.naturalist.client.model;

import com.starfish_studios.naturalist.common.entity.Snail;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.model.data.EntityModelData;

@OnlyIn(value=Dist.CLIENT)
public class SnailModel
extends GeoModel<Snail> {
    public ResourceLocation getModelResource(Snail snail) {
        return new ResourceLocation("naturalist", "geo/entity/snail.geo.json");
    }

    @NotNull
    public ResourceLocation getTextureResource(@NotNull Snail snail) {
        if (snail.m_7755_().getString().contains("Gary")) {
            return new ResourceLocation("naturalist", "textures/entity/snail/gary.png");
        }
        if (snail.getSnailColor() != null) {
            int color = snail.getSnailColor().getId();
            return new ResourceLocation("naturalist", "textures/entity/snail/" + DyeColor.m_41053_((int)color).m_41065_() + ".png");
        }
        return new ResourceLocation("naturalist", "textures/entity/snail.png");
    }

    public ResourceLocation getAnimationResource(Snail snail) {
        return new ResourceLocation("naturalist", "animations/snail.rp_anim.json");
    }

    public void setCustomAnimations(Snail animatable, long instanceId, @Nullable AnimationState<Snail> animationState) {
        super.setCustomAnimations((GeoAnimatable)animatable, instanceId, animationState);
        if (animationState == null) {
            return;
        }
        EntityModelData extraDataOfType = (EntityModelData)animationState.getData(DataTickets.ENTITY_MODEL_DATA);
        CoreGeoBone leftEye = this.getAnimationProcessor().getBone("left_eye");
        CoreGeoBone rightEye = this.getAnimationProcessor().getBone("right_eye");
        CoreGeoBone eyes = this.getAnimationProcessor().getBone("eyes");
        if (animatable.m_6162_()) {
            eyes.setScaleX(1.5f);
            eyes.setScaleY(1.5f);
            eyes.setScaleZ(1.5f);
        } else {
            eyes.setScaleX(1.0f);
            eyes.setScaleY(1.0f);
            eyes.setScaleZ(1.0f);
        }
        if (!animatable.isClimbing() || !animatable.canHide()) {
            leftEye.setRotX(extraDataOfType.headPitch() * ((float)Math.PI / 180));
            leftEye.setRotY(extraDataOfType.netHeadYaw() * ((float)Math.PI / 180));
            rightEye.setRotX(extraDataOfType.headPitch() * ((float)Math.PI / 180));
            rightEye.setRotY(extraDataOfType.netHeadYaw() * ((float)Math.PI / 180));
        }
    }
}

