/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.naturalist.common.entity;

import com.starfish_studios.naturalist.common.entity.core.NaturalistGeoEntity;
import com.starfish_studios.naturalist.core.registry.NaturalistTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.util.RandomPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Dragonfly
extends PathfinderMob
implements NaturalistGeoEntity {
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final EntityDataAccessor<Integer> VARIANT_ID = SynchedEntityData.m_135353_(Dragonfly.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    @Nullable
    private BlockPos targetPosition;
    private int hoverTicks;
    protected static final RawAnimation FLY = RawAnimation.begin().thenLoop("animation.sf_nba.dragonfly.fly");

    @NotNull
    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    public Dragonfly(@NotNull EntityType<? extends PathfinderMob> entityType, Level level) {
        super(entityType, level);
        this.setHoverTicks(30);
        this.m_20242_(true);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 6.0);
    }

    public static boolean checkDragonflySpawnRules(EntityType<? extends Dragonfly> pType, ServerLevelAccessor pLevel, MobSpawnType pReason, BlockPos pPos, RandomSource pRandom) {
        return pLevel.m_8055_(pPos.m_7495_()).m_204336_(NaturalistTags.BlockTags.DRAGONFLIES_SPAWNABLE_ON);
    }

    public int getVariant() {
        return Mth.m_14045_((int)((Integer)this.f_19804_.m_135370_(VARIANT_ID)), (int)0, (int)2);
    }

    public void setVariant(int variant) {
        this.f_19804_.m_135381_(VARIANT_ID, (Object)variant);
    }

    public int getHoverTicks() {
        return this.hoverTicks;
    }

    public void setHoverTicks(int hoverTicks) {
        this.hoverTicks = hoverTicks;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VARIANT_ID, (Object)0);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("Variant", this.getVariant());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setVariant(compound.m_128451_("Variant"));
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        this.setVariant(level.m_213780_().m_188503_(3));
        return super.m_6518_(level, difficulty, reason, spawnData, dataTag);
    }

    public boolean m_6094_() {
        return false;
    }

    protected void m_7324_(Entity entity) {
    }

    protected void m_6138_() {
    }

    public void m_8119_() {
        super.m_8119_();
        this.m_20256_(this.m_20184_().m_82542_(1.0, 0.6, 1.0));
    }

    protected void m_8024_() {
        super.m_8024_();
        if (!(this.targetPosition == null || this.m_9236_().m_46859_(this.targetPosition) && this.targetPosition.m_123342_() > this.m_9236_().m_141937_())) {
            this.targetPosition = null;
        }
        if (this.getHoverTicks() > 0) {
            this.setHoverTicks(Math.max(0, this.getHoverTicks() - 1));
        } else if (this.targetPosition == null || this.targetPosition.m_203195_((Position)this.m_20182_(), 2.0)) {
            Vec3 randomPos = RandomPos.m_148542_((PathfinderMob)this, () -> new BlockPos((int)(this.m_20185_() + (double)this.f_19796_.m_188503_(7) - (double)this.f_19796_.m_188503_(7)), (int)(this.m_20186_() + (double)this.f_19796_.m_188503_(6) - 2.0), (int)(this.m_20189_() + (double)this.f_19796_.m_188503_(7) - (double)this.f_19796_.m_188503_(7))));
            Vec3i randomPos2 = new Vec3i((int)randomPos.f_82479_, (int)randomPos.f_82480_, (int)randomPos.f_82481_);
            this.targetPosition = new BlockPos(randomPos2);
            this.setHoverTicks(15);
        }
        if (this.targetPosition != null && this.getHoverTicks() <= 0) {
            double x = (double)this.targetPosition.m_123341_() + 0.5 - this.m_20185_();
            double y = (double)this.targetPosition.m_123342_() + 0.1 - this.m_20186_();
            double z = (double)this.targetPosition.m_123343_() + 0.5 - this.m_20189_();
            Vec3 vec3 = this.m_20184_();
            Vec3 vec32 = vec3.m_82520_((Math.signum(x) * 0.5 - vec3.f_82479_) * (double)0.1f, (Math.signum(y) * (double)0.7f - vec3.f_82480_) * (double)0.1f, (Math.signum(z) * 0.5 - vec3.f_82481_) * (double)0.1f);
            this.m_20256_(vec32);
            this.f_20902_ = 5.0f;
            float g = (float)(Mth.m_14136_((double)vec32.f_82481_, (double)vec32.f_82479_) * 57.2957763671875) - 90.0f;
            float h = Mth.m_14177_((float)(g - this.m_146908_()));
            this.m_146922_(this.m_146908_() + h);
        }
    }

    protected // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.EVENTS;
    }

    public boolean m_142535_(float fallDistance, float multiplier, DamageSource source) {
        return false;
    }

    protected void m_7840_(double y, boolean onGround, BlockState state, BlockPos pos) {
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
    }

    protected void m_5841_() {
    }

    public float m_21692_(BlockPos blockPos) {
        if (this.m_9236_().m_8055_(blockPos).m_60795_() && this.m_9236_().m_46801_(blockPos.m_6625_(2))) {
            return 10.0f;
        }
        return 0.0f;
    }

    @NotNull
    protected InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_150930_(Items.f_42730_)) {
            this.m_216990_(SoundEvents.f_11912_);
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            if (!this.m_9236_().f_46443_) {
                AreaEffectCloud areaEffectCloud = new AreaEffectCloud(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_());
                areaEffectCloud.m_19718_((LivingEntity)this);
                areaEffectCloud.m_19724_((ParticleOptions)ParticleTypes.f_123799_);
                areaEffectCloud.m_19712_(0.5f);
                areaEffectCloud.m_19734_(200);
                areaEffectCloud.m_19716_(new MobEffectInstance(MobEffects.f_19602_, 1, 1));
                areaEffectCloud.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
                this.m_9236_().m_7967_((Entity)areaEffectCloud);
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return super.m_6071_(player, hand);
    }

    public boolean m_21222_() {
        return true;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    protected <E extends Dragonfly> PlayState predicate(AnimationState<E> event) {
        event.getController().setAnimation(FLY);
        return PlayState.CONTINUE;
    }

    public void registerControllers(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
    }
}

