/*
 * Decompiled with CFR 0.152.
 */
package com.barion.dungeons_enhanced.world.structure.prefabs;

import com.barion.dungeons_enhanced.DEUtil;
import com.barion.dungeons_enhanced.registry.DEStructures;
import com.barion.dungeons_enhanced.world.gen.DETerrainAnalyzer;
import com.barion.dungeons_enhanced.world.structure.prefabs.DEBaseStructure;
import com.barion.dungeons_enhanced.world.structure.prefabs.utils.DEPieceAssembler;
import com.barion.dungeons_enhanced.world.structure.prefabs.utils.DEStructureTemplates;
import com.barion.dungeons_enhanced.world.structure.processor.DEUnderwaterProcessor;
import com.legacy.structure_gel.api.registry.registrar.Registrar;
import com.mojang.serialization.Codec;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public class DEUnderwaterStructure
extends DEBaseStructure {
    public static final String ID_SUNKEN_SHRINE = "sunken_shrine";
    public static final Codec<DEUnderwaterStructure> CODEC_SUNKEN_SHRINE = DEUnderwaterStructure.m_226607_(DEUnderwaterStructure::SunkenShrine);

    public static DEUnderwaterStructure SunkenShrine(Structure.StructureSettings settings) {
        return new DEUnderwaterStructure(settings, DEUtil.pieceBuilder().yOffset(-1).add("sunken_shrine/big").weight(3).add("sunken_shrine/small").build(), () -> DEStructures.SUNKEN_SHRINE.getType());
    }

    public DEUnderwaterStructure(Structure.StructureSettings settings, DEStructureTemplates variants, Supplier<StructureType<?>> type) {
        super(settings, variants, type);
    }

    @Override
    @Nonnull
    public Optional<Structure.GenerationStub> m_214086_(@Nonnull Structure.GenerationContext context) {
        DEStructureTemplates.Template piece = this._templates.getRandom((RandomSource)context.f_226626_());
        BlockPos pos = DEUtil.chunkPosToBlockPosFromHeightMap(context.f_226628_(), context.f_226622_(), Heightmap.Types.OCEAN_FLOOR_WG, context.f_226629_(), context.f_226624_()).m_6630_(piece.yOffset);
        if (!DETerrainAnalyzer.isUnderwater(pos, context.f_226622_(), 16, context.f_226629_(), context.f_226624_())) {
            return Optional.empty();
        }
        return DEUnderwaterStructure.at(pos, builder -> DEUnderwaterStructure.generatePieces(builder, pos, piece, Rotation.m_221990_((RandomSource)context.f_226626_()), context, DEUnderwaterStructure::assemble));
    }

    private static void assemble(DEPieceAssembler.Context context) {
        context.piecesBuilder().m_142679_((StructurePiece)new Piece(context.structureManager(), context.piece(), context.pos(), context.rotation()));
    }

    public static class Piece
    extends DEBaseStructure.Piece {
        public Piece(StructureTemplateManager structureManager, ResourceLocation templateName, BlockPos pos, Rotation rotation) {
            super((Registrar.Static<StructurePieceType>)DEStructures.SUNKEN_SHRINE.getPieceType(), structureManager, templateName, pos, rotation);
        }

        public Piece(StructurePieceSerializationContext serializationContext, CompoundTag nbt) {
            super((Registrar.Static<StructurePieceType>)DEStructures.SUNKEN_SHRINE.getPieceType(), serializationContext, nbt);
        }

        @Override
        protected void addProcessors(StructurePlaceSettings settings) {
            settings.m_74394_();
            settings.m_74383_((StructureProcessor)DEUnderwaterProcessor.INSTANCE);
        }
    }
}

