/*
 * Decompiled with CFR 0.152.
 */
package de.geheimagentnr1.easier_sleeping.sleeping;

import de.geheimagentnr1.easier_sleeping.config.DimensionListType;
import de.geheimagentnr1.easier_sleeping.config.ServerConfig;
import de.geheimagentnr1.easier_sleeping.sleeping.SleepingWorker;
import de.geheimagentnr1.minecraft_forge_api.events.ForgeEventHandlerInterface;
import java.util.Comparator;
import java.util.List;
import java.util.TreeMap;
import java.util.TreeSet;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.WorldWorkerManager;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

public class SleepingManager
implements ForgeEventHandlerInterface {
    @NotNull
    private static final Comparator<Player> PLAYER_COMPARATOR = Comparator.comparing(Entity::m_20148_);
    @NotNull
    private final ServerConfig serverConfig;
    private TreeMap<ResourceKey<Level>, TreeSet<ServerPlayer>> SLEEPING;

    private void init() {
        this.SLEEPING = new TreeMap(Comparator.comparing(ResourceKey::m_135782_));
    }

    void updateSleepingPlayers(@NotNull MinecraftServer server) {
        for (ServerLevel level : server.m_129785_()) {
            ResourceKey registrykey = level.m_46472_();
            boolean containsDimension = this.serverConfig.getDimensions().contains(registrykey);
            if (this.serverConfig.getDimensionListType() == DimensionListType.SLEEP_ACTIVE && !containsDimension || this.serverConfig.getDimensionListType() == DimensionListType.SLEEP_INACTIVE && containsDimension) continue;
            if (!this.SLEEPING.containsKey(registrykey)) {
                this.SLEEPING.put((ResourceKey<Level>)registrykey, new TreeSet<Player>(PLAYER_COMPARATOR));
            }
            TreeSet<ServerPlayer> sleeping_players = this.SLEEPING.get(registrykey);
            List level_players = level.m_6907_();
            int non_spectator_player_count = this.countNonSpectatorPlayers(level_players);
            for (ServerPlayer player2 : level_players) {
                if (player2.m_5803_() && !sleeping_players.contains(player2)) {
                    if (!player2.m_21257_().stream().noneMatch(pos -> this.serverConfig.getIgnoredBedBlocks().contains(BuiltInRegistries.f_256975_.m_7981_((Object)level.m_8055_(pos).m_60734_())))) continue;
                    sleeping_players.add(player2);
                    this.sendSleepMessage(level_players, sleeping_players.size(), non_spectator_player_count, (Player)player2);
                    continue;
                }
                if (player2.m_5803_() || !sleeping_players.contains(player2)) continue;
                sleeping_players.remove(player2);
                this.sendWakeMessage(level_players, sleeping_players.size(), non_spectator_player_count, (Player)player2);
            }
            int sleeping_percent = this.caculateSleepingPercent(this.countSleepingPlayers(sleeping_players), non_spectator_player_count);
            if (sleeping_percent < this.serverConfig.getSleepPercent() && (non_spectator_player_count <= 0 || non_spectator_player_count != sleeping_players.size())) continue;
            if (level.m_46469_().m_46207_(GameRules.f_46140_)) {
                long currentDayTime = level.m_46468_();
                long newDayTime = currentDayTime + 24000L - currentDayTime % 24000L;
                newDayTime = ForgeEventFactory.onSleepFinished((ServerLevel)level, (long)newDayTime, (long)currentDayTime);
                level.m_8615_(newDayTime);
            }
            sleeping_players.forEach(player -> {
                player.m_21257_().ifPresent(pos -> player.m_9158_(level.m_46472_(), pos, player.m_146908_(), false, false));
                player.m_6145_(false, false);
            });
            if (level.m_46469_().m_46207_(GameRules.f_46150_)) {
                level.m_8606_(0, 0, false, false);
            }
            if (this.serverConfig.getAllPlayersRest()) {
                level_players.forEach(player -> player.m_7166_(Stats.f_12988_.m_12902_((Object)Stats.f_12992_)));
            }
            this.sendMorningMessage(level_players);
            sleeping_players.clear();
        }
    }

    private int countNonSpectatorPlayers(@NotNull List<? extends Player> players) {
        int count = 0;
        for (Player player : players) {
            if (player.m_5833_()) continue;
            ++count;
        }
        return count;
    }

    private int countSleepingPlayers(@NotNull TreeSet<ServerPlayer> players) {
        int count = 0;
        for (ServerPlayer player : players) {
            if (!player.m_36317_()) continue;
            ++count;
        }
        return count;
    }

    private void sendWakeMessage(@NotNull List<? extends Player> players, int sleep_player_count, int non_spectator_player_count, @NotNull Player wake_player) {
        this.sendMessage(players, this.buildWakeSleepMessage(wake_player, sleep_player_count, non_spectator_player_count, this.serverConfig.getWakeMessage()));
    }

    private void sendSleepMessage(@NotNull List<? extends Player> players, int sleep_player_count, int non_spectator_player_count, @NotNull Player wake_player) {
        this.sendMessage(players, this.buildWakeSleepMessage(wake_player, sleep_player_count, non_spectator_player_count, this.serverConfig.getSleepMessage()));
    }

    private void sendMorningMessage(@NotNull List<? extends Player> players) {
        this.sendMessage(players, Component.m_237113_((String)this.serverConfig.getMorningMessage()));
    }

    private void sendMessage(@NotNull List<? extends Player> players, @NotNull MutableComponent message) {
        for (Player player : players) {
            player.m_213846_((Component)message.m_6270_(Style.f_131099_.m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.GRAY))));
        }
    }

    @NotNull
    private MutableComponent buildWakeSleepMessage(@NotNull Player player, int sleep_player_count, int player_count, @NotNull String message) {
        return Component.m_237113_((String)"").m_7220_(player.m_5446_()).m_130946_(String.format(" %s - %d/%d (%d%%)", message, sleep_player_count, player_count, this.caculateSleepingPercent(sleep_player_count, player_count)));
    }

    private int caculateSleepingPercent(int sleep_player_count, int non_spectator_player_count) {
        return non_spectator_player_count == 0 ? 0 : sleep_player_count * 100 / non_spectator_player_count;
    }

    @SubscribeEvent
    public void handleServerStartingEvent(@NotNull ServerStartingEvent event) {
        this.init();
        WorldWorkerManager.addWorker((WorldWorkerManager.IWorker)new SleepingWorker(this));
    }

    public SleepingManager(@NotNull ServerConfig serverConfig) {
        if (serverConfig == null) {
            throw new NullPointerException("serverConfig is marked non-null but is null");
        }
        this.serverConfig = serverConfig;
    }
}

