/*
 * Decompiled with CFR 0.152.
 */
package net.chaolux.lendersdelight.coomon.stat;

import java.util.EnumMap;
import net.chaolux.lendersdelight.coomon.stat.IPlayerStat;
import net.chaolux.lendersdelight.coomon.stat.StatType;
import net.minecraft.nbt.CompoundTag;

public class PlayerStatCapability
implements IPlayerStat {
    private final EnumMap<StatType, Float> stats = new EnumMap(StatType.class);

    public PlayerStatCapability() {
        for (StatType type : StatType.values()) {
            this.stats.put(type, Float.valueOf(0.0f));
        }
    }

    @Override
    public float getStat(StatType type) {
        return this.stats.getOrDefault((Object)type, Float.valueOf(0.0f)).floatValue();
    }

    @Override
    public void setStat(StatType type, float value) {
        this.stats.put(type, Float.valueOf(value));
    }

    @Override
    public void addStat(StatType type, float amount) {
        this.stats.put(type, Float.valueOf(this.getStat(type) + amount));
    }

    @Override
    public void copyFrom(IPlayerStat other) {
        for (StatType type : StatType.values()) {
            this.setStat(type, other.getStat(type));
        }
    }

    public CompoundTag saveNBT() {
        CompoundTag tag = new CompoundTag();
        for (StatType type : StatType.values()) {
            tag.m_128350_(type.name(), this.getStat(type));
        }
        return tag;
    }

    public void loadNBT(CompoundTag tag) {
        for (StatType type : StatType.values()) {
            if (!tag.m_128425_(type.name(), 5)) continue;
            this.setStat(type, tag.m_128457_(type.name()));
        }
    }
}

