/*
 * Decompiled with CFR 0.152.
 */
package net.chaolux.lendersdelight.coomon.stat;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.chaolux.lendersdelight.Config;
import net.chaolux.lendersdelight.coomon.stat.IPlayerStat;
import net.chaolux.lendersdelight.coomon.stat.PlayerStatProvider;
import net.chaolux.lendersdelight.coomon.stat.StatType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="lendersdelight", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class PlayerStatEvents {
    private static final UUID SPEED_MODIFIER_ID = UUID.fromString("59d51325-e4b3-4665-8a07-b36c5e137129");
    private static final UUID ATTACK_SPEED_MODIFIER_ID = UUID.fromString("9fd29c91-1c38-47b4-bc7a-8ed1be70fc7e");
    private static final UUID KNOCKBACK_RESISTANCE_MODIFIER_ID = UUID.fromString("ec4d9633-0151-46c5-bbb1-e571b34537e2");
    private static final UUID ATTACK_DAMAGE_MODIFIER_ID = UUID.fromString("00f6b2f5-a105-4abb-b7de-fee601a4e377");
    private static final UUID ARMOR_MODIFIER_ID = UUID.fromString("96a277cd-1712-4a4a-b1ab-b84a6429da51");
    private static final UUID SWIM_SPEED_MODIFIER_ID = UUID.fromString("1a94d5b0-0dbd-43fc-a39d-b5bbf7e1b838");
    private static final Map<UUID, CompoundTag> SAVED_STAT = new HashMap<UUID, CompoundTag>();

    @SubscribeEvent
    public static void onDeath(LivingDeathEvent event) {
        IPlayerStat cap;
        if (!((Boolean)Config.RESET_ON_DEATH.get()).booleanValue()) {
            return;
        }
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        LazyOptional capOptional = player.getCapability(PlayerStatProvider.PLAYER_STAT);
        if (capOptional.isPresent() && (cap = (IPlayerStat)capOptional.orElse(null)) != null) {
            CompoundTag saved = cap.saveToNBT();
            SAVED_STAT.put(player.m_20148_(), saved);
        }
    }

    @SubscribeEvent
    public static void onLogin(PlayerEvent.PlayerLoggedInEvent event) {
        PlayerStatProvider.sync(event.getEntity());
    }

    @SubscribeEvent
    public static void onRespawn(PlayerEvent.PlayerRespawnEvent event) {
        Player player = event.getEntity();
        CompoundTag saved = SAVED_STAT.remove(player.m_20148_());
        if (saved != null) {
            IPlayerStat cap;
            LazyOptional capOptional = player.getCapability(PlayerStatProvider.PLAYER_STAT);
            if (capOptional.isPresent() && (cap = (IPlayerStat)capOptional.orElse(null)) != null) {
                cap.loadFromNBT(saved);
            }
            PlayerStatProvider.sync(event.getEntity());
        }
    }

    @SubscribeEvent
    public static void onTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = event.player;
        player.getCapability(PlayerStatProvider.PLAYER_STAT).ifPresent(stats -> {
            AttributeInstance speedAttr = player.m_21051_(Attributes.f_22279_);
            AttributeInstance atkSpeedAttr = player.m_21051_(Attributes.f_22283_);
            AttributeInstance knockAttr = player.m_21051_(Attributes.f_22278_);
            AttributeInstance attackAttr = player.m_21051_(Attributes.f_22281_);
            AttributeInstance armorAttr = player.m_21051_(Attributes.f_22284_);
            AttributeInstance swimAttr = player.m_21051_((Attribute)ForgeMod.SWIM_SPEED.get());
            float regen = stats.getStat(StatType.PASSIVE_REGEN);
            if (speedAttr != null) {
                speedAttr.m_22120_(SPEED_MODIFIER_ID);
                float speed = stats.getStat(StatType.SPEED_BOOST);
                if (speed > 0.0f) {
                    speedAttr.m_22118_(new AttributeModifier(SPEED_MODIFIER_ID, "Speed Boost", (double)(speed / 100.0f), AttributeModifier.Operation.MULTIPLY_BASE));
                }
            }
            if (atkSpeedAttr != null) {
                atkSpeedAttr.m_22120_(ATTACK_SPEED_MODIFIER_ID);
                float atkSpeed = stats.getStat(StatType.ATTACK_SPEED);
                if (atkSpeed > 0.0f) {
                    atkSpeedAttr.m_22118_(new AttributeModifier(ATTACK_SPEED_MODIFIER_ID, "Attack Speed Boost", (double)(atkSpeed / 100.0f), AttributeModifier.Operation.MULTIPLY_BASE));
                }
            }
            if (knockAttr != null) {
                knockAttr.m_22120_(KNOCKBACK_RESISTANCE_MODIFIER_ID);
                float knock = stats.getStat(StatType.KNOCKBACK_RESISTANCE);
                if (knock > 0.0f) {
                    knockAttr.m_22118_(new AttributeModifier(KNOCKBACK_RESISTANCE_MODIFIER_ID, "Knockback Resistance", (double)(knock / 100.0f), AttributeModifier.Operation.MULTIPLY_BASE));
                }
            }
            if (attackAttr != null) {
                attackAttr.m_22120_(ATTACK_DAMAGE_MODIFIER_ID);
                float attack = stats.getStat(StatType.ATTACK_BOOTS);
                if (attack > 0.0f) {
                    attackAttr.m_22118_(new AttributeModifier(ATTACK_DAMAGE_MODIFIER_ID, "Attack Boost", (double)(attack / 100.0f), AttributeModifier.Operation.MULTIPLY_BASE));
                }
            }
            if (armorAttr != null) {
                armorAttr.m_22120_(ARMOR_MODIFIER_ID);
                float armor = stats.getStat(StatType.ARMOR_BOOST);
                if (armor > 0.0f) {
                    armorAttr.m_22118_(new AttributeModifier(ARMOR_MODIFIER_ID, "Armor", (double)(armor / 100.0f), AttributeModifier.Operation.MULTIPLY_BASE));
                }
            }
            if (swimAttr != null) {
                swimAttr.m_22120_(SWIM_SPEED_MODIFIER_ID);
                float swim = stats.getStat(StatType.SWIM_SPEED);
                if (swim > 0.0f) {
                    swimAttr.m_22118_(new AttributeModifier(SWIM_SPEED_MODIFIER_ID, "Swim Speed Boost", (double)(swim / 100.0f), AttributeModifier.Operation.MULTIPLY_BASE));
                }
            }
            if (regen > 0.0f && player.f_19797_ % 100 == 0) {
                player.m_5634_(regen / 100.0f);
            }
        });
    }

    @SubscribeEvent
    public static void onJump(LivingEvent.LivingJumpEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        player.getCapability(PlayerStatProvider.PLAYER_STAT).ifPresent(stats -> {
            float jump = stats.getStat(StatType.JUMP_BOOST);
            if (jump > 0.0f) {
                player.m_20334_(player.m_20184_().f_82479_, player.m_20184_().f_82480_ + (double)(jump / 500.0f), player.m_20184_().f_82481_);
            }
        });
    }

    @SubscribeEvent
    public static void onCrit(CriticalHitEvent event) {
        Player player = event.getEntity();
        player.getCapability(PlayerStatProvider.PLAYER_STAT).ifPresent(stats -> {
            float chance = stats.getStat(StatType.CRIT_CHANCE);
            if (chance > 0.0f && player.m_9236_().f_46441_.m_188501_() < chance / 100.0f) {
                event.setResult(Event.Result.ALLOW);
                event.setDamageModifier(1.5f);
            }
        });
    }
}

