/*
 * Decompiled with CFR 0.152.
 */
package net.chaolux.lendersdelight.coomon.stat;

import java.util.EnumMap;
import net.chaolux.lendersdelight.coomon.stat.IPlayerStat;
import net.chaolux.lendersdelight.coomon.stat.PlayerStatCapability;
import net.chaolux.lendersdelight.coomon.stat.StatCapabilityID;
import net.chaolux.lendersdelight.coomon.stat.StatSyncPacket;
import net.chaolux.lendersdelight.coomon.stat.StatType;
import net.chaolux.lendersdelight.registry.stat.ModNetwork;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import org.jetbrains.annotations.NotNull;

public class PlayerStatProvider
implements ICapabilitySerializable<CompoundTag> {
    public static final Capability<IPlayerStat> PLAYER_STAT = CapabilityManager.get((CapabilityToken)new CapabilityToken<IPlayerStat>(){});
    private final PlayerStatCapability backend = new PlayerStatCapability();
    private final LazyOptional<IPlayerStat> optional = LazyOptional.of(() -> this.backend);

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @NotNull Direction side) {
        return cap == PLAYER_STAT ? this.optional.cast() : LazyOptional.empty();
    }

    public CompoundTag serializeNBT() {
        return this.backend.saveNBT();
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.backend.loadNBT(nbt);
    }

    public static void attach(AttachCapabilitiesEvent<Entity> event) {
        Object object = event.getObject();
        if (object instanceof Player) {
            Player player = (Player)object;
            PlayerStatProvider provider = new PlayerStatProvider();
            event.addCapability(StatCapabilityID.PLAYER_STAT_ID, (ICapabilityProvider)provider);
        }
    }

    public static LazyOptional<IPlayerStat> get(Player player) {
        return player.getCapability(PLAYER_STAT);
    }

    public static void sync(Player player) {
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        player.getCapability(PLAYER_STAT).ifPresent(cap -> {
            EnumMap<StatType, Float> data = new EnumMap<StatType, Float>(StatType.class);
            for (StatType type : StatType.values()) {
                data.put(type, Float.valueOf(cap.getStat(type)));
            }
            ModNetwork.sendToClient(serverPlayer, new StatSyncPacket(data));
        });
    }
}

