/*
 * Decompiled with CFR 0.152.
 */
package net.chaolux.lendersdelight.coomon.stat;

import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.chaolux.lendersdelight.Config;
import net.chaolux.lendersdelight.coomon.stat.PlayerStatProvider;
import net.chaolux.lendersdelight.coomon.stat.StatType;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.LazyOptional;
import vectorwing.farmersdelight.common.item.ConsumableItem;

public class StatConsumableItem
extends ConsumableItem {
    private final Map<StatType, Float> statBonus;

    public StatConsumableItem(Item.Properties properties, boolean hasFoodEffectTooltip, Map<StatType, Float> statBonus) {
        super(properties, hasFoodEffectTooltip);
        this.statBonus = statBonus;
    }

    public Map<StatType, Float> getStatBonus() {
        return this.statBonus;
    }

    public ItemStack m_5922_(ItemStack stack, Level level, LivingEntity entity) {
        ItemStack result = super.m_5922_(stack, level, entity);
        if (!((Boolean)Config.ENABLE_STAT.get()).booleanValue()) {
            return result;
        }
        if (!level.f_46443_ && entity instanceof Player) {
            Player player = (Player)entity;
            if (!this.statBonus.isEmpty()) {
                level.m_7654_().execute(() -> {
                    LazyOptional optional = player.getCapability(PlayerStatProvider.PLAYER_STAT);
                    if (optional.isPresent()) {
                        optional.ifPresent(stats -> {
                            for (Map.Entry<StatType, Float> entry : this.statBonus.entrySet()) {
                                stats.addStat(entry.getKey(), entry.getValue().floatValue());
                            }
                            PlayerStatProvider.sync(player);
                        });
                    }
                });
            }
        }
        return result;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag isAdvanced) {
        if (!Config.showTooltipStat) {
            return;
        }
        int currentSize = tooltip.size();
        super.m_7373_(stack, level, tooltip, isAdvanced);
        if (!this.statBonus.isEmpty()) {
            if (tooltip.size() > currentSize) {
                tooltip.add((Component)Component.m_237119_());
            }
            tooltip.add((Component)Component.m_237115_((String)"tooltip.lendersdelight.stat").m_130940_(ChatFormatting.DARK_GREEN));
            for (Map.Entry<StatType, Float> entry : this.statBonus.entrySet()) {
                StatType type = entry.getKey();
                float value = entry.getValue().floatValue();
                tooltip.add((Component)Component.m_237113_((String)("+" + value + "% ")).m_7220_((Component)Component.m_237115_((String)type.getLangKey())).m_130940_(ChatFormatting.BLUE));
            }
        }
    }
}

