/*
 * Decompiled with CFR 0.152.
 */
package net.chaolux.lendersdelight.coomon.stat;

import java.util.EnumMap;
import java.util.Map;
import java.util.function.Supplier;
import net.chaolux.lendersdelight.coomon.stat.PlayerStatProvider;
import net.chaolux.lendersdelight.coomon.stat.StatType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public class StatSyncPacket {
    private final Map<StatType, Float> data;

    public StatSyncPacket(Map<StatType, Float> data) {
        this.data = data;
    }

    public static void encode(StatSyncPacket packet, FriendlyByteBuf buf) {
        buf.m_130130_(packet.data.size());
        for (Map.Entry<StatType, Float> entry : packet.data.entrySet()) {
            buf.m_130068_((Enum)entry.getKey());
            buf.writeFloat(entry.getValue().floatValue());
        }
    }

    public static StatSyncPacket decode(FriendlyByteBuf buf) {
        int size = buf.m_130242_();
        EnumMap<StatType, Float> map = new EnumMap<StatType, Float>(StatType.class);
        for (int i = 0; i < size; ++i) {
            StatType type = (StatType)buf.m_130066_(StatType.class);
            float value = buf.readFloat();
            map.put(type, Float.valueOf(value));
        }
        return new StatSyncPacket(map);
    }

    public static void handle(StatSyncPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> StatSyncPacket.applyToClient(packet.data));
        ctx.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void applyToClient(Map<StatType, Float> map) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        player.getCapability(PlayerStatProvider.PLAYER_STAT).ifPresent(cap -> {
            for (Map.Entry entry : map.entrySet()) {
                cap.setStat((StatType)((Object)((Object)entry.getKey())), ((Float)entry.getValue()).floatValue());
            }
        });
    }
}

