/*
 * Decompiled with CFR 0.152.
 */
package com.milamber_brass.brass_armory.behaviour.ammo;

import com.milamber_brass.brass_armory.behaviour.ammo.AbstractAmmoBehaviour;
import com.milamber_brass.brass_armory.behaviour.iGun;
import com.milamber_brass.brass_armory.behaviour.powder.AbstractPowderBehaviour;
import com.milamber_brass.brass_armory.entity.projectile.BulletEntity;
import com.milamber_brass.brass_armory.init.BrassArmoryItems;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
public class BundleShotAmmoBehaviour
extends AbstractAmmoBehaviour {
    @Override
    public boolean onShoot(Level level, LivingEntity owner, Entity shooter, ItemStack ammoStack, @Nullable AbstractPowderBehaviour powderBehaviour, iGun gun) {
        super.onShoot(level, owner, shooter, ammoStack, powderBehaviour, gun);
        int iMax = 10;
        for (int i = 0; i < iMax; ++i) {
            BulletEntity bullet = new BulletEntity(level, owner);
            if (powderBehaviour != null) {
                powderBehaviour.applyEffect((Entity)bullet);
            }
            if (level.f_46443_) continue;
            float speed = gun.speed();
            bullet.m_146884_(shooter.m_146892_());
            bullet.m_37251_(shooter, shooter.m_146909_(), shooter.m_146908_(), 0.0f, speed, gun.accuracy());
            bullet.m_36781_(gun.damage() / (double)iMax / (double)speed);
            gun.onShoot(level, owner, shooter, ammoStack, (Projectile)bullet);
            if (level.m_7967_((Entity)bullet)) continue;
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public Predicate<ItemStack> getAmmoItems() {
        return itemStack -> itemStack.m_150930_((Item)BrassArmoryItems.BUNDLE_SHOT.get()) || itemStack.m_150930_(Items.f_41832_);
    }
}

