/*
 * Decompiled with CFR 0.152.
 */
package com.milamber_brass.brass_armory.client.particle;

import com.milamber_brass.brass_armory.init.BrassArmoryParticles;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
@ParametersAreNonnullByDefault
public class BloodParticle
extends TextureSheetParticle {
    BloodParticle(ClientLevel level, double x, double y, double z) {
        super(level, x, y, z);
        this.m_107250_(0.01f, 0.01f);
        this.f_107226_ = 0.08f;
    }

    @NotNull
    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107430_;
    }

    public void m_5989_() {
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        this.preMoveUpdate();
        if (!this.f_107220_) {
            this.f_107216_ -= (double)this.f_107226_;
            this.m_6257_(this.f_107215_, this.f_107216_, this.f_107217_);
            this.postMoveUpdate();
            if (!this.f_107220_) {
                this.f_107215_ *= 0.98;
                this.f_107216_ *= 0.98;
                this.f_107217_ *= 0.98;
            }
        }
    }

    protected void preMoveUpdate() {
        if (this.f_107225_-- <= 0) {
            this.m_107274_();
        }
    }

    protected void postMoveUpdate() {
    }

    public static class BloodLandProvider
    implements ParticleProvider<SimpleParticleType> {
        protected final SpriteSet sprite;

        public BloodLandProvider(SpriteSet spriteSet) {
            this.sprite = spriteSet;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double x1, double y1, double z1) {
            LandParticle particle = new LandParticle(level, x, y, z);
            ((BloodParticle)particle).f_107225_ = (int)(28.0 / (Math.random() * 0.8 + 0.2));
            particle.m_107253_(0.54f, 0.01f, 0.01f);
            particle.m_108335_(this.sprite);
            return particle;
        }
    }

    public static class BloodFallProvider
    implements ParticleProvider<SimpleParticleType> {
        protected final SpriteSet sprite;

        public BloodFallProvider(SpriteSet spriteSet) {
            this.sprite = spriteSet;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double x1, double y1, double z1) {
            FallParticle particle = new FallParticle(level, x, y, z, (ParticleOptions)BrassArmoryParticles.BLOOD_LAND_PARTICLE.get());
            particle.m_107253_(0.54f, 0.01f, 0.01f);
            particle.m_108335_(this.sprite);
            return particle;
        }
    }

    static class LandParticle
    extends BloodParticle {
        LandParticle(ClientLevel level, double x, double y, double z) {
            super(level, x, y, z);
            this.f_107225_ = (int)(16.0 / (Math.random() * 0.8 + 0.2));
        }
    }

    static class FallParticle
    extends BloodParticle {
        protected final ParticleOptions landParticle;

        FallParticle(ClientLevel level, double x, double y, double z, ParticleOptions particleOptions) {
            super(level, x, y, z);
            this.f_107225_ = (int)(64.0 / (Math.random() * 0.8 + 0.1));
            this.landParticle = particleOptions;
        }

        @Override
        protected void postMoveUpdate() {
            if (this.f_107218_) {
                this.m_107274_();
                this.f_107208_.m_7106_(this.landParticle, this.f_107212_, this.f_107213_, this.f_107214_, 0.0, 0.0, 0.0);
            }
        }
    }
}

