/*
 * Decompiled with CFR 0.152.
 */
package com.milamber_brass.brass_armory.effect;

import com.milamber_brass.brass_armory.data.BrassArmoryDamageTypes;
import com.milamber_brass.brass_armory.init.BrassArmoryEffects;
import com.milamber_brass.brass_armory.init.BrassArmoryParticles;
import com.milamber_brass.brass_armory.util.ArmoryUtil;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;

@ParametersAreNonnullByDefault
public class BleedEffect
extends MobEffect {
    public BleedEffect() {
        super(MobEffectCategory.HARMFUL, 5688317);
    }

    public void m_6742_(LivingEntity living, int amplifier) {
        int duration = Objects.requireNonNull(living.m_21124_((MobEffect)BrassArmoryEffects.BLEEDING.get())).m_19557_();
        if (living.m_9236_().f_46443_) {
            int iMax = amplifier > 100 ? 100 : (living.m_9236_().f_46441_.m_188503_(100) <= duration ? 1 : 0) + amplifier;
            double y = living.m_21224_() ? living.m_20186_() + 0.15 : living.m_20187_() - 0.25;
            for (int i = 0; i < iMax; ++i) {
                living.m_9236_().m_7106_((ParticleOptions)BrassArmoryParticles.BLOOD_FALL_PARTICLE.get(), living.m_20208_(0.5), y, living.m_20262_(0.5), 0.0, 0.0, 0.0);
            }
        } else if (duration == 1 || amplifier >= 20 || duration % (20 - amplifier) == 0) {
            if (amplifier > 0 && duration <= 1) {
                living.m_7292_(new MobEffectInstance((MobEffect)BrassArmoryEffects.BLEEDING.get(), 20, amplifier - 1, false, false, true));
                return;
            }
            living.m_6469_(ArmoryUtil.getDamageSource(living.m_9236_(), BrassArmoryDamageTypes.BLEED), 1.0f + (float)(amplifier / 2));
        }
    }

    public boolean m_6584_(int duration, int amplifier) {
        return true;
    }

    public static void bleedHarder(LivingEntity living, int duration, int bonus) {
        MobEffectInstance instance = living.m_21124_((MobEffect)BrassArmoryEffects.BLEEDING.get());
        int newDuration = Math.max(instance != null ? instance.m_19557_() : 0, duration);
        int newAmplifier = (instance != null ? instance.m_19564_() + 1 : 0) + bonus;
        living.m_7292_(new MobEffectInstance((MobEffect)BrassArmoryEffects.BLEEDING.get(), newDuration, newAmplifier, false, false, true));
    }

    public static void witherHarder(LivingEntity living, int duration) {
        MobEffectInstance instance = living.m_21124_((MobEffect)BrassArmoryEffects.BLEEDING.get());
        living.m_7292_(new MobEffectInstance(MobEffects.f_19615_, instance != null ? instance.m_19557_() + instance.m_19564_() * 20 : duration, 0));
    }
}

