/*
 * Decompiled with CFR 0.152.
 */
package com.milamber_brass.brass_armory.entity.projectile;

import com.milamber_brass.brass_armory.data.BrassArmoryDamageTypes;
import com.milamber_brass.brass_armory.entity.projectile.abstracts.AbstractThrownWeaponEntity;
import com.milamber_brass.brass_armory.init.BrassArmoryEntityTypes;
import com.milamber_brass.brass_armory.init.BrassArmoryItems;
import com.milamber_brass.brass_armory.init.BrassArmorySounds;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
public class DaggerEntity
extends AbstractThrownWeaponEntity {
    public DaggerEntity(EntityType<DaggerEntity> entityType, Level level) {
        super(entityType, level);
    }

    public DaggerEntity(LivingEntity livingEntity, Level level, ItemStack daggerStack) {
        super((EntityType<? extends AbstractArrow>)((EntityType)BrassArmoryEntityTypes.DAGGER.get()), livingEntity, level, daggerStack);
    }

    @Override
    protected ResourceKey<DamageType> onHitDamageType() {
        return BrassArmoryDamageTypes.DAGGER;
    }

    @Override
    protected SoundEvent onHitSoundEvent() {
        return (SoundEvent)BrassArmorySounds.DAGGER_HIT.get();
    }

    @Override
    @NotNull
    protected SoundEvent m_7239_() {
        return (SoundEvent)BrassArmorySounds.DAGGER_HIT_GROUND.get();
    }

    @Override
    protected Item getDefaultItem() {
        return (Item)BrassArmoryItems.WOODEN_DAGGER.get();
    }
}

