/*
 * Decompiled with CFR 0.152.
 */
package com.milamber_brass.brass_armory.entity.projectile;

import com.milamber_brass.brass_armory.data.BrassArmoryDamageTypes;
import com.milamber_brass.brass_armory.entity.projectile.abstracts.AbstractRollableItemProjectileEntity;
import com.milamber_brass.brass_armory.init.BrassArmoryEntityTypes;
import com.milamber_brass.brass_armory.init.BrassArmoryItems;
import com.milamber_brass.brass_armory.init.BrassArmorySounds;
import com.milamber_brass.brass_armory.item.SpikyBallItem;
import com.milamber_brass.brass_armory.util.ArmoryUtil;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
public class SpikyBallEntity
extends AbstractRollableItemProjectileEntity {
    public static final long INTERVAL = 600L;

    public SpikyBallEntity(EntityType<? extends ThrowableItemProjectile> entityType, Level level) {
        super(entityType, level);
    }

    public SpikyBallEntity(Level level, double x, double y, double z) {
        super((EntityType<? extends ThrowableItemProjectile>)((EntityType)BrassArmoryEntityTypes.SPIKY_BALL.get()), x, y, z, level);
    }

    public SpikyBallEntity(Level level, LivingEntity living, @Nullable HumanoidArm arm) {
        super((EntityType<? extends ThrowableItemProjectile>)((EntityType)BrassArmoryEntityTypes.SPIKY_BALL.get()), living, level, arm);
    }

    public SpikyBallEntity(Level level, LivingEntity living) {
        this(level, living, null);
    }

    @Override
    public void m_8119_() {
        Object object;
        super.m_8119_();
        if (this.f_19797_ > 10 && (object = this.m_7846_().m_41720_()) instanceof SpikyBallItem) {
            SpikyBallItem spikyBallItem = (SpikyBallItem)((Object)object);
            for (Entity entity : this.m_9236_().m_6249_((Entity)this, this.m_20191_(), Entity::m_6084_)) {
                LivingEntity living;
                if (!(entity instanceof LivingEntity) || !(living = (LivingEntity)entity).m_6469_(ArmoryUtil.getDamageSource(this.m_9236_(), BrassArmoryDamageTypes.SPIKY_BALL), spikyBallItem.m_43314_().m_6631_() + 1.0f) || !this.hurt()) continue;
                return;
            }
        }
    }

    @Override
    protected void onGroundTick() {
        if (!this.m_9236_().f_46443_ && this.m_9236_().m_46467_() % 600L == 0L && this.hurt()) {
            return;
        }
        super.onGroundTick();
    }

    protected boolean hurt() {
        ServerPlayer serverPlayer;
        Entity entity;
        ItemStack stack = this.m_7846_().m_41777_();
        if (stack.m_220157_(1, this.m_9236_().f_46441_, (entity = this.m_19749_()) instanceof ServerPlayer ? (serverPlayer = (ServerPlayer)entity) : null)) {
            Entity entity2 = this.m_19749_();
            if (entity2 instanceof Player) {
                Player player = (Player)entity2;
                player.m_36246_(Stats.f_12983_.m_12902_((Object)stack.m_41720_()));
            }
            this.m_146870_();
            return true;
        }
        this.m_37446_(stack);
        return false;
    }

    @Override
    @NotNull
    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        ItemStack handStack = player.m_21120_(hand);
        if (handStack.m_41619_()) {
            player.m_21008_(hand, this.m_7846_());
            this.m_146870_();
            return InteractionResult.SUCCESS;
        }
        if (handStack.m_150930_(this.m_7846_().m_41720_()) && handStack.m_41613_() < handStack.m_41741_()) {
            handStack.m_41769_(1);
            this.m_146870_();
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    protected SoundEvent getSoundEvent() {
        return (SoundEvent)BrassArmorySounds.SPIKY_BALL_HIT.get();
    }

    @Override
    protected float getVolumeMultiplier() {
        return 0.5f;
    }

    @Override
    protected double getBounceMultiplier() {
        return 0.2;
    }

    @Nonnull
    protected Item m_7881_() {
        return (Item)BrassArmoryItems.IRON_SPIKY_BALL.get();
    }
}

