/*
 * Decompiled with CFR 0.152.
 */
package com.milamber_brass.brass_armory.entity.projectile.abstracts;

import com.milamber_brass.brass_armory.init.BrassArmorySounds;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
public abstract class AbstractBulletEntity
extends AbstractArrow
implements ItemSupplier {
    private static final EntityDataAccessor<ItemStack> DATA_ITEM_STACK = SynchedEntityData.m_135353_(AbstractBulletEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);

    protected AbstractBulletEntity(EntityType<? extends AbstractArrow> entityType, Level level) {
        super(entityType, level);
    }

    protected AbstractBulletEntity(EntityType<? extends AbstractArrow> entityType, double x, double y, double z, Level level) {
        super(entityType, x, y, z, level);
    }

    protected AbstractBulletEntity(EntityType<? extends AbstractArrow> entityType, LivingEntity living, Level level) {
        super(entityType, living, level);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(DATA_ITEM_STACK, (Object)ItemStack.f_41583_);
    }

    protected void m_6901_() {
        ++this.f_36697_;
        if (this.f_36697_ >= 600) {
            this.m_146870_();
        }
    }

    protected void m_8060_(BlockHitResult blockHitResult) {
        this.f_36696_ = this.m_9236_().m_8055_(blockHitResult.m_82425_());
        BlockState blockstate = this.m_9236_().m_8055_(blockHitResult.m_82425_());
        blockstate.m_60669_(this.m_9236_(), blockstate, blockHitResult, (Projectile)this);
        Vec3 vec3 = blockHitResult.m_82450_().m_82492_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        this.m_20256_(vec3);
        Vec3 vec31 = vec3.m_82541_().m_82490_(0.05);
        this.m_20343_(this.m_20185_() - vec31.f_82479_, this.m_20186_() - vec31.f_82480_, this.m_20189_() - vec31.f_82481_);
        this.m_5496_(this.m_36784_(), 1.0f, 1.2f / (this.f_19796_.m_188501_() * 0.2f + 0.9f));
        this.f_36703_ = true;
        this.f_36706_ = 40;
        this.m_36762_(false);
        this.m_36767_((byte)0);
        this.m_36740_(this.m_7239_());
        this.m_36793_(false);
        this.m_36723_();
    }

    protected void m_5790_(EntityHitResult entityHitResult) {
        Entity entity = entityHitResult.m_82443_();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            int arrowCount = living.m_21234_();
            super.m_5790_(entityHitResult);
            living.m_21317_(arrowCount);
        } else {
            super.m_5790_(entityHitResult);
        }
    }

    @NotNull
    protected SoundEvent m_7239_() {
        return (SoundEvent)BrassArmorySounds.BULLET_HIT.get();
    }

    public void m_6123_(Player player) {
    }

    protected boolean m_142470_(Player player) {
        return false;
    }

    @NotNull
    protected ItemStack m_7941_() {
        return ItemStack.f_41583_;
    }

    @NotNull
    public Component m_7755_() {
        return this.m_7846_().m_41720_().m_7626_(this.m_7846_());
    }

    @NotNull
    public ItemStack m_7846_() {
        ItemStack itemstack = this.getItemRaw();
        return itemstack.m_41619_() ? new ItemStack((ItemLike)this.getDefaultItem()) : itemstack;
    }

    public void setItem(ItemStack itemStack) {
        this.m_20088_().m_135381_(DATA_ITEM_STACK, (Object)((ItemStack)Util.m_137469_((Object)itemStack.m_41777_(), stack -> stack.m_41764_(1))));
    }

    protected ItemStack getItemRaw() {
        return (ItemStack)this.m_20088_().m_135370_(DATA_ITEM_STACK);
    }

    protected abstract Item getDefaultItem();

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        ItemStack stack = this.getItemRaw();
        if (!stack.m_41619_()) {
            tag.m_128365_("BulletStack", (Tag)stack.m_41739_(new CompoundTag()));
        }
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setItem(ItemStack.m_41712_((CompoundTag)tag.m_128469_("BulletStack")));
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

