/*
 * Decompiled with CFR 0.152.
 */
package com.milamber_brass.brass_armory.init;

import com.milamber_brass.brass_armory.BrassArmory;
import com.milamber_brass.brass_armory.behaviour.GunBehaviours;
import com.milamber_brass.brass_armory.data.BrassArmoryTags;
import com.milamber_brass.brass_armory.init.BrassArmoryItems;
import com.milamber_brass.brass_armory.item.BombItem;
import com.milamber_brass.brass_armory.item.CannonItem;
import com.milamber_brass.brass_armory.item.CarcassRoundItem;
import com.milamber_brass.brass_armory.item.FlintlockItem;
import com.milamber_brass.brass_armory.item.GliderItem;
import com.milamber_brass.brass_armory.item.KatanaItem;
import com.milamber_brass.brass_armory.item.SpecialArrowItem;
import com.milamber_brass.brass_armory.item.WarpCrystalItem;
import com.milamber_brass.brass_armory.util.ArmoryUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.StandingAndWallBlockItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.TorchBlock;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class BrassArmoryItemGroups {
    public static final DeferredRegister<CreativeModeTab> REGISTRY = DeferredRegister.create((ResourceKey)Registries.f_279569_, (String)"brass_armory");
    public static final RegistryObject<CreativeModeTab> BRASS_ARMORY = REGISTRY.register("brass_armory", () -> CreativeModeTab.builder().m_257941_((Component)Component.m_237115_((String)"itemGroup.brass_armory")).m_257737_(() -> new ItemStack((ItemLike)BrassArmoryItems.GOLDEN_BATTLEAXE.get())).withSearchBar(79).withBackgroundLocation(BrassArmory.locate("textures/gui/creative_tab.png")).withLabelColor(0xFFAA00).m_257501_((parameters, output) -> {
        ArrayList katanaItems = new ArrayList();
        ArrayList tieredItems = new ArrayList();
        ArrayList bowItems = new ArrayList();
        ArrayList gunItems = new ArrayList();
        ArrayList ammoItems = new ArrayList();
        ArrayList bombItems = new ArrayList();
        ArrayList arrowItems = new ArrayList();
        ArrayList blockItems = new ArrayList();
        ArrayList warpCrystalItems = new ArrayList();
        ArrayList gliderItems = new ArrayList();
        ArrayList cannonStuff = new ArrayList();
        List<Item> allItems = BrassArmoryItems.REGISTRY.getEntries().stream().map(RegistryObject::get).filter(item -> {
            if (item instanceof KatanaItem) {
                KatanaItem katanaItem = (KatanaItem)((Object)((Object)((Object)item)));
                katanaItems.add(katanaItem);
                return false;
            }
            if (item instanceof TieredItem) {
                TieredItem tieredItem = (TieredItem)item;
                tieredItems.add(tieredItem);
                return false;
            }
            if (item instanceof BowItem) {
                BowItem bowItem = (BowItem)item;
                bowItems.add(bowItem);
                return false;
            }
            if (item instanceof CannonItem || item.m_7968_().m_204117_(BrassArmoryTags.Items.CANNON_AMMO) && !item.m_7968_().m_204117_(BrassArmoryTags.Items.BOMB)) {
                cannonStuff.add(item);
                return false;
            }
            if (item instanceof FlintlockItem) {
                FlintlockItem gunItem = (FlintlockItem)item;
                gunItems.add(gunItem);
                return false;
            }
            if (item instanceof BombItem) {
                BombItem bombItem = (BombItem)((Object)((Object)((Object)item)));
                bombItems.add(bombItem);
                return false;
            }
            if (item instanceof SpecialArrowItem) {
                SpecialArrowItem arrowItem = (SpecialArrowItem)((Object)((Object)((Object)item)));
                arrowItems.add(arrowItem);
                return false;
            }
            if (item instanceof BlockItem) {
                BlockItem blockItem = (BlockItem)item;
                blockItems.add(blockItem);
                return false;
            }
            if (item instanceof WarpCrystalItem) {
                WarpCrystalItem warpCrystalItem = (WarpCrystalItem)((Object)((Object)((Object)item)));
                warpCrystalItems.add(warpCrystalItem);
                return false;
            }
            if (item instanceof GliderItem) {
                GliderItem gliderItem = (GliderItem)((Object)((Object)((Object)item)));
                gliderItems.add(gliderItem);
                return false;
            }
            if (GunBehaviours.itemHasAmmoBehaviour(item)) {
                ammoItems.add(item);
                return false;
            }
            return true;
        }).toList();
        tieredItems.stream().sorted(Comparator.comparingDouble(tieredItem -> {
            Tier tier = tieredItem.m_43314_();
            if (tier == Tiers.WOOD) {
                return 0.1;
            }
            if (tier == Tiers.STONE) {
                return 0.2;
            }
            if (tier == Tiers.GOLD) {
                return 0.3;
            }
            if (tier == Tiers.IRON) {
                return 0.4;
            }
            if (tier == Tiers.DIAMOND) {
                return 0.5;
            }
            if (tier == Tiers.NETHERITE) {
                return 0.6;
            }
            return tieredItem.m_43314_().m_6631_();
        })).forEach(arg_0 -> ((CreativeModeTab.Output)output).m_246326_(arg_0));
        katanaItems.forEach(arg_0 -> ((CreativeModeTab.Output)output).m_246326_(arg_0));
        output.m_246342_((ItemStack)Util.m_137469_((Object)((SwordItem)BrassArmoryItems.KATANA.get()).m_7968_(), stack -> KatanaItem.setWither(stack, 100)));
        allItems.forEach(arg_0 -> ((CreativeModeTab.Output)output).m_246326_(arg_0));
        blockItems.forEach(arg_0 -> ((CreativeModeTab.Output)output).m_246326_(arg_0));
        warpCrystalItems.stream().sorted(Comparator.comparingInt(WarpCrystalItem::getMaxDistance)).forEach(arg_0 -> ((CreativeModeTab.Output)output).m_246326_(arg_0));
        gliderItems.forEach(arg_0 -> ((CreativeModeTab.Output)output).m_246326_(arg_0));
        gunItems.stream().sorted(Comparator.comparingDouble(FlintlockItem::getDamageMultiplier)).forEach(arg_0 -> ((CreativeModeTab.Output)output).m_246326_(arg_0));
        ammoItems.forEach(arg_0 -> ((CreativeModeTab.Output)output).m_246326_(arg_0));
        bombItems.forEach(arg_0 -> ((CreativeModeTab.Output)output).m_246326_(arg_0));
        bowItems.forEach(arg_0 -> ((CreativeModeTab.Output)output).m_246326_(arg_0));
        arrowItems.forEach(arg_0 -> ((CreativeModeTab.Output)output).m_246326_(arg_0));
        for (Item item2 : ForgeRegistries.ITEMS.getValues()) {
            StandingAndWallBlockItem torchItem;
            if (!(item2 instanceof StandingAndWallBlockItem) || !((torchItem = (StandingAndWallBlockItem)item2).m_40614_() instanceof TorchBlock)) continue;
            output.m_246342_((ItemStack)Util.m_137469_((Object)((SpecialArrowItem)((Object)((Object)((Object)BrassArmoryItems.TORCH_ARROW.get())))).m_7968_(), stack -> ArmoryUtil.addStack(stack.m_41784_(), torchItem.m_7968_(), "BATorch")));
        }
        cannonStuff.remove(BrassArmoryItems.CARCASS_ROUND.get());
        cannonStuff.forEach(arg_0 -> ((CreativeModeTab.Output)output).m_246326_(arg_0));
        output.m_246326_((ItemLike)BrassArmoryItems.CARCASS_ROUND.get());
        output.m_246342_((ItemStack)Util.m_137469_((Object)((CarcassRoundItem)((Object)((Object)((Object)BrassArmoryItems.CARCASS_ROUND.get())))).m_7968_(), stack -> stack.m_41784_().m_128379_("BADragonRound", true)));
        for (Potion potion : ForgeRegistries.POTIONS.getValues()) {
            if (potion == Potions.f_43598_) continue;
            output.m_246342_(PotionUtils.m_43549_((ItemStack)((CarcassRoundItem)((Object)((Object)((Object)BrassArmoryItems.CARCASS_ROUND.get())))).m_7968_(), (Potion)potion));
        }
    }).m_257652_());

    public static void register(IEventBus eventBus) {
        REGISTRY.register(eventBus);
    }
}

