/*
 * Decompiled with CFR 0.152.
 */
package com.milamber_brass.brass_armory.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.milamber_brass.brass_armory.item.abstracts.AbstractThrownWeaponItem;
import com.milamber_brass.brass_armory.util.ArmoryUtil;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.Vanishable;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeMod;

public class HalberdItem
extends TieredItem
implements Vanishable {
    protected Multimap<Attribute, AttributeModifier> axeModifiers;
    protected final float axeDamage;
    protected final float axeSpeed;
    protected final float axeReach;
    protected Multimap<Attribute, AttributeModifier> spearModifiers;
    protected final float spearDamage;
    protected final float spearSpeed;
    protected final float spearReach;

    public HalberdItem(Tier tier, float axeDamage, float axeSpeed, float axeReach, float spearDamage, float spearSpeed, float spearReach, Item.Properties properties) {
        super(tier, properties);
        this.axeDamage = axeDamage + tier.m_6631_();
        this.axeSpeed = axeSpeed;
        this.axeReach = axeReach;
        this.spearDamage = spearDamage + tier.m_6631_();
        this.spearSpeed = spearSpeed;
        this.spearReach = spearReach;
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack;
        HalberdItem.setStance(itemstack, !HalberdItem.getStance(itemstack = player.m_21120_(hand)));
        player.m_36335_().m_41524_((Item)this, 10);
        return InteractionResultHolder.m_19096_((Object)itemstack);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        ImmutableMultimap.Builder builder;
        if (this.axeModifiers == null) {
            builder = ImmutableMultimap.builder();
            builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon damage modifier", (double)this.axeDamage, AttributeModifier.Operation.ADDITION));
            builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon speed modifier", (double)this.axeSpeed, AttributeModifier.Operation.ADDITION));
            builder.put((Object)((Attribute)ForgeMod.ENTITY_REACH.get()), (Object)new AttributeModifier(AbstractThrownWeaponItem.BASE_ATTACK_RANGE_UUID, "Weapon range modifier", (double)this.axeReach, AttributeModifier.Operation.ADDITION));
            this.axeModifiers = builder.build();
        }
        if (this.spearModifiers == null) {
            builder = ImmutableMultimap.builder();
            builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon damage modifier", (double)this.spearDamage, AttributeModifier.Operation.ADDITION));
            builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon speed modifier", (double)this.spearSpeed, AttributeModifier.Operation.ADDITION));
            builder.put((Object)((Attribute)ForgeMod.ENTITY_REACH.get()), (Object)new AttributeModifier(AbstractThrownWeaponItem.BASE_ATTACK_RANGE_UUID, "Weapon range modifier", (double)this.spearReach, AttributeModifier.Operation.ADDITION));
            this.spearModifiers = builder.build();
        }
        return slot == EquipmentSlot.MAINHAND ? (HalberdItem.getStance(stack) ? this.spearModifiers : this.axeModifiers) : super.getAttributeModifiers(slot, stack);
    }

    @ParametersAreNonnullByDefault
    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        if (!entity.m_9236_().f_46443_ && entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            if (HalberdItem.getStance(stack)) {
                ArmoryUtil.impaleLivingEntity(living, (float)player.m_21133_(Attributes.f_22281_), player.m_9236_().f_46441_);
            }
        }
        return false;
    }

    public boolean canDisableShield(ItemStack stack, ItemStack shield, LivingEntity entity, LivingEntity attacker) {
        return !HalberdItem.getStance(stack);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return super.canApplyAtEnchantingTable(stack, enchantment) || enchantment.f_44672_ == EnchantmentCategory.WEAPON && enchantment != Enchantments.f_44983_;
    }

    @ParametersAreNonnullByDefault
    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        stack.m_41622_(1, attacker, entity -> entity.m_21166_(EquipmentSlot.MAINHAND));
        return true;
    }

    @ParametersAreNonnullByDefault
    public boolean m_6813_(ItemStack stack, Level worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        if ((double)state.m_60800_((BlockGetter)worldIn, pos) != 0.0) {
            stack.m_41622_(2, entityLiving, entity -> entity.m_21166_(EquipmentSlot.MAINHAND));
        }
        return true;
    }

    @ParametersAreNonnullByDefault
    public static void setStance(ItemStack stack, boolean stance) {
        stack.m_41784_().m_128379_("BrassArmoryStance", stance);
    }

    @ParametersAreNonnullByDefault
    public static boolean getStance(ItemStack stack) {
        return stack.m_41784_().m_128471_("BrassArmoryStance");
    }
}

