/*
 * Decompiled with CFR 0.152.
 */
package com.milamber_brass.brass_armory.item.abstracts;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.Vanishable;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

@ParametersAreNonnullByDefault
public abstract class AbstractTieredWeaponItem
extends TieredItem
implements Vanishable {
    protected Multimap<Attribute, AttributeModifier> defaultModifiers;
    protected final float attackDamage;

    public AbstractTieredWeaponItem(Tier tier, float attackDamage, float attackSpeed, Item.Properties properties) {
        super(tier, properties);
        this.attackDamage = attackDamage;
        ImmutableMultimap.Builder<Attribute, AttributeModifier> builder = this.setDefaultModifiers(attackDamage + tier.m_6631_(), attackSpeed);
        this.defaultModifiers = builder == null ? null : builder.build();
    }

    protected ImmutableMultimap.Builder<Attribute, AttributeModifier> setDefaultModifiers(float attackDamage, float attackSpeed) {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon damage modifier", (double)attackDamage, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon speed modifier", (double)attackSpeed, AttributeModifier.Operation.ADDITION));
        return builder;
    }

    public float getAttackDamage() {
        return this.attackDamage;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        return slot == EquipmentSlot.MAINHAND && this.defaultModifiers != null ? this.defaultModifiers : super.getAttributeModifiers(slot, stack);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return super.canApplyAtEnchantingTable(stack, enchantment) || enchantment.f_44672_ == EnchantmentCategory.WEAPON && enchantment != Enchantments.f_44983_;
    }

    public boolean m_6777_(BlockState blockState, Level level, BlockPos blockPos, Player player) {
        return !player.m_7500_();
    }

    public float m_8102_(ItemStack stack, BlockState state) {
        if (state.m_60713_(Blocks.f_50033_)) {
            return 15.0f;
        }
        return state.m_204336_(BlockTags.f_278398_) ? 1.5f : 1.0f;
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        stack.m_41622_(1, attacker, entity -> entity.m_21166_(EquipmentSlot.MAINHAND));
        return true;
    }

    public boolean m_6813_(ItemStack stack, Level worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        if ((double)state.m_60800_((BlockGetter)worldIn, pos) != 0.0) {
            stack.m_41622_(2, entityLiving, entity -> entity.m_21166_(EquipmentSlot.MAINHAND));
        }
        return true;
    }
}

