/*
 * Decompiled with CFR 0.152.
 */
package com.milamber_brass.brass_armory.util;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.EntityBasedExplosionDamageCalculator;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
public class Impact
extends Explosion {
    public Impact(Level level, @Nullable Entity entity, Vec3 pos, float range, boolean fire, Explosion.BlockInteraction blockInteraction) {
        super(level, entity, pos.f_82479_, pos.f_82480_, pos.f_82481_, range, fire, blockInteraction);
    }

    @NotNull
    public ExplosionDamageCalculator m_46062_(@Nullable Entity entity) {
        return entity == null ? new ImpactDamageCalculator() : new EntityBasedImpactDamageCalculator(entity);
    }

    public void m_46075_(boolean emitter) {
        Level level = this.f_46012_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Vec3 vec3 = this.getPosition();
            this.f_46012_.m_6263_(null, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, SoundEvents.f_11913_, SoundSource.BLOCKS, 4.0f, (1.0f + (this.f_46012_.f_46441_.m_188501_() - this.f_46012_.f_46441_.m_188501_()) * 0.2f) * 3.7f);
            if (this.f_46010_ != Explosion.BlockInteraction.KEEP) {
                ObjectArrayList list = new ObjectArrayList();
                Collections.shuffle(this.f_46020_);
                for (BlockPos blockpos : this.f_46020_) {
                    BlockState blockstate = this.f_46012_.m_8055_(blockpos);
                    if (blockstate.m_60795_()) continue;
                    BlockPos blockpos1 = blockpos.m_7949_();
                    this.f_46012_.m_46473_().m_6180_("explosion_blocks");
                    if (blockstate.canDropFromExplosion((BlockGetter)this.f_46012_, blockpos, (Explosion)this)) {
                        BlockEntity blockentity = blockstate.m_155947_() ? this.f_46012_.m_7702_(blockpos) : null;
                        LootParams.Builder builder = new LootParams.Builder(serverLevel).m_287286_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)blockpos)).m_287286_(LootContextParams.f_81463_, (Object)ItemStack.f_41583_).m_287289_(LootContextParams.f_81462_, (Object)blockentity).m_287289_(LootContextParams.f_81455_, (Object)this.f_46016_);
                        if (this.f_46010_ == Explosion.BlockInteraction.DESTROY) {
                            builder.m_287286_(LootContextParams.f_81464_, (Object)Float.valueOf(this.f_46017_));
                        }
                        blockstate.m_287290_(builder).forEach(itemStack -> Impact.m_46067_((ObjectArrayList)list, (ItemStack)itemStack, (BlockPos)blockpos1));
                    }
                    if (emitter) {
                        this.f_46012_.m_46796_(2001, blockpos, Block.m_49956_((BlockState)blockstate));
                    }
                    blockstate.onBlockExploded(this.f_46012_, blockpos, (Explosion)this);
                    this.f_46012_.m_46473_().m_7238_();
                }
                for (Pair pair : list) {
                    Block.m_49840_((Level)this.f_46012_, (BlockPos)((BlockPos)pair.getSecond()), (ItemStack)((ItemStack)pair.getFirst()));
                }
            }
            if (this.f_46009_) {
                for (BlockPos blockpos2 : this.f_46020_) {
                    if (this.f_46011_.m_188503_(3) != 0 || !this.f_46012_.m_8055_(blockpos2).m_60795_() || !this.f_46012_.m_8055_(blockpos2.m_7495_()).m_60804_((BlockGetter)this.f_46012_, blockpos2.m_7495_())) continue;
                    this.f_46012_.m_46597_(blockpos2, BaseFireBlock.m_49245_((BlockGetter)this.f_46012_, (BlockPos)blockpos2));
                }
            }
        }
    }

    public static float projectileImpact(Entity entity, BlockPos pos) {
        return entity.m_9236_().m_8055_(pos).m_60734_().m_155943_() / (float)Math.min(entity.m_20184_().m_82553_(), 2.0);
    }

    public static class ImpactDamageCalculator
    extends ExplosionDamageCalculator {
        @NotNull
        public Optional<Float> m_6617_(Explosion explosion, BlockGetter blockGetter, BlockPos blockPos, BlockState blockState, FluidState fluidState) {
            return super.m_6617_(explosion, blockGetter, blockPos, blockState, fluidState).map(f -> Float.valueOf(f.floatValue() * 0.2f));
        }
    }

    public static class EntityBasedImpactDamageCalculator
    extends EntityBasedExplosionDamageCalculator {
        public EntityBasedImpactDamageCalculator(Entity source) {
            super(source);
        }

        @NotNull
        public Optional<Float> m_6617_(Explosion explosion, BlockGetter blockGetter, BlockPos blockPos, BlockState blockState, FluidState fluidState) {
            return super.m_6617_(explosion, blockGetter, blockPos, blockState, fluidState).map(f -> Float.valueOf(this.f_45892_.m_7077_(explosion, blockGetter, blockPos, blockState, fluidState, f.floatValue()) * 0.2f));
        }
    }
}

