/*
 * Decompiled with CFR 0.152.
 */
package fuzs.betteranimationscollection.client.element;

import fuzs.betteranimationscollection.client.element.ModelElement;
import fuzs.betteranimationscollection.client.model.JigglySlimeModel;
import fuzs.betteranimationscollection.mixin.client.accessor.SlimeOuterLayerAccessor;
import fuzs.puzzleslib.api.config.v3.ValueCallback;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.client.model.SlimeModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.renderer.entity.layers.SlimeOuterLayer;
import net.minecraftforge.common.ForgeConfigSpec;

public class JigglySlimeElement
extends ModelElement {
    public static int animationSpeed;
    private final ModelLayerLocation animatedSlime;
    private final ModelLayerLocation animatedSlimeOuter;

    public JigglySlimeElement(BiFunction<String, String, ModelLayerLocation> factory) {
        this.animatedSlime = factory.apply("animated_slime", "main");
        this.animatedSlimeOuter = factory.apply("animated_slime", "outer");
    }

    @Override
    public String[] modelDescription() {
        return new String[]{"A pleasing visual change; this makes the insides of slimes flow around like liquid.", "They splish-splosh about even more when they jump. The eyes, the mouth, and the core itself all move independently."};
    }

    @Override
    void onRegisterAnimatedModels(ModelElement.AnimatedModelsContext context, ModelElement.EntityModelBakery bakery) {
        context.registerAnimatedModel(SlimeModel.class, () -> new JigglySlimeModel(bakery.bakeLayer(this.animatedSlime)), (renderLayerParent, renderLayer) -> {
            if (renderLayer instanceof SlimeOuterLayer) {
                ((SlimeOuterLayerAccessor)renderLayer).setModel(new JigglySlimeModel(bakery.bakeLayer(this.animatedSlimeOuter)));
            }
            return Optional.empty();
        });
    }

    @Override
    public void onRegisterLayerDefinitions(BiConsumer<ModelLayerLocation, Supplier<LayerDefinition>> context) {
        context.accept(this.animatedSlime, SlimeModel::m_170958_);
        context.accept(this.animatedSlimeOuter, SlimeModel::m_170956_);
    }

    @Override
    public void setupModelConfig(ForgeConfigSpec.Builder builder, ValueCallback callback) {
        callback.accept((ForgeConfigSpec.ConfigValue)builder.comment("Animation swing speed of inner slime parts.").defineInRange("animation_speed", 5, 1, 20), v -> {
            animationSpeed = v;
        });
    }
}

