/*
 * Decompiled with CFR 0.152.
 */
package fuzs.betteranimationscollection.client.model;

import fuzs.betteranimationscollection.client.element.BuckaChickenElement;
import fuzs.betteranimationscollection.mixin.client.accessor.LayerDefinitionAccessor;
import net.minecraft.client.model.ChickenModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;

public class BuckaChickenModel<T extends Entity>
extends ChickenModel<T> {
    private final ModelPart head;
    private final ModelPart rightWing;
    private final ModelPart leftWing;
    private final ModelPart redThing;
    private final ModelPart slimRedThing;
    private final ModelPart billTop;
    private final ModelPart slimBillTop;
    private final ModelPart billBottom;
    private final ModelPart slimBillBottom;

    public BuckaChickenModel(ModelPart modelPart) {
        super(modelPart);
        this.head = modelPart.m_171324_("head");
        this.rightWing = modelPart.m_171324_("right_wing");
        this.leftWing = modelPart.m_171324_("left_wing");
        this.billTop = this.head.m_171324_("bill_top");
        this.slimBillTop = this.head.m_171324_("slim_bill_top");
        this.billBottom = this.billTop.m_171324_("bill_bottom");
        this.slimBillBottom = this.slimBillTop.m_171324_("slim_bill_bottom");
        this.redThing = this.billBottom.m_171324_("red_thing");
        this.slimRedThing = this.slimBillBottom.m_171324_("slim_red_thing");
    }

    public static LayerDefinition createAnimatedBodyLayer() {
        LayerDefinition layerDefinition = ChickenModel.m_170491_();
        MeshDefinition meshDefinition = ((LayerDefinitionAccessor)layerDefinition).getMesh();
        PartDefinition partDefinition = meshDefinition.m_171576_();
        PartDefinition partDefinition1 = partDefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-2.0f, -6.0f, -2.0f, 4.0f, 6.0f, 3.0f), PartPose.m_171419_((float)0.0f, (float)15.0f, (float)-4.0f));
        partDefinition.m_171599_("beak", CubeListBuilder.m_171558_(), PartPose.f_171404_);
        partDefinition.m_171599_("red_thing", CubeListBuilder.m_171558_(), PartPose.f_171404_);
        PartDefinition partDefinition2 = partDefinition1.m_171599_("bill_top", CubeListBuilder.m_171558_().m_171514_(14, 0).m_171481_(-2.0f, -4.0f, -4.0f, 4.0f, 1.0f, 2.0f), PartPose.f_171404_);
        PartDefinition partDefinition3 = partDefinition2.m_171599_("bill_bottom", CubeListBuilder.m_171558_().m_171514_(14, 1).m_171481_(-2.0f, 0.0f, -2.0f, 4.0f, 1.0f, 2.0f), PartPose.m_171419_((float)0.0f, (float)-3.0f, (float)-2.0f));
        PartDefinition partDefinition22 = partDefinition1.m_171599_("slim_bill_top", CubeListBuilder.m_171558_().m_171514_(15, 0).m_171481_(-1.0f, -4.0f, -4.0f, 2.0f, 1.0f, 2.0f), PartPose.f_171404_);
        PartDefinition partDefinition33 = partDefinition22.m_171599_("slim_bill_bottom", CubeListBuilder.m_171558_().m_171514_(15, 1).m_171481_(-1.0f, 0.0f, -2.0f, 2.0f, 1.0f, 2.0f), PartPose.m_171419_((float)0.0f, (float)-3.0f, (float)-2.0f));
        CubeListBuilder cubeListBuilder = CubeListBuilder.m_171558_().m_171514_(14, 4).m_171481_(-1.0f, 0.0f, -1.0f, 2.0f, 2.0f, 2.0f);
        PartPose partPose = PartPose.m_171419_((float)0.0f, (float)1.0f, (float)0.0f);
        partDefinition3.m_171599_("red_thing", cubeListBuilder, partPose);
        partDefinition33.m_171599_("slim_red_thing", cubeListBuilder, partPose);
        partDefinition.m_171599_("right_wing", CubeListBuilder.m_171558_().m_171514_(24, 13).m_171481_(0.0f, 0.0f, -3.0f, 1.0f, 4.0f, 6.0f), PartPose.m_171419_((float)3.0f, (float)13.0f, (float)0.0f));
        partDefinition.m_171599_("left_wing", CubeListBuilder.m_171558_().m_171514_(24, 13).m_171481_(-1.0f, 0.0f, -3.0f, 1.0f, 4.0f, 6.0f), PartPose.m_171419_((float)-3.0f, (float)13.0f, (float)0.0f));
        return layerDefinition;
    }

    public void m_6973_(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.m_6973_(entityIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        if (ageInTicks == 0.0f && BuckaChickenElement.moveWings) {
            float wingSwingAmount = limbSwingAmount * (float)BuckaChickenElement.wingAnimationSpeed * 0.1f;
            float wingFlapRot = Mth.m_14031_((float)limbSwing) * wingSwingAmount + wingSwingAmount;
            this.rightWing.f_104205_ = -wingFlapRot;
            this.leftWing.f_104205_ = wingFlapRot;
        } else {
            this.rightWing.f_104205_ = -ageInTicks;
            this.leftWing.f_104205_ = ageInTicks;
        }
        if (BuckaChickenElement.moveHead) {
            this.head.f_104202_ = -4.0f + Mth.m_14089_((float)limbSwing) * (float)BuckaChickenElement.headAnimationSpeed * 0.5f * limbSwingAmount;
        }
        if (BuckaChickenElement.moveWattles) {
            this.redThing.f_104205_ = Mth.m_14031_((float)limbSwing) * (float)BuckaChickenElement.wattlesAnimationSpeed * 0.1f * limbSwingAmount;
        }
        this.copyAllBeakParts();
    }

    public void m_6839_(T entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTickTime) {
        if (entitylivingbaseIn instanceof Mob) {
            Mob mob = (Mob)entitylivingbaseIn;
            int soundTime = mob.f_21363_ + mob.m_8100_();
            if (0 < soundTime && soundTime < 8) {
                float rotation = Math.abs(Mth.m_14031_((float)((float)soundTime * (float)Math.PI / 5.0f)));
                this.billBottom.f_104203_ = rotation * 0.75f;
            } else {
                this.billBottom.f_104203_ = 0.0f;
            }
        }
        this.setModelPartVisibilities();
    }

    private void copyAllBeakParts() {
        this.slimBillBottom.m_104315_(this.billBottom);
        this.slimBillTop.m_104315_(this.billTop);
        this.slimRedThing.m_104315_(this.redThing);
    }

    private void setModelPartVisibilities() {
        this.billTop.f_104207_ = !BuckaChickenElement.slimBill;
        this.slimBillTop.f_104207_ = BuckaChickenElement.slimBill;
        this.billBottom.f_104207_ = !BuckaChickenElement.slimBill;
        this.slimBillBottom.f_104207_ = BuckaChickenElement.slimBill;
        this.redThing.f_104207_ = !BuckaChickenElement.slimBill;
        this.slimRedThing.f_104207_ = BuckaChickenElement.slimBill;
    }
}

