/*
 * Decompiled with CFR 0.152.
 */
package fuzs.betteranimationscollection.client.model;

import com.google.common.collect.ImmutableList;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.client.model.HorseModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.animal.horse.AbstractHorse;

public class FamiliarHorseModel<T extends AbstractHorse>
extends HorseModel<T> {
    private final ModelPart headParts;
    private final ModelPart upperMouth;
    private final ModelPart lowerMouth;
    private final ModelPart mouthSaddleWrap;
    private final ModelPart lowerMouthSaddleWrap;
    private final ModelPart leftHindLeg;
    private final ModelPart rightHindLeg;
    private final ModelPart leftFrontLeg;
    private final ModelPart rightFrontLeg;
    private final ModelPart leftHindShin;
    private final ModelPart rightHindShin;
    private final ModelPart leftFrontShin;
    private final ModelPart rightFrontShin;
    private final ModelPart leftHindBabyLeg;
    private final ModelPart rightHindBabyLeg;
    private final ModelPart leftFrontBabyLeg;
    private final ModelPart rightFrontBabyLeg;
    private final ModelPart leftHindBabyShin;
    private final ModelPart rightHindBabyShin;
    private final ModelPart leftFrontBabyShin;
    private final ModelPart rightFrontBabyShin;
    private final ModelPart rightSaddleMouth;
    private final ModelPart leftSaddleMouth;

    public FamiliarHorseModel(ModelPart modelPart) {
        super(modelPart);
        this.headParts = modelPart.m_171324_("head_parts");
        this.upperMouth = this.headParts.m_171324_("upper_mouth");
        this.lowerMouth = this.headParts.m_171324_("lower_mouth");
        this.rightHindLeg = modelPart.m_171324_("right_hind_leg");
        this.leftHindLeg = modelPart.m_171324_("left_hind_leg");
        this.rightFrontLeg = modelPart.m_171324_("right_front_leg");
        this.leftFrontLeg = modelPart.m_171324_("left_front_leg");
        this.rightHindShin = modelPart.m_171324_("right_hind_shin");
        this.leftHindShin = modelPart.m_171324_("left_hind_shin");
        this.rightFrontShin = modelPart.m_171324_("right_front_shin");
        this.leftFrontShin = modelPart.m_171324_("left_front_shin");
        this.rightHindBabyLeg = modelPart.m_171324_("right_hind_baby_leg");
        this.leftHindBabyLeg = modelPart.m_171324_("left_hind_baby_leg");
        this.rightFrontBabyLeg = modelPart.m_171324_("right_front_baby_leg");
        this.leftFrontBabyLeg = modelPart.m_171324_("left_front_baby_leg");
        this.rightHindBabyShin = modelPart.m_171324_("right_hind_baby_shin");
        this.leftHindBabyShin = modelPart.m_171324_("left_hind_baby_shin");
        this.rightFrontBabyShin = modelPart.m_171324_("right_front_baby_shin");
        this.leftFrontBabyShin = modelPart.m_171324_("left_front_baby_shin");
        this.leftSaddleMouth = this.headParts.m_171324_("left_saddle_mouth");
        this.rightSaddleMouth = this.headParts.m_171324_("right_saddle_mouth");
        this.mouthSaddleWrap = this.headParts.m_171324_("mouth_saddle_wrap");
        this.lowerMouthSaddleWrap = this.headParts.m_171324_("lower_mouth_saddle_wrap");
    }

    public static MeshDefinition createAnimatedBodyMesh(CubeDeformation cubeDeformation) {
        MeshDefinition meshDefinition = HorseModel.m_170669_((CubeDeformation)cubeDeformation);
        PartDefinition partDefinition = meshDefinition.m_171576_();
        PartDefinition partDefinition3 = partDefinition.m_171599_("head_parts", CubeListBuilder.m_171558_().m_171514_(0, 35).m_171481_(-2.05f, -6.0f, -2.0f, 4.0f, 12.0f, 7.0f), PartPose.m_171430_((float)0.5235988f, (float)0.0f, (float)0.0f));
        partDefinition3.m_171599_("upper_mouth", CubeListBuilder.m_171558_().m_171514_(0, 25).m_171488_(-2.0f, -11.0f, -7.0f, 4.0f, 3.0f, 5.0f, cubeDeformation), PartPose.f_171404_);
        partDefinition3.m_171599_("lower_mouth", CubeListBuilder.m_171558_().m_171514_(0, 28).m_171488_(-2.0f, -8.0f, -7.0f, 4.0f, 2.0f, 5.0f, cubeDeformation), PartPose.f_171404_);
        partDefinition.m_171599_("left_hind_leg", CubeListBuilder.m_171558_().m_171514_(48, 21).m_171480_().m_171488_(-3.0f, -1.01f, -1.0f, 4.0f, 5.0f, 4.0f, cubeDeformation), PartPose.m_171419_((float)4.0f, (float)14.0f, (float)7.0f));
        partDefinition.m_171599_("right_hind_leg", CubeListBuilder.m_171558_().m_171514_(48, 21).m_171488_(-1.0f, -1.01f, -1.0f, 4.0f, 5.0f, 4.0f, cubeDeformation), PartPose.m_171419_((float)-4.0f, (float)14.0f, (float)7.0f));
        partDefinition.m_171599_("left_front_leg", CubeListBuilder.m_171558_().m_171514_(48, 21).m_171480_().m_171488_(-3.0f, -1.01f, -1.9f, 4.0f, 5.0f, 4.0f, cubeDeformation), PartPose.m_171419_((float)4.0f, (float)6.0f, (float)-12.0f));
        partDefinition.m_171599_("right_front_leg", CubeListBuilder.m_171558_().m_171514_(48, 21).m_171488_(-1.0f, -1.01f, -1.9f, 4.0f, 5.0f, 4.0f, cubeDeformation), PartPose.m_171419_((float)-4.0f, (float)6.0f, (float)-12.0f));
        partDefinition.m_171599_("left_hind_shin", CubeListBuilder.m_171558_().m_171514_(48, 26).m_171480_().m_171488_(-3.0f, 0.99f, -1.0f, 4.0f, 6.0f, 4.0f, cubeDeformation), PartPose.m_171419_((float)4.0f, (float)17.0f, (float)7.0f));
        partDefinition.m_171599_("right_hind_shin", CubeListBuilder.m_171558_().m_171514_(48, 26).m_171488_(-1.0f, 0.99f, -1.0f, 4.0f, 6.0f, 4.0f, cubeDeformation), PartPose.m_171419_((float)-4.0f, (float)17.0f, (float)7.0f));
        partDefinition.m_171599_("left_front_shin", CubeListBuilder.m_171558_().m_171514_(48, 26).m_171480_().m_171488_(-3.0f, 0.99f, -1.9f, 4.0f, 6.0f, 4.0f, cubeDeformation), PartPose.m_171419_((float)4.0f, (float)9.0f, (float)-12.0f));
        partDefinition.m_171599_("right_front_shin", CubeListBuilder.m_171558_().m_171514_(48, 26).m_171488_(-1.0f, 0.99f, -1.9f, 4.0f, 6.0f, 4.0f, cubeDeformation), PartPose.m_171419_((float)-4.0f, (float)9.0f, (float)-12.0f));
        CubeDeformation cubeDeformation2 = cubeDeformation.m_171471_(0.0f, 1.0f, 0.0f);
        partDefinition.m_171599_("left_hind_baby_leg", CubeListBuilder.m_171558_().m_171514_(48, 21).m_171480_().m_171488_(-3.0f, 0.01f, -1.0f, 4.0f, 5.0f, 4.0f, cubeDeformation2), PartPose.m_171419_((float)4.0f, (float)14.0f, (float)7.0f));
        partDefinition.m_171599_("right_hind_baby_leg", CubeListBuilder.m_171558_().m_171514_(48, 21).m_171488_(-1.0f, 0.01f, -1.0f, 4.0f, 5.0f, 4.0f, cubeDeformation2), PartPose.m_171419_((float)-4.0f, (float)14.0f, (float)7.0f));
        partDefinition.m_171599_("left_front_baby_leg", CubeListBuilder.m_171558_().m_171514_(48, 21).m_171480_().m_171488_(-3.0f, 0.01f, -1.9f, 4.0f, 5.0f, 4.0f, cubeDeformation2), PartPose.m_171419_((float)4.0f, (float)6.0f, (float)-12.0f));
        partDefinition.m_171599_("right_front_baby_leg", CubeListBuilder.m_171558_().m_171514_(48, 21).m_171488_(-1.0f, 0.01f, -1.9f, 4.0f, 5.0f, 4.0f, cubeDeformation2), PartPose.m_171419_((float)-4.0f, (float)6.0f, (float)-12.0f));
        partDefinition.m_171599_("left_hind_baby_shin", CubeListBuilder.m_171558_().m_171514_(48, 26).m_171480_().m_171488_(-3.0f, 4.01f, -1.0f, 4.0f, 6.0f, 4.0f, cubeDeformation2), PartPose.m_171419_((float)4.0f, (float)17.0f, (float)7.0f));
        partDefinition.m_171599_("right_hind_baby_shin", CubeListBuilder.m_171558_().m_171514_(48, 26).m_171488_(-1.0f, 4.01f, -1.0f, 4.0f, 6.0f, 4.0f, cubeDeformation2), PartPose.m_171419_((float)-4.0f, (float)17.0f, (float)7.0f));
        partDefinition.m_171599_("left_front_baby_shin", CubeListBuilder.m_171558_().m_171514_(48, 26).m_171480_().m_171488_(-3.0f, 4.01f, -1.9f, 4.0f, 6.0f, 4.0f, cubeDeformation2), PartPose.m_171419_((float)4.0f, (float)9.0f, (float)-12.0f));
        partDefinition.m_171599_("right_front_baby_shin", CubeListBuilder.m_171558_().m_171514_(48, 26).m_171488_(-1.0f, 4.01f, -1.9f, 4.0f, 6.0f, 4.0f, cubeDeformation2), PartPose.m_171419_((float)-4.0f, (float)9.0f, (float)-12.0f));
        partDefinition3.m_171599_("left_saddle_mouth", CubeListBuilder.m_171558_().m_171514_(29, 5).m_171488_(2.0f, -9.0f, -5.0f, 1.0f, 2.0f, 2.0f, cubeDeformation), PartPose.f_171404_);
        partDefinition3.m_171599_("right_saddle_mouth", CubeListBuilder.m_171558_().m_171514_(29, 5).m_171488_(-3.0f, -9.0f, -5.0f, 1.0f, 2.0f, 2.0f, cubeDeformation), PartPose.f_171404_);
        CubeDeformation cubeDeformation1 = new CubeDeformation(0.2f);
        partDefinition3.m_171599_("head_saddle", CubeListBuilder.m_171558_().m_171514_(1, 1).m_171488_(-3.0f, -11.0f, -1.9f, 6.0f, 5.0f, 6.0f, cubeDeformation1), PartPose.f_171404_);
        partDefinition3.m_171599_("mouth_saddle_wrap", CubeListBuilder.m_171558_().m_171514_(19, 0).m_171488_(-2.0f, -11.0f, -4.0f, 4.0f, 3.0f, 2.0f, cubeDeformation1), PartPose.f_171404_);
        partDefinition3.m_171599_("lower_mouth_saddle_wrap", CubeListBuilder.m_171558_().m_171514_(19, 0).m_171488_(-2.0f, -8.0f, -4.0f, 4.0f, 2.0f, 2.0f, cubeDeformation1), PartPose.f_171404_);
        return meshDefinition;
    }

    protected Iterable<ModelPart> m_5608_() {
        return (Iterable)Stream.concat(StreamSupport.stream(super.m_5608_().spliterator(), false), Stream.of(this.leftHindShin, this.rightHindShin, this.leftFrontShin, this.rightFrontShin, this.leftHindBabyShin, this.rightHindBabyShin, this.leftFrontBabyShin, this.rightFrontBabyShin)).collect(ImmutableList.toImmutableList());
    }

    public void m_6973_(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.m_6973_(entityIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        this.lowerMouthSaddleWrap.f_104207_ = entityIn.m_6254_();
    }

    public void m_6839_(T entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTickTime) {
        super.m_6839_(entitylivingbaseIn, limbSwing, limbSwingAmount, partialTickTime);
        float f = Mth.m_14189_((float)((AbstractHorse)entitylivingbaseIn).f_20884_, (float)((AbstractHorse)entitylivingbaseIn).f_20883_, (float)partialTickTime);
        float f1 = Mth.m_14189_((float)((AbstractHorse)entitylivingbaseIn).f_20886_, (float)((AbstractHorse)entitylivingbaseIn).f_20885_, (float)partialTickTime);
        float f2 = Mth.m_14179_((float)partialTickTime, (float)((AbstractHorse)entitylivingbaseIn).f_19860_, (float)entitylivingbaseIn.m_146909_());
        float f3 = f1 - f;
        float f4 = f2 * ((float)Math.PI / 180);
        f3 = Mth.m_14036_((float)f3, (float)-20.0f, (float)20.0f);
        if (limbSwingAmount > 0.2f) {
            f4 += Mth.m_14089_((float)(limbSwing * 0.4f)) * 0.15f * limbSwingAmount;
        }
        float f5 = entitylivingbaseIn.m_30663_(partialTickTime);
        float f6 = entitylivingbaseIn.m_30667_(partialTickTime);
        float f7 = 1.0f - f6;
        float f8 = entitylivingbaseIn.m_30533_(partialTickTime);
        float f9 = (float)((AbstractHorse)entitylivingbaseIn).f_19797_ + partialTickTime;
        this.headParts.f_104201_ = 4.0f;
        this.headParts.f_104202_ = -12.0f;
        this.headParts.f_104203_ = 0.5235988f + f4;
        this.headParts.f_104204_ = f3 * ((float)Math.PI / 180);
        float f10 = entitylivingbaseIn.m_20069_() ? 0.2f : 1.0f;
        float f11 = Mth.m_14089_((float)(f10 * limbSwing * 0.6662f + (float)Math.PI));
        float f12 = f11 * 1.8f * limbSwingAmount;
        float f13 = f11 * 1.4f * limbSwingAmount;
        this.headParts.f_104203_ = f6 * (0.2617994f + f4) + f5 * 2.1816616f + (1.0f - Math.max(f6, f5)) * this.headParts.f_104203_;
        this.headParts.f_104204_ = f6 * f3 * ((float)Math.PI / 180) + (1.0f - Math.max(f6, f5)) * this.headParts.f_104204_;
        this.headParts.f_104201_ = f6 * -4.0f + f5 * 11.0f + (1.0f - Math.max(f6, f5)) * this.headParts.f_104201_;
        this.headParts.f_104202_ = f6 * -4.0f + f5 * -12.0f + (1.0f - Math.max(f6, f5)) * this.headParts.f_104202_;
        this.rightSaddleMouth.f_104201_ = 0.02f;
        this.leftSaddleMouth.f_104201_ = 0.02f;
        this.mouthSaddleWrap.f_104201_ = 0.02f;
        this.upperMouth.f_104201_ = 0.02f;
        this.lowerMouthSaddleWrap.f_104201_ = 0.0f;
        this.lowerMouth.f_104201_ = 0.0f;
        this.leftSaddleMouth.f_104202_ = this.rightSaddleMouth.f_104202_ = 0.02f - f8;
        this.mouthSaddleWrap.f_104202_ = this.rightSaddleMouth.f_104202_;
        this.upperMouth.f_104202_ = this.rightSaddleMouth.f_104202_;
        this.lowerMouth.f_104202_ = this.lowerMouthSaddleWrap.f_104202_ = f8;
        this.leftSaddleMouth.f_104203_ = this.rightSaddleMouth.f_104203_ = -0.09424778f * f8;
        this.mouthSaddleWrap.f_104203_ = this.rightSaddleMouth.f_104203_;
        this.upperMouth.f_104203_ = this.rightSaddleMouth.f_104203_;
        this.lowerMouth.f_104203_ = this.lowerMouthSaddleWrap.f_104203_ = 0.15707964f * f8;
        this.rightSaddleMouth.f_104204_ = 0.0f;
        this.leftSaddleMouth.f_104204_ = 0.0f;
        this.mouthSaddleWrap.f_104204_ = 0.0f;
        this.upperMouth.f_104204_ = 0.0f;
        this.lowerMouthSaddleWrap.f_104204_ = 0.0f;
        this.lowerMouth.f_104204_ = 0.0f;
        float f14 = 0.2617994f * f6;
        float f15 = Mth.m_14089_((float)(f9 * 0.6f + (float)Math.PI));
        this.rightFrontLeg.f_104201_ = 2.0f * f6 + 14.0f * f7;
        this.rightFrontLeg.f_104202_ = -6.0f * f6 - 10.0f * f7;
        this.leftFrontLeg.f_104201_ = this.rightFrontLeg.f_104201_;
        this.leftFrontLeg.f_104202_ = this.rightFrontLeg.f_104202_;
        this.rightHindShin.f_104201_ = this.rightHindLeg.f_104201_ + Mth.m_14031_((float)(1.5707964f + f14 + f7 * -f12)) * 3.0f;
        this.rightHindShin.f_104202_ = this.rightHindLeg.f_104202_ + Mth.m_14089_((float)(-1.5707964f + f14 + f7 * -f12)) * 3.0f;
        this.leftHindShin.f_104201_ = this.leftHindLeg.f_104201_ + Mth.m_14031_((float)(1.5707964f + f14 + f7 * f12)) * 3.0f;
        this.leftHindShin.f_104202_ = this.leftHindLeg.f_104202_ + Mth.m_14089_((float)(-1.5707964f + f14 + f7 * f12)) * 3.0f;
        float f16 = (-1.0471976f + f15) * f6 + f12 * f7;
        float f17 = (-1.0471976f - f15) * f6 - f12 * f7;
        this.rightFrontShin.f_104201_ = this.rightFrontLeg.f_104201_ + Mth.m_14031_((float)(1.5707964f + f16)) * 3.0f;
        this.rightFrontShin.f_104202_ = this.rightFrontLeg.f_104202_ + Mth.m_14089_((float)(-1.5707964f + f16)) * 3.0f;
        this.leftFrontShin.f_104201_ = this.leftFrontLeg.f_104201_ + Mth.m_14031_((float)(1.5707964f + f17)) * 3.0f;
        this.leftFrontShin.f_104202_ = this.leftFrontLeg.f_104202_ + Mth.m_14089_((float)(-1.5707964f + f17)) * 3.0f;
        this.rightHindLeg.f_104203_ = f14 - f12 * f7;
        this.rightHindShin.f_104203_ = -0.08726646f * f6 + (-f13 - Math.max(0.0f, f13)) * f7;
        this.leftHindLeg.f_104203_ = f14 + f12 * f7;
        this.leftHindShin.f_104203_ = -0.08726646f * f6 + (f13 - Math.max(0.0f, -f13)) * f7;
        this.rightFrontLeg.f_104203_ = f16;
        this.rightFrontShin.f_104203_ = (this.rightFrontLeg.f_104203_ + (float)Math.PI * Math.max(0.0f, 0.2f + f15 * 0.2f)) * f6 + (f13 + Math.max(0.0f, f13)) * f7;
        this.leftFrontLeg.f_104203_ = f17;
        this.leftFrontShin.f_104203_ = (this.leftFrontLeg.f_104203_ + (float)Math.PI * Math.max(0.0f, 0.2f - f15 * 0.2f)) * f6 + (-f13 + Math.max(0.0f, -f13)) * f7;
        this.copyBabyModelAngles();
        this.setBabyModelVisibility();
    }

    private void copyBabyModelAngles() {
        this.rightHindBabyLeg.f_104201_ = this.rightHindLeg.f_104201_;
        this.rightHindBabyLeg.f_104202_ = this.rightHindLeg.f_104202_;
        this.rightHindBabyLeg.f_104203_ = this.rightHindLeg.f_104203_;
        this.leftHindBabyLeg.f_104201_ = this.leftHindLeg.f_104201_;
        this.leftHindBabyLeg.f_104202_ = this.leftHindLeg.f_104202_;
        this.leftHindBabyLeg.f_104203_ = this.leftHindLeg.f_104203_;
        this.rightFrontBabyLeg.f_104201_ = this.rightFrontLeg.f_104201_;
        this.rightFrontBabyLeg.f_104202_ = this.rightFrontLeg.f_104202_;
        this.rightFrontBabyLeg.f_104203_ = this.rightFrontLeg.f_104203_;
        this.leftFrontBabyLeg.f_104201_ = this.leftFrontLeg.f_104201_;
        this.leftFrontBabyLeg.f_104202_ = this.leftFrontLeg.f_104202_;
        this.leftFrontBabyLeg.f_104203_ = this.leftFrontLeg.f_104203_;
        this.rightHindBabyShin.f_104201_ = this.rightHindShin.f_104201_;
        this.rightHindBabyShin.f_104202_ = this.rightHindShin.f_104202_;
        this.rightHindBabyShin.f_104203_ = this.rightHindShin.f_104203_;
        this.leftHindBabyShin.f_104201_ = this.leftHindShin.f_104201_;
        this.leftHindBabyShin.f_104202_ = this.leftHindShin.f_104202_;
        this.leftHindBabyShin.f_104203_ = this.leftHindShin.f_104203_;
        this.rightFrontBabyShin.f_104201_ = this.rightFrontShin.f_104201_;
        this.rightFrontBabyShin.f_104202_ = this.rightFrontShin.f_104202_;
        this.rightFrontBabyShin.f_104203_ = this.rightFrontShin.f_104203_;
        this.leftFrontBabyShin.f_104201_ = this.leftFrontShin.f_104201_;
        this.leftFrontBabyShin.f_104202_ = this.leftFrontShin.f_104202_;
        this.leftFrontBabyShin.f_104203_ = this.leftFrontShin.f_104203_;
    }

    private void setBabyModelVisibility() {
        this.rightHindLeg.f_104207_ = !this.f_102610_;
        this.leftHindLeg.f_104207_ = !this.f_102610_;
        this.rightFrontLeg.f_104207_ = !this.f_102610_;
        this.leftFrontLeg.f_104207_ = !this.f_102610_;
        this.rightHindShin.f_104207_ = !this.f_102610_;
        this.leftHindShin.f_104207_ = !this.f_102610_;
        this.rightFrontShin.f_104207_ = !this.f_102610_;
        this.leftFrontShin.f_104207_ = !this.f_102610_;
        this.rightHindBabyLeg.f_104207_ = this.f_102610_;
        this.leftHindBabyLeg.f_104207_ = this.f_102610_;
        this.rightFrontBabyLeg.f_104207_ = this.f_102610_;
        this.leftFrontBabyLeg.f_104207_ = this.f_102610_;
        this.rightHindBabyShin.f_104207_ = this.f_102610_;
        this.leftHindBabyShin.f_104207_ = this.f_102610_;
        this.rightFrontBabyShin.f_104207_ = this.f_102610_;
        this.leftFrontBabyShin.f_104207_ = this.f_102610_;
    }
}

