/*
 * Decompiled with CFR 0.152.
 */
package fuzs.betteranimationscollection.client.model;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import fuzs.betteranimationscollection.client.element.WobblyCreeperElement;
import fuzs.betteranimationscollection.mixin.client.accessor.LayerDefinitionAccessor;
import net.minecraft.client.model.CreeperModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class WobblyCreeperModel<T extends Entity>
extends CreeperModel<T> {
    private final ModelPart body;
    private final ModelPart[] bodyParts;
    private final ModelPart head;
    private final ModelPart rightHindLeg;
    private final ModelPart leftHindLeg;
    private final ModelPart rightFrontLeg;
    private final ModelPart leftFrontLeg;
    private final boolean chargedModel;

    public WobblyCreeperModel(ModelPart modelPart, boolean chargedModel) {
        super(modelPart);
        this.body = modelPart.m_171324_("body");
        this.bodyParts = new ModelPart[chargedModel ? 4 : 11];
        for (int i = 0; i < this.bodyParts.length; ++i) {
            this.bodyParts[i] = i == 0 ? this.body.m_171324_("body" + i) : this.bodyParts[i - 1].m_171324_("body" + i);
        }
        this.head = this.bodyParts[this.bodyParts.length - 1].m_171324_("head");
        this.leftHindLeg = modelPart.m_171324_("right_hind_leg");
        this.rightHindLeg = modelPart.m_171324_("left_hind_leg");
        this.leftFrontLeg = modelPart.m_171324_("right_front_leg");
        this.rightFrontLeg = modelPart.m_171324_("left_front_leg");
        this.chargedModel = chargedModel;
    }

    public static LayerDefinition createAnimatedBodyLayer(CubeDeformation cubeDeformation, boolean chargedModel) {
        int partHeight = chargedModel ? 3 : 1;
        LayerDefinition layerDefinition = CreeperModel.m_170525_((CubeDeformation)cubeDeformation);
        MeshDefinition meshDefinition = ((LayerDefinitionAccessor)layerDefinition).getMesh();
        PartDefinition partDefinition = meshDefinition.m_171576_();
        PartDefinition lastBodyPart = partDefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(16, 27).m_171488_(-4.0f, 12.0f - (float)partHeight, -2.0f, 8.0f, (float)partHeight, 4.0f, cubeDeformation), PartPose.m_171419_((float)0.0f, (float)6.0f, (float)0.0f));
        for (int i = 0; i < (chargedModel ? 4 : 11); ++i) {
            lastBodyPart = lastBodyPart.m_171599_("body" + i, CubeListBuilder.m_171558_().m_171514_(16, 27 - partHeight - i * partHeight).m_171488_(-4.0f, (float)partHeight, -2.0f, 8.0f, (float)partHeight, 4.0f, cubeDeformation), PartPose.m_171419_((float)0.0f, (float)(i == 0 ? 9.0f : (float)(-partHeight)), (float)0.0f));
        }
        lastBodyPart.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, cubeDeformation), PartPose.m_171419_((float)0.0f, (float)1.0f, (float)0.0f));
        partDefinition.m_171599_("right_hind_leg", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-2.0f, 0.0f, 0.0f, 4.0f, 6.0f, 4.0f, cubeDeformation), PartPose.m_171419_((float)-2.0f, (float)18.0f, (float)2.0f));
        partDefinition.m_171599_("left_hind_leg", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-2.0f, 0.0f, 0.0f, 4.0f, 6.0f, 4.0f, cubeDeformation), PartPose.m_171419_((float)2.0f, (float)18.0f, (float)2.0f));
        partDefinition.m_171599_("right_front_leg", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-2.0f, 0.0f, -4.0f, 4.0f, 6.0f, 4.0f, cubeDeformation), PartPose.m_171419_((float)-2.0f, (float)18.0f, (float)-2.0f));
        partDefinition.m_171599_("left_front_leg", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-2.0f, 0.0f, -4.0f, 4.0f, 6.0f, 4.0f, cubeDeformation), PartPose.m_171419_((float)2.0f, (float)18.0f, (float)-2.0f));
        return layerDefinition;
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int i, int j, float f, float g, float h, float k) {
        ImmutableList.of((Object)this.body, (Object)this.rightHindLeg, (Object)this.leftHindLeg, (Object)this.rightFrontLeg, (Object)this.leftFrontLeg).forEach(modelPart -> modelPart.m_104306_(poseStack, vertexConsumer, i, j, f, g, h, k));
    }

    public void m_6973_(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.head.f_104203_ = headPitch * ((float)Math.PI / 180);
        this.rightHindLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.leftHindLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.rightFrontLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.leftFrontLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        WobblyCreeperElement.WobbleDirection wobbleDirection = WobblyCreeperElement.wobbleDirection;
        if (wobbleDirection == WobblyCreeperElement.WobbleDirection.RANDOM) {
            wobbleDirection = WobblyCreeperElement.WobbleDirection.values()[(int)Math.abs(entityIn.m_20148_().getLeastSignificantBits() % (long)(WobblyCreeperElement.WobbleDirection.values().length - 1))];
        }
        float magnitude = this.resolveMagnitude(limbSwingAmount * 3.5f);
        float cosSwing = magnitude * Mth.m_14089_((float)(limbSwing * 0.6662f)) * (float)(this.chargedModel ? 3 : 1);
        float sinSwing = magnitude * Mth.m_14031_((float)(limbSwing * 0.6662f)) * (float)(this.chargedModel ? 3 : 1);
        block5: for (ModelPart bodyPart : this.bodyParts) {
            switch (wobbleDirection) {
                case SIDE: {
                    bodyPart.f_104203_ = 0.0f;
                    bodyPart.f_104205_ = cosSwing;
                    continue block5;
                }
                case FRONT: {
                    bodyPart.f_104203_ = cosSwing;
                    bodyPart.f_104205_ = 0.0f;
                    continue block5;
                }
                case CIRCLE: {
                    bodyPart.f_104203_ = sinSwing;
                    bodyPart.f_104205_ = cosSwing;
                }
            }
        }
    }

    private float resolveMagnitude(float limbSwingAmount) {
        if (limbSwingAmount < 0.0f) {
            return 0.0f;
        }
        if (limbSwingAmount < 0.6f) {
            return 0.125f * limbSwingAmount;
        }
        return 0.075f;
    }
}

