/*
 * Decompiled with CFR 0.152.
 */
package fuzs.betteranimationscollection.config;

import fuzs.betteranimationscollection.client.element.ModelElement;
import fuzs.betteranimationscollection.client.element.ModelElements;
import fuzs.puzzleslib.api.config.v3.Config;
import fuzs.puzzleslib.api.config.v3.ConfigCore;
import fuzs.puzzleslib.api.config.v3.ValueCallback;
import fuzs.puzzleslib.api.config.v3.serialization.ConfigDataSet;
import java.util.List;
import java.util.Map;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.common.ForgeConfigSpec;

public class ClientConfig
implements ConfigCore {
    @Config(category={"general"}, name="mob_blacklist", description={"Mob variants that shouldn't have any model changes applied to them.", "Format for every entry is \"<namespace>:<path>\". Tags are supported, must be in the format of \"#<namespace>:<path>\". Namespace may be omitted to use \"minecraft\" by default. May use asterisk as wildcard parameter via pattern matching, e.g. \"minecraft:*_shulker_box\" to match all shulker boxes no matter of color."})
    List<String> mobBlacklistRaw = ConfigDataSet.toString((ResourceKey)Registries.f_256939_, (Object[])new EntityType[0]);
    @Config(category={"general"}, description={"Block range for sound detection system to look for a mob that made a certain sound on the server, so the client may play an animation.", "The client is not sent an exact position, so the mob's location must be estimated."})
    @Config.DoubleRange(min=0.5, max=8.0)
    public double soundDetectionRange = 1.5;
    public ConfigDataSet<EntityType<?>> mobBlacklist;

    public void addToBuilder(ForgeConfigSpec.Builder builder, ValueCallback callback) {
        builder.push("models");
        for (Map.Entry<ResourceLocation, ModelElement> entry : ModelElements.MODEL_ELEMENTS.entrySet()) {
            callback.accept((ForgeConfigSpec.ConfigValue)builder.comment(entry.getValue().modelDescription()).define(entry.getKey().m_135815_(), true), entry.getValue()::setEnabled);
        }
        builder.pop();
        for (Map.Entry<ResourceLocation, ModelElement> entry : ModelElements.MODEL_ELEMENTS.entrySet()) {
            builder.push(entry.getKey().m_135815_());
            entry.getValue().setupModelConfig(builder, callback);
            builder.pop();
        }
    }

    public void afterConfigReload() {
        ConfigDataSet mobBlacklist = ConfigDataSet.from((ResourceKey)Registries.f_256939_, this.mobBlacklistRaw, (Class[])new Class[0]);
        if (!mobBlacklist.equals(this.mobBlacklist)) {
            boolean initialReload = this.mobBlacklist == null;
            this.mobBlacklist = mobBlacklist;
            if (!initialReload) {
                ModelElements.buildAnimatedModels(false, true);
            }
        }
    }
}

