/*
 * Decompiled with CFR 0.152.
 */
package dev.norbiros.emojitype.mixin;

import com.google.common.base.Strings;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.norbiros.emojitype.EmojiType;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.gui.components.CommandSuggestions;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.commands.SharedSuggestionProvider;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={CommandSuggestions.class})
public abstract class ChatInputSuggestorMixin {
    private static final Pattern COLON_PATTERN = Pattern.compile("(:)");
    private static final Pattern WHITESPACE_PATTERN = Pattern.compile("(\\s+)");
    @Shadow
    @Final
    EditBox f_93853_;
    @Shadow
    @Nullable
    private CompletableFuture<Suggestions> f_93865_;
    @Shadow
    @Final
    private boolean f_93855_;

    @Shadow
    public abstract void m_93930_(boolean var1);

    @Inject(method={"refresh"}, at={@At(value="TAIL")}, cancellable=true)
    private void inject(CallbackInfo ci) {
        boolean hasSlash;
        String text = this.f_93853_.m_94155_();
        StringReader stringReader = new StringReader(text);
        boolean bl = hasSlash = stringReader.canRead() && stringReader.peek() == '/';
        if (hasSlash) {
            stringReader.skip();
        }
        boolean isCommand = this.f_93855_ || hasSlash;
        int cursor = this.f_93853_.m_94207_();
        if (!isCommand) {
            String textUptoCursor = text.substring(0, cursor);
            int start = Math.max(this.getLastPattern(textUptoCursor, COLON_PATTERN) - 1, 0);
            int whitespace = this.getLastPattern(textUptoCursor, WHITESPACE_PATTERN);
            if (start < textUptoCursor.length() && start >= whitespace && textUptoCursor.charAt(start) == ':') {
                this.f_93865_ = SharedSuggestionProvider.m_82970_(EmojiType.emojiCodesCombined, (SuggestionsBuilder)new SuggestionsBuilder(textUptoCursor, start));
                this.f_93865_.thenRun(() -> {
                    if (!this.f_93865_.isDone()) {
                        return;
                    }
                    this.m_93930_(false);
                });
                ci.cancel();
            }
        }
    }

    private int getLastPattern(String input, Pattern pattern) {
        if (Strings.isNullOrEmpty((String)input)) {
            return 0;
        }
        int i = 0;
        Matcher matcher = pattern.matcher(input);
        while (matcher.find()) {
            i = matcher.end();
        }
        return i;
    }
}

