/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.client.model;

import com.github.alexthe666.citadel.client.model.AdvancedEntityModel;
import com.github.alexthe666.citadel.client.model.AdvancedModelBox;
import com.github.alexthe666.citadel.client.model.basic.BasicModelPart;
import com.google.common.collect.ImmutableList;
import net.minecraft.world.entity.Entity;

public class TeslaBulbModel
extends AdvancedEntityModel<Entity> {
    private final AdvancedModelBox bulb;
    private final AdvancedModelBox baseRing;
    private final AdvancedModelBox midRing;
    private final AdvancedModelBox topRing;
    private final AdvancedModelBox outer;
    private final AdvancedModelBox center;

    public TeslaBulbModel() {
        this.texWidth = 128;
        this.texHeight = 128;
        this.bulb = new AdvancedModelBox((AdvancedEntityModel)this);
        this.bulb.setRotationPoint(0.0f, 20.0f, 0.0f);
        this.baseRing = new AdvancedModelBox((AdvancedEntityModel)this);
        this.baseRing.setRotationPoint(0.0f, 4.0f, 0.0f);
        this.bulb.addChild((BasicModelPart)this.baseRing);
        this.baseRing.setTextureOffset(0, 32).addBox(-8.0f, 0.0f, -8.0f, 16.0f, 0.0f, 16.0f, 0.0f, false);
        this.midRing = new AdvancedModelBox((AdvancedEntityModel)this);
        this.midRing.setRotationPoint(0.0f, -2.0f, 0.0f);
        this.baseRing.addChild((BasicModelPart)this.midRing);
        this.midRing.setTextureOffset(0, 0).addBox(-8.0f, 0.0f, -8.0f, 16.0f, 0.0f, 16.0f, 0.0f, false);
        this.topRing = new AdvancedModelBox((AdvancedEntityModel)this);
        this.topRing.setRotationPoint(0.0f, -2.0f, 0.0f);
        this.midRing.addChild((BasicModelPart)this.topRing);
        this.topRing.setTextureOffset(0, 16).addBox(-8.0f, 0.0f, -8.0f, 16.0f, 0.0f, 16.0f, 0.0f, false);
        this.outer = new AdvancedModelBox((AdvancedEntityModel)this);
        this.outer.setRotationPoint(0.0f, -8.0f, 0.0f);
        this.topRing.addChild((BasicModelPart)this.outer);
        this.outer.setTextureOffset(40, 40).addBox(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f, 0.0f, false);
        this.center = new AdvancedModelBox((AdvancedEntityModel)this);
        this.center.setRotationPoint(0.0f, 0.0f, 0.0f);
        this.outer.addChild((BasicModelPart)this.center);
        this.center.setTextureOffset(0, 0).addBox(-1.0f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f, 0.0f, false);
        this.updateDefaultPose();
    }

    public Iterable<BasicModelPart> parts() {
        return ImmutableList.of((Object)this.bulb);
    }

    public Iterable<AdvancedModelBox> getAllParts() {
        return ImmutableList.of((Object)this.bulb, (Object)this.baseRing, (Object)this.center, (Object)this.outer, (Object)this.midRing, (Object)this.topRing);
    }

    public void m_6973_(Entity entity, float limbSwing, float explode, float ageInTicks, float netHeadYaw, float headPitch) {
        this.resetToDefaultPose();
        float intensity = 1.0f + explode;
        float zoom = (float)((Math.sin(ageInTicks * 0.5f * intensity) + 1.0) * 0.5) * 0.1f + (float)Math.sin((double)explode * Math.PI);
        this.outer.setScale(1.0f + zoom, 1.0f + zoom, 1.0f + zoom);
        this.bulb.rotationPointY = (float)((double)this.bulb.rotationPointY + (-1.0 + Math.sin(ageInTicks * 0.045f * intensity) * 1.0));
        this.baseRing.rotationPointY = (float)((double)this.baseRing.rotationPointY - (-1.0 + Math.sin(ageInTicks * 0.045f * intensity) * 1.0));
        this.baseRing.rotationPointY = (float)((double)this.baseRing.rotationPointY + (-2.5 + Math.sin(ageInTicks * 0.045f * intensity + 1.0f) * 0.5));
        this.midRing.rotationPointY = (float)((double)this.midRing.rotationPointY + Math.sin(ageInTicks * 0.045f * intensity + 2.0f) * 0.25);
        this.topRing.rotationPointY = (float)((double)this.topRing.rotationPointY - Math.sin(ageInTicks * 0.045f * intensity + 3.0f) * (double)0.15f);
        this.bulb.rotationPointY = (float)((double)this.bulb.rotationPointY + Math.sin(ageInTicks * 0.045f) * 1.0);
        this.bulb.rotationPointY = (float)((double)this.bulb.rotationPointY + Math.sin(ageInTicks * 0.045f) * 1.0);
        this.center.rotateAngleX += ageInTicks * 0.1f * intensity;
        this.center.rotateAngleY += ageInTicks * 0.2f * intensity;
        this.outer.rotateAngleZ += ageInTicks * 0.05f * intensity;
        this.outer.rotateAngleX -= ageInTicks * 0.1f * intensity;
        this.outer.rotateAngleY -= ageInTicks * 0.2f * intensity;
        this.outer.rotateAngleZ -= ageInTicks * 0.05f * intensity;
        this.baseRing.rotateAngleY += ageInTicks * 0.1f * intensity;
        this.midRing.rotateAngleY += ageInTicks * 0.1f * intensity;
        this.topRing.rotateAngleY += ageInTicks * 0.1f * intensity;
    }
}

