/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.client.render.entity;

import com.github.alexmodguy.alexscaves.client.model.CorrodentModel;
import com.github.alexmodguy.alexscaves.server.entity.living.CorrodentEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.SheetedDecalTextureGenerator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.model.data.ModelData;

public class CorrodentRenderer
extends MobRenderer<CorrodentEntity, CorrodentModel> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("alexscaves:textures/entity/corrodent.png");
    private static final ResourceLocation TEXTURE_EYES = new ResourceLocation("alexscaves:textures/entity/corrodent_eyes.png");
    private static final Map<BlockPos, Integer> allDugBlocksOnScreen = new HashMap<BlockPos, Integer>();

    public CorrodentRenderer(EntityRendererProvider.Context renderManagerIn) {
        super(renderManagerIn, (EntityModel)new CorrodentModel(), 0.5f);
        this.m_115326_(new LayerGlow());
    }

    public ResourceLocation getTextureLocation(CorrodentEntity entity) {
        return TEXTURE;
    }

    public void render(CorrodentEntity entityIn, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int packedLightIn) {
        super.m_7392_((Mob)entityIn, entityYaw, partialTicks, poseStack, bufferIn, packedLightIn);
        double x = Mth.m_14139_((double)partialTicks, (double)entityIn.f_19790_, (double)entityIn.m_20185_());
        double y = Mth.m_14139_((double)partialTicks, (double)entityIn.f_19791_, (double)entityIn.m_20186_());
        double z = Mth.m_14139_((double)partialTicks, (double)entityIn.f_19792_, (double)entityIn.m_20189_());
        float digAmount = entityIn.getDigAmount(partialTicks);
        if (digAmount > 0.0f) {
            double digEffectDistance = 3.0;
            for (BlockPos mutableBlockPos : BlockPos.m_121976_((int)((int)Math.floor(x - digEffectDistance)), (int)((int)Math.floor(y - digEffectDistance)), (int)((int)Math.floor(z - digEffectDistance)), (int)((int)Math.floor(x + digEffectDistance)), (int)((int)Math.floor(y + digEffectDistance)), (int)((int)Math.floor(z + digEffectDistance)))) {
                int amount = (int)((float)entityIn.getCorrosionAmount(mutableBlockPos) * digAmount);
                if (amount < 0) continue;
                allDugBlocksOnScreen.put(mutableBlockPos.m_7949_(), Math.max(allDugBlocksOnScreen.getOrDefault(mutableBlockPos, -1), amount));
            }
        }
    }

    public static void renderEntireBatch(LevelRenderer levelRenderer, PoseStack poseStack, int renderTick, Camera camera, float partialTick) {
        if (!allDugBlocksOnScreen.isEmpty()) {
            poseStack.m_85836_();
            Vec3 cameraPos = camera.m_90583_();
            poseStack.m_85837_(-cameraPos.f_82479_, -cameraPos.f_82480_, -cameraPos.f_82481_);
            MultiBufferSource.BufferSource multibuffersource$buffersource = Minecraft.m_91087_().m_91269_().m_110108_();
            for (Map.Entry<BlockPos, Integer> posAndInt : allDugBlocksOnScreen.entrySet()) {
                int progress = posAndInt.getValue() - 1;
                if (progress < 0 || progress >= 10) continue;
                poseStack.m_85836_();
                BlockPos pos = posAndInt.getKey();
                poseStack.m_85837_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
                PoseStack.Pose posestack$pose1 = poseStack.m_85850_();
                SheetedDecalTextureGenerator vertexconsumer1 = new SheetedDecalTextureGenerator(multibuffersource$buffersource.m_6299_((RenderType)ModelBakery.f_119229_.get(progress)), posestack$pose1.m_252922_(), posestack$pose1.m_252943_(), 1.0f);
                ModelData modelData = Minecraft.m_91087_().f_91073_.getModelDataManager().getAt(pos);
                Minecraft.m_91087_().m_91289_().renderBreakingTexture(Minecraft.m_91087_().f_91073_.m_8055_(pos), pos, (BlockAndTintGetter)Minecraft.m_91087_().f_91073_, poseStack, (VertexConsumer)vertexconsumer1, modelData == null ? ModelData.EMPTY : modelData);
                poseStack.m_85849_();
            }
            poseStack.m_85849_();
        }
        allDugBlocksOnScreen.clear();
    }

    class LayerGlow
    extends RenderLayer<CorrodentEntity, CorrodentModel> {
        public LayerGlow() {
            super((RenderLayerParent)CorrodentRenderer.this);
        }

        public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, CorrodentEntity entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            VertexConsumer ivertexbuilder = bufferIn.m_6299_(RenderType.m_110488_((ResourceLocation)TEXTURE_EYES));
            float alpha = 1.0f;
            ((CorrodentModel)this.m_117386_()).m_7695_(matrixStackIn, ivertexbuilder, packedLightIn, LivingEntityRenderer.m_115338_((LivingEntity)entitylivingbaseIn, (float)0.0f), 1.0f, 1.0f, 1.0f, alpha);
        }
    }
}

