/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.client.render.entity;

import com.github.alexmodguy.alexscaves.client.model.BoundroidModel;
import com.github.alexmodguy.alexscaves.client.model.QuarrySmasherModel;
import com.github.alexmodguy.alexscaves.client.render.ACRenderTypes;
import com.github.alexmodguy.alexscaves.client.render.entity.BoundroidWinchRenderer;
import com.github.alexmodguy.alexscaves.server.entity.item.QuarrySmasherEntity;
import com.github.alexthe666.citadel.client.render.LightningBoltData;
import com.github.alexthe666.citadel.client.render.LightningRender;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.PartEntity;
import org.joml.Vector4f;

public class QuarrySmasherRenderer
extends EntityRenderer<QuarrySmasherEntity> {
    private static final QuarrySmasherModel QUARRY_SMASHER_MODEL = new QuarrySmasherModel();
    private static final BoundroidModel BOUNDROID_MODEL = new BoundroidModel();
    private static final ResourceLocation TEXTURE = new ResourceLocation("alexscaves", "textures/entity/quarry_smasher.png");
    private static final ResourceLocation TEXTURE_GLOW = new ResourceLocation("alexscaves", "textures/entity/quarry_smasher_glow.png");
    private static final ResourceLocation TEXTURE_BOUNDROID = new ResourceLocation("alexscaves", "textures/entity/boundroid_quarry.png");
    private static final ResourceLocation TEXTURE_CHAIN = new ResourceLocation("minecraft:textures/block/chain.png");
    private static final Map<UUID, LightningRender> lightningRenderMap = new HashMap<UUID, LightningRender>();
    private static final LightningBoltData.BoltRenderInfo LIGHTNING_BOLT_INFO = new LightningBoltData.BoltRenderInfo(0.0f, 0.01f, 0.3f, 0.6f, new Vector4f(0.71f, 0.76f, 0.95f, 0.3f), 0.0f);

    public QuarrySmasherRenderer(EntityRendererProvider.Context renderManagerIn) {
        super(renderManagerIn);
    }

    public boolean shouldRender(QuarrySmasherEntity entity, Frustum camera, double x, double y, double z) {
        if (super.m_5523_((Entity)entity, camera, x, y, z)) {
            return true;
        }
        for (PartEntity<?> part : entity.getParts()) {
            if (!camera.m_113029_(part.m_6921_())) continue;
            return true;
        }
        return entity.lastMiningArea != null && camera.m_113029_(entity.lastMiningArea);
    }

    public void render(QuarrySmasherEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int packedLightIn) {
        float ageInTicks = (float)entity.f_19797_ + partialTicks;
        float inactive = entity.getInactiveProgress(partialTicks);
        float headStill = entity.getHeadGroundProgress(partialTicks);
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, 1.5, 0.0);
        poseStack.m_252781_(Axis.f_252529_.m_252977_(180.0f));
        QUARRY_SMASHER_MODEL.setupAnim(entity, 0.0f, 0.0f, ageInTicks, 0.0f, 0.0f);
        VertexConsumer textureVertexConsumer = bufferIn.m_6299_(RenderType.m_110458_((ResourceLocation)TEXTURE));
        QUARRY_SMASHER_MODEL.m_7695_(poseStack, textureVertexConsumer, packedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        VertexConsumer activeVertexConsumer = bufferIn.m_6299_(ACRenderTypes.getEyesAlphaEnabled(TEXTURE_GLOW));
        QUARRY_SMASHER_MODEL.m_7695_(poseStack, activeVertexConsumer, 240, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f - inactive);
        poseStack.m_85849_();
        if (!entity.isInactive() && entity.lastMiningArea != null) {
            LightningRender lightningRender = this.getLightingRender(entity.m_20148_());
            Vec3 position = entity.m_20318_(partialTicks);
            poseStack.m_85836_();
            poseStack.m_85837_(-position.f_82479_, -position.f_82480_, -position.f_82481_);
            lightningRender.render(partialTicks, poseStack, bufferIn);
            poseStack.m_85849_();
            float armStickyOuty = 0.8f;
            Vec3 corner1 = new Vec3(entity.lastMiningArea.f_82288_ + 0.5, entity.lastMiningArea.f_82289_ + 0.5, entity.lastMiningArea.f_82290_ + 0.5);
            Vec3 corner2 = new Vec3(entity.lastMiningArea.f_82291_ + 0.5, entity.lastMiningArea.f_82289_ + 0.5, entity.lastMiningArea.f_82290_ + 0.5);
            Vec3 corner3 = new Vec3(entity.lastMiningArea.f_82288_ + 0.5, entity.lastMiningArea.f_82289_ + 0.5, entity.lastMiningArea.f_82293_ + 0.5);
            Vec3 corner4 = new Vec3(entity.lastMiningArea.f_82291_ + 0.5, entity.lastMiningArea.f_82289_ + 0.5, entity.lastMiningArea.f_82293_ + 0.5);
            int segCount = Mth.m_14045_((int)((int)Math.ceil((double)0.3f * corner1.m_165924_())), (int)3, (int)30);
            LightningBoltData bolt1 = new LightningBoltData(LIGHTNING_BOLT_INFO, corner1, position.m_82520_((double)-0.7f, (double)armStickyOuty, (double)-0.7f), segCount).size(0.3f).lifespan(1).spawn(LightningBoltData.SpawnFunction.CONSECUTIVE).fade(LightningBoltData.FadeFunction.NONE);
            LightningBoltData bolt2 = new LightningBoltData(LIGHTNING_BOLT_INFO, corner2, position.m_82520_((double)0.7f, (double)armStickyOuty, (double)-0.7f), segCount).size(0.3f).lifespan(1).spawn(LightningBoltData.SpawnFunction.CONSECUTIVE).fade(LightningBoltData.FadeFunction.NONE);
            LightningBoltData bolt3 = new LightningBoltData(LIGHTNING_BOLT_INFO, corner3, position.m_82520_((double)-0.7f, (double)armStickyOuty, (double)0.7f), segCount).size(0.3f).lifespan(1).spawn(LightningBoltData.SpawnFunction.CONSECUTIVE).fade(LightningBoltData.FadeFunction.NONE);
            LightningBoltData bolt4 = new LightningBoltData(LIGHTNING_BOLT_INFO, corner4, position.m_82520_((double)0.7f, (double)armStickyOuty, (double)0.7f), segCount).size(0.3f).lifespan(1).spawn(LightningBoltData.SpawnFunction.CONSECUTIVE).fade(LightningBoltData.FadeFunction.NONE);
            if (!Minecraft.m_91087_().m_91104_()) {
                lightningRender.update((Object)1, bolt1, partialTicks);
                lightningRender.update((Object)2, bolt2, partialTicks);
                lightningRender.update((Object)3, bolt3, partialTicks);
                lightningRender.update((Object)4, bolt4, partialTicks);
            }
        }
        if (entity.headPart != null && entity.f_19797_ > 0) {
            Vec3 boundroidTop = entity.headPart.m_20318_(partialTicks).m_82546_(entity.m_20318_(partialTicks));
            poseStack.m_85836_();
            poseStack.m_85837_(boundroidTop.f_82479_, boundroidTop.f_82480_, boundroidTop.f_82481_);
            poseStack.m_85837_(0.0, 1.5, 0.0);
            poseStack.m_252781_(Axis.f_252529_.m_252977_(180.0f));
            BOUNDROID_MODEL.animateForQuarry(ageInTicks, Math.max(headStill, inactive));
            VertexConsumer boundroidVertexConsumer = bufferIn.m_6299_(RenderType.m_110458_((ResourceLocation)TEXTURE_BOUNDROID));
            BOUNDROID_MODEL.m_7695_(poseStack, boundroidVertexConsumer, packedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            poseStack.m_85849_();
            Vec3 chainOffset = new Vec3(0.0, -0.75, 0.0);
            Vec3 chainTo = entity.m_20318_(partialTicks).m_82549_(chainOffset).m_82546_(entity.headPart.m_20318_(partialTicks).m_82520_(0.0, -0.25, 0.0));
            VertexConsumer chainBuffer = bufferIn.m_6299_(RenderType.m_110458_((ResourceLocation)TEXTURE_CHAIN));
            poseStack.m_85836_();
            poseStack.m_85837_(boundroidTop.f_82479_ - chainOffset.f_82479_, boundroidTop.f_82480_ - chainOffset.f_82480_, boundroidTop.f_82481_ - chainOffset.f_82481_);
            BoundroidWinchRenderer.renderChain(chainTo, poseStack, chainBuffer, packedLightIn, OverlayTexture.f_118083_);
            poseStack.m_85849_();
        }
        if (entity.m_213877_() && lightningRenderMap.containsKey(entity.m_20148_())) {
            lightningRenderMap.remove(entity.m_20148_());
        }
        super.m_7392_((Entity)entity, entityYaw, partialTicks, poseStack, bufferIn, packedLightIn);
    }

    private LightningRender getLightingRender(UUID uuid) {
        if (lightningRenderMap.get(uuid) == null) {
            lightningRenderMap.put(uuid, new LightningRender());
        }
        return lightningRenderMap.get(uuid);
    }

    public ResourceLocation getTextureLocation(QuarrySmasherEntity entity) {
        return TEXTURE;
    }
}

