/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.block.blockentity;

import com.github.alexmodguy.alexscaves.server.block.CopperValveBlock;
import com.github.alexmodguy.alexscaves.server.block.blockentity.ACBlockEntityRegistry;
import com.github.alexmodguy.alexscaves.server.misc.ACSoundRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class CopperValveBlockEntity
extends BlockEntity {
    private boolean movingDown;
    private float downProgress;
    private float prevDownProgress;

    public CopperValveBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ACBlockEntityRegistry.COPPER_VALVE.get(), pos, state);
        if (((Boolean)state.m_61143_((Property)CopperValveBlock.TURNED)).booleanValue()) {
            this.movingDown = true;
            this.downProgress = 10.0f;
            this.prevDownProgress = 10.0f;
        }
    }

    public static void tick(Level level, BlockPos blockPos, BlockState state, CopperValveBlockEntity entity) {
        entity.prevDownProgress = entity.downProgress;
        if (entity.movingDown && entity.downProgress < 10.0f) {
            if (entity.downProgress == 0.0f) {
                level.m_7785_((double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 0.5, (double)blockPos.m_123343_() + 0.5, (SoundEvent)ACSoundRegistry.COPPER_VALVE_CREAK_ON.get(), SoundSource.BLOCKS, 1.0f, level.f_46441_.m_188501_() * 0.4f + 0.8f, false);
            }
            entity.downProgress += 0.5f;
        } else if (!entity.movingDown && entity.downProgress > 0.0f) {
            if (entity.downProgress == 10.0f) {
                level.m_7785_((double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 0.5, (double)blockPos.m_123343_() + 0.5, (SoundEvent)ACSoundRegistry.COPPER_VALVE_CREAK_OFF.get(), SoundSource.BLOCKS, 1.0f, level.f_46441_.m_188501_() * 0.4f + 0.8f, false);
            }
            entity.downProgress -= 0.5f;
        }
        if (entity.movingDown && entity.downProgress >= 10.0f && !((Boolean)state.m_61143_((Property)CopperValveBlock.TURNED)).booleanValue()) {
            level.m_46597_(blockPos, (BlockState)state.m_61124_((Property)CopperValveBlock.TURNED, (Comparable)Boolean.valueOf(true)));
            level.m_46672_(blockPos, state.m_60734_());
            level.m_46672_(blockPos.m_121945_(((Direction)state.m_61143_((Property)CopperValveBlock.FACING)).m_122424_()), state.m_60734_());
        }
        if ((!entity.movingDown || entity.downProgress < 10.0f) && ((Boolean)state.m_61143_((Property)CopperValveBlock.TURNED)).booleanValue()) {
            level.m_46597_(blockPos, (BlockState)state.m_61124_((Property)CopperValveBlock.TURNED, (Comparable)Boolean.valueOf(false)));
            level.m_46672_(blockPos, state.m_60734_());
            level.m_46672_(blockPos.m_121945_(((Direction)state.m_61143_((Property)CopperValveBlock.FACING)).m_122424_()), state.m_60734_());
        }
    }

    public void moveDown(boolean in) {
        this.movingDown = in;
    }

    public boolean isMovingDown() {
        return this.movingDown;
    }

    public float getDownAmount(float partialTicks) {
        return (this.prevDownProgress + (this.downProgress - this.prevDownProgress) * partialTicks) * 0.1f;
    }
}

