/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.entity.ai;

import com.github.alexmodguy.alexscaves.server.entity.living.DeepOneBaseEntity;
import com.github.alexmodguy.alexscaves.server.entity.living.DeepOneMageEntity;
import com.github.alexmodguy.alexscaves.server.entity.util.DeepOneReaction;
import com.github.alexmodguy.alexscaves.server.misc.ACAdvancementTriggerRegistry;
import com.github.alexmodguy.alexscaves.server.misc.ACTagRegistry;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class DeepOneReactToPlayerGoal
extends Goal {
    private DeepOneBaseEntity deepOne;
    private Player player;
    private DeepOneReaction prevReaction;
    private DeepOneReaction reaction;
    private boolean following = false;
    private int refreshReactionTime = 0;
    private boolean isBeingLookedAt = false;
    private int lookAtTime = 0;
    private int chaseTime = 0;
    private int friendlyLookAtTime = 0;
    private int executionTime = 0;
    private Vec3 moveTarget = null;

    public DeepOneReactToPlayerGoal(DeepOneBaseEntity deepOne) {
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        this.deepOne = deepOne;
    }

    public boolean m_8036_() {
        LivingEntity target = this.deepOne.m_5448_();
        long worldTime = this.deepOne.m_9236_().m_46467_() % 20L;
        if (worldTime != 0L && this.deepOne.m_217043_().m_188503_(15) != 0 || target != null && target.m_6084_() || this.deepOne.getCorneringPlayer() != null) {
            return false;
        }
        AABB aabb = this.deepOne.m_20191_().m_82400_(80.0);
        List list = this.deepOne.m_9236_().m_45976_(Player.class, aabb);
        if (!list.isEmpty()) {
            Player closest = null;
            int highestReputation = Integer.MIN_VALUE;
            for (Player scanningPlayer : list) {
                if (closest != null && !(scanningPlayer.m_20280_((Entity)this.deepOne) < closest.m_20280_((Entity)this.deepOne)) && this.deepOne.getReputationOf(scanningPlayer.m_20148_()) <= highestReputation || !this.deepOne.m_142582_((Entity)scanningPlayer)) continue;
                closest = scanningPlayer;
                highestReputation = this.deepOne.getReputationOf(scanningPlayer.m_20148_());
            }
            this.player = closest;
            DeepOneReaction reaction1 = DeepOneReaction.fromReputation(highestReputation);
            return this.player != null && (reaction1 != DeepOneReaction.AGGRESSIVE || this.deepOne.isSummoned() || !this.player.m_7500_()) && reaction1.validPlayer(this.deepOne, this.player);
        }
        return false;
    }

    public boolean m_8045_() {
        LivingEntity attackTarget = this.deepOne.m_5448_();
        return this.player != null && !this.player.m_5833_() && this.reaction != null && this.deepOne.getCorneringPlayer() == null && (double)this.deepOne.m_20270_((Entity)this.player) >= this.reaction.getMinDistance() && (double)this.deepOne.m_20270_((Entity)this.player) <= this.reaction.getMaxDistance() && (attackTarget == null || !attackTarget.m_6084_()) && (this.reaction != DeepOneReaction.AGGRESSIVE || !this.player.m_7500_() || this.deepOne.isSummoned()) && !this.deepOne.isTradingLocked() && this.reaction.validPlayer(this.deepOne, this.player);
    }

    public void m_8056_() {
        this.chaseTime = 0;
        this.executionTime = 0;
        this.refreshReaction();
    }

    public void m_8041_() {
        this.chaseTime = 0;
        this.executionTime = 0;
        this.following = false;
        this.isBeingLookedAt = false;
        this.moveTarget = null;
        this.deepOne.setSoundsAngry(false);
    }

    private void refreshReaction() {
        if (this.player != null) {
            this.prevReaction = this.reaction;
            this.reaction = this.deepOne.getReactionTo(this.player);
            if (this.prevReaction != this.reaction) {
                this.deepOne.m_21573_().m_26573_();
            }
            this.refreshReactionTime = 20 + this.deepOne.m_217043_().m_188503_(40);
        }
    }

    public void m_8037_() {
        ++this.executionTime;
        if (this.refreshReactionTime-- < 0) {
            this.refreshReaction();
        }
        switch (this.reaction) {
            case STALKING: {
                this.tickStalking();
                break;
            }
            case AGGRESSIVE: {
                if (this.player.m_7500_()) break;
                this.deepOne.m_6710_((LivingEntity)this.player);
                break;
            }
            case NEUTRAL: {
                this.tickFollow(0.1f);
                break;
            }
            case HELPFUL: {
                this.deepOne.copyTarget((LivingEntity)this.player);
                this.tickFollow(0.4f);
            }
        }
        this.deepOne.setSoundsAngry(this.reaction == DeepOneReaction.AGGRESSIVE);
        if (!this.deepOne.m_21573_().m_26571_() && (this.moveTarget == null || this.moveTarget.f_82480_ < this.deepOne.m_20186_() + 2.0)) {
            this.deepOne.setDeepOneSwimming(!this.deepOne.m_20096_() && this.deepOne.m_20072_());
        }
    }

    private void tickFollow(float propensity) {
        float f = 0.1f;
        if (this.player.m_21206_().m_204117_(ACTagRegistry.DEEP_ONE_BARTERS) || this.player.m_21205_().m_204117_(ACTagRegistry.DEEP_ONE_BARTERS)) {
            f = 0.2f;
        }
        if (this.deepOne.isSummoned()) {
            f = 1000.0f;
        }
        double distance = this.deepOne.m_20270_((Entity)this.player);
        if (this.deepOne.m_217043_().m_188501_() < propensity * f && this.friendlyLookAtTime <= 0) {
            this.friendlyLookAtTime = 10 + this.deepOne.m_217043_().m_188503_(20);
        }
        if (this.friendlyLookAtTime > 0) {
            this.deepOne.m_21563_().m_24950_(this.player.m_20185_(), this.player.m_20188_(), this.player.m_20189_(), 10.0f, (float)this.deepOne.m_8132_());
            --this.friendlyLookAtTime;
        }
        if (this.following) {
            if (distance < 4.0) {
                this.following = false;
                this.deepOne.m_21573_().m_26573_();
            } else {
                this.deepOne.m_21573_().m_5624_((Entity)this.player, 1.0);
            }
        } else if (distance > 10.0 && this.deepOne.m_217043_().m_188501_() < propensity * 0.2f) {
            this.following = true;
        }
    }

    private void tickStalking() {
        double distance = this.deepOne.m_20270_((Entity)this.player);
        double distanceXZ = Mth.m_14116_((float)((float)this.deepOne.m_20275_(this.player.m_20185_(), this.deepOne.m_20186_(), this.player.m_20189_())));
        if (distance <= 8.0 && this.isBeingLookedAt) {
            ++this.chaseTime;
        }
        if (distance > 40.0 && this.chaseTime > 0) {
            this.chaseTime = 0;
        }
        if (this.chaseTime >= (this.deepOne.m_21188_() == this.player ? 10 : 60)) {
            this.deepOne.setCorneredBy(this.player);
        } else {
            if (this.lookAtTime-- < 0) {
                boolean isLooking = this.isEntityLookingAt((LivingEntity)this.player, (LivingEntity)this.deepOne, 1.2f);
                if (isLooking != this.isBeingLookedAt) {
                    this.deepOne.m_21573_().m_26573_();
                    this.moveTarget = null;
                    if (this.executionTime > 20 && this.deepOne.m_20270_((Entity)this.player) < 20.0f) {
                        ACAdvancementTriggerRegistry.STALKED_BY_DEEP_ONE.triggerForEntity((Entity)this.player);
                    }
                }
                this.isBeingLookedAt = isLooking;
                this.lookAtTime = 5 + this.deepOne.m_217043_().m_188503_(5);
            }
            this.deepOne.m_6842_(false);
            if (this.isBeingLookedAt || this.deepOne.m_217043_().m_188503_(100) == 0) {
                for (j = 0; (this.moveTarget == null || this.moveTarget.m_82554_(this.deepOne.m_20182_()) < 3.0) && j < 10; ++j) {
                    this.moveTarget = DefaultRandomPos.m_148407_((PathfinderMob)this.deepOne, (int)40, (int)15, (Vec3)this.player.m_20182_());
                }
            } else {
                for (j = 0; (this.moveTarget == null || this.moveTarget.m_82554_(this.deepOne.m_20182_()) < 3.0) && j < 10; ++j) {
                    Vec3 vec3 = DefaultRandomPos.m_148412_((PathfinderMob)this.deepOne, (int)15, (int)15, (Vec3)this.player.m_20182_(), (double)1.5707963705062866);
                    if (vec3 == null) continue;
                    float mageUp = this.deepOne instanceof DeepOneMageEntity ? (float)(1 + this.deepOne.m_217043_().m_188503_(2)) : 0.0f;
                    this.moveTarget = new Vec3(vec3.f_82479_, distanceXZ < 20.0 ? this.player.m_20186_() + (double)mageUp : vec3.f_82480_, vec3.f_82481_);
                }
                this.deepOne.m_21563_().m_24950_(this.player.m_20185_(), this.player.m_20188_(), this.player.m_20189_(), 10.0f, (float)this.deepOne.m_8132_());
                if (distance < 12.0) {
                    this.deepOne.m_21573_().m_26573_();
                    if (this.deepOne.m_20096_()) {
                        this.deepOne.setDeepOneSwimming(false);
                    }
                }
            }
            if (this.moveTarget != null && this.moveTarget.m_82554_(this.deepOne.m_20182_()) > 3.0 && (this.isBeingLookedAt || distance >= 12.0)) {
                if (this.moveTarget.f_82480_ > this.deepOne.m_20186_() + 1.0) {
                    this.deepOne.setDeepOneSwimming(this.deepOne.m_20072_());
                }
                float mageUp = this.deepOne instanceof DeepOneMageEntity ? 2.0f : 0.0f;
                this.deepOne.m_21573_().m_26519_(this.moveTarget.f_82479_, this.moveTarget.f_82480_ + (double)mageUp, this.moveTarget.f_82481_, this.isBeingLookedAt ? 2.0 : 1.0);
            }
        }
    }

    private boolean isEntityLookingAt(LivingEntity looker, LivingEntity seen, double degree) {
        Vec3 vec3 = looker.m_20252_(1.0f).m_82541_();
        Vec3 vec31 = new Vec3(seen.m_20185_() - looker.m_20185_(), seen.m_20191_().f_82289_ + (double)seen.m_20192_() - (looker.m_20186_() + (double)looker.m_20192_()), seen.m_20189_() - looker.m_20189_());
        double d0 = vec31.m_82553_();
        double d1 = vec3.m_82526_(vec31 = vec31.m_82541_());
        return d1 > 1.0 - (degree *= 1.0 + (double)looker.m_20270_((Entity)seen) * 0.1) / d0 && looker.m_142582_((Entity)seen);
    }
}

