/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.entity.item;

import com.github.alexmodguy.alexscaves.server.entity.ACEntityRegistry;
import com.github.alexmodguy.alexscaves.server.entity.util.FrostmintExplosion;
import com.github.alexmodguy.alexscaves.server.entity.util.FrostmintFreezableAccessor;
import com.github.alexmodguy.alexscaves.server.item.ACItemRegistry;
import com.github.alexmodguy.alexscaves.server.misc.ACSoundRegistry;
import javax.annotation.Nullable;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;

public class FrostmintSpearEntity
extends AbstractArrow {
    private boolean dealtDamage;
    private boolean exploded;
    private static final EntityDataAccessor<Integer> OWNER_ID = SynchedEntityData.m_135353_(FrostmintSpearEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public FrostmintSpearEntity(EntityType entityType, Level level) {
        super(entityType, level);
    }

    public FrostmintSpearEntity(Level level, LivingEntity shooter, ItemStack itemStack) {
        super((EntityType)ACEntityRegistry.FROSTMINT_SPEAR.get(), shooter, level);
    }

    public FrostmintSpearEntity(Level level, double x, double y, double z) {
        super((EntityType)ACEntityRegistry.FROSTMINT_SPEAR.get(), x, y, z, level);
    }

    public FrostmintSpearEntity(PlayMessages.SpawnEntity spawnEntity, Level level) {
        this((EntityType)ACEntityRegistry.FROSTMINT_SPEAR.get(), level);
        this.m_20011_(this.m_142242_());
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected ItemStack m_7941_() {
        return new ItemStack((ItemLike)ACItemRegistry.FROSTMINT_SPEAR.get());
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(OWNER_ID, (Object)-1);
    }

    @Nullable
    protected EntityHitResult m_6351_(Vec3 vec3, Vec3 vec31) {
        return this.dealtDamage ? null : super.m_6351_(vec3, vec31);
    }

    public void m_8119_() {
        super.m_8119_();
        Entity owner = this.m_19749_();
        if (!this.m_9236_().f_46443_ && owner != null) {
            this.f_19804_.m_135381_(OWNER_ID, (Object)owner.m_19879_());
        }
    }

    @Nullable
    public Entity m_19749_() {
        if (this.m_9236_().f_46443_ && (Integer)this.f_19804_.m_135370_(OWNER_ID) != -1) {
            return this.m_9236_().m_6815_(((Integer)this.f_19804_.m_135370_(OWNER_ID)).intValue());
        }
        return super.m_19749_();
    }

    protected void m_5790_(EntityHitResult hitResult) {
        Entity entity = hitResult.m_82443_();
        float f = 6.0f;
        if (entity instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entity;
            f += EnchantmentHelper.m_44833_((ItemStack)this.m_7941_(), (MobType)livingentity.m_6336_());
        }
        Entity entity1 = this.m_19749_();
        DamageSource damagesource = this.m_269291_().m_269525_((Entity)this, (Entity)(entity1 == null ? this : entity1));
        this.dealtDamage = true;
        SoundEvent soundevent = (SoundEvent)ACSoundRegistry.FROSTMINT_SPEAR_HIT.get();
        if (entity.m_6469_(damagesource, f)) {
            if (entity.m_6095_() == EntityType.f_20566_) {
                return;
            }
            if (entity instanceof LivingEntity) {
                LivingEntity livingentity1 = (LivingEntity)entity;
                if (entity1 instanceof LivingEntity) {
                    EnchantmentHelper.m_44823_((LivingEntity)livingentity1, (Entity)entity1);
                    EnchantmentHelper.m_44896_((LivingEntity)((LivingEntity)entity1), (Entity)livingentity1);
                }
                this.m_7761_(livingentity1);
            }
        }
        this.m_20256_(this.m_20184_().m_82542_(-0.01, -0.1, -0.01));
        float f1 = 1.0f;
        this.m_5496_(soundevent, f1, 1.0f);
    }

    protected void m_6532_(HitResult hitResult) {
        if (!this.exploded && this.f_19797_ > 1) {
            this.exploded = true;
            this.explode();
        }
        super.m_6532_(hitResult);
    }

    private void explode() {
        FrostmintExplosion explosion = new FrostmintExplosion(this.m_9236_(), this.m_19749_(), this.m_20185_(), this.m_20227_(0.5), this.m_20189_(), 2.0f, Explosion.BlockInteraction.KEEP, true);
        explosion.explode();
        explosion.finalizeExplosion(true);
    }

    protected void m_7761_(LivingEntity living) {
        living.m_146917_(living.m_146891_() + 200);
        ((FrostmintFreezableAccessor)living).setFrostmintFreezing(true);
    }

    protected SoundEvent m_7239_() {
        return (SoundEvent)ACSoundRegistry.FROSTMINT_SPEAR_HIT.get();
    }

    public boolean m_6000_(double x, double y, double z) {
        return true;
    }
}

