/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.entity.living;

import com.github.alexmodguy.alexscaves.AlexsCaves;
import com.github.alexmodguy.alexscaves.client.particle.ACParticleRegistry;
import com.github.alexmodguy.alexscaves.server.block.ACBlockRegistry;
import com.github.alexmodguy.alexscaves.server.entity.ACEntityRegistry;
import com.github.alexmodguy.alexscaves.server.entity.ai.AnimalFollowOwnerGoal;
import com.github.alexmodguy.alexscaves.server.entity.ai.AnimalHurtByTargetDefendBabiesGoal;
import com.github.alexmodguy.alexscaves.server.entity.ai.CandicornMeleeGoal;
import com.github.alexmodguy.alexscaves.server.entity.ai.GroundPathNavigatorNoSpin;
import com.github.alexmodguy.alexscaves.server.entity.living.LicowitchEntity;
import com.github.alexmodguy.alexscaves.server.entity.util.KeybindUsingMount;
import com.github.alexmodguy.alexscaves.server.entity.util.PossessedByLicowitch;
import com.github.alexmodguy.alexscaves.server.entity.util.RidingMeterMount;
import com.github.alexmodguy.alexscaves.server.item.ACItemRegistry;
import com.github.alexmodguy.alexscaves.server.message.MountedEntityKeyMessage;
import com.github.alexmodguy.alexscaves.server.misc.ACMath;
import com.github.alexmodguy.alexscaves.server.misc.ACSoundRegistry;
import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.PlayerRideableJumping;
import net.minecraft.world.entity.Saddleable;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;

public class CandicornEntity
extends TamableAnimal
implements KeybindUsingMount,
IAnimatedEntity,
PlayerRideableJumping,
Saddleable,
RidingMeterMount,
PossessedByLicowitch {
    public static final Animation ANIMATION_BUCK = Animation.create((int)25);
    public static final Animation ANIMATION_TAIL_FLICK_1 = Animation.create((int)12);
    public static final Animation ANIMATION_TAIL_FLICK_2 = Animation.create((int)12);
    public static final Animation ANIMATION_NIBBLE_IDLE = Animation.create((int)35);
    public static final Animation ANIMATION_STAB = Animation.create((int)25);
    private static final EntityDataAccessor<Boolean> RUNNING = SynchedEntityData.m_135353_(CandicornEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> LEAPING = SynchedEntityData.m_135353_(CandicornEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> CHARGING = SynchedEntityData.m_135353_(CandicornEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> SADDLED = SynchedEntityData.m_135353_(CandicornEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> COMMAND = SynchedEntityData.m_135353_(CandicornEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> CHARGE_YAW = SynchedEntityData.m_135353_(CandicornEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> METER_AMOUNT = SynchedEntityData.m_135353_(CandicornEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(CandicornEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> POSSESSOR_LICOWITCH_ID = SynchedEntityData.m_135353_(CandicornEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private float prevLeapProgress;
    private float leapProgress;
    private float prevRunProgress;
    private float runProgress;
    private float prevChargeProgress;
    private float vehicleProgress;
    private float prevVehicleProgress;
    private float chargeProgress;
    private float prevSitProgress;
    private float sitProgress;
    private float prevManeAngle;
    private float maneAngle;
    private Animation currentAnimation;
    private int animationTick;
    private float tailYaw = this.m_146908_();
    private float prevTailYaw = this.m_146908_();
    private float leapPitch;
    private float prevLeapPitch;
    private boolean hasRunningAttributes = false;
    private int chargeParticleCooldown = 0;
    private boolean leapImpulse;
    private int playerDrivenChargeTicks = 0;
    private int controllerForwardsTicks;
    protected int gallopSoundCounter;

    public CandicornEntity(EntityType entityType, Level level) {
        super(entityType, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22276_, 30.0).m_22268_(Attributes.f_22281_, 6.0).m_22268_(Attributes.f_22277_, 64.0);
    }

    public static boolean checkCandicornSpawnRules(EntityType<? extends Animal> type, LevelAccessor levelAccessor, MobSpawnType mobType, BlockPos pos, RandomSource randomSource) {
        return levelAccessor.m_8055_(pos.m_7495_()).m_60713_((Block)ACBlockRegistry.BLOCK_OF_FROSTED_CHOCOLATE.get()) && levelAccessor.m_6425_(pos).m_76178_() && levelAccessor.m_6425_(pos.m_7495_()).m_76178_();
    }

    public float m_5610_(BlockPos pos, LevelReader levelReader) {
        return levelReader.m_8055_(pos.m_7495_()).m_60713_((Block)ACBlockRegistry.BLOCK_OF_FROSTED_CHOCOLATE.get()) ? 10.0f : super.m_5610_(pos, levelReader);
    }

    protected PathNavigation m_6037_(Level level) {
        return new GroundPathNavigatorNoSpin((Mob)this, level);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(RUNNING, (Object)false);
        this.f_19804_.m_135372_(LEAPING, (Object)false);
        this.f_19804_.m_135372_(CHARGING, (Object)false);
        this.f_19804_.m_135372_(SADDLED, (Object)false);
        this.f_19804_.m_135372_(COMMAND, (Object)0);
        this.f_19804_.m_135372_(VARIANT, (Object)0);
        this.f_19804_.m_135372_(CHARGE_YAW, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(METER_AMOUNT, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(POSSESSOR_LICOWITCH_ID, (Object)0);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(2, (Goal)new AnimalFollowOwnerGoal(this, 1.0, 8.0f, 1.4f, false){

            @Override
            public boolean shouldFollow() {
                return CandicornEntity.this.getCommand() == 2;
            }

            @Override
            public void tickDistance(float distanceTo) {
                CandicornEntity.this.setRunning(distanceTo > 5.0f);
            }
        });
        this.f_21345_.m_25352_(3, (Goal)new PanicGoal((PathfinderMob)this, 1.0){

            public boolean m_202729_() {
                return CandicornEntity.this.m_6162_() && super.m_202729_();
            }

            public void m_8056_() {
                super.m_8056_();
                CandicornEntity.this.setRunning(true);
            }

            public void m_8041_() {
                super.m_8041_();
                CandicornEntity.this.setRunning(false);
            }
        });
        this.f_21345_.m_25352_(4, (Goal)new CandicornMeleeGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new FollowParentGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new TemptGoal((PathfinderMob)this, 1.1, Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ACItemRegistry.CARAMEL_APPLE.get()}), false));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(10, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(2, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(3, (Goal)new AnimalHurtByTargetDefendBabiesGoal((Animal)this, CandicornEntity.class));
    }

    @org.jetbrains.annotations.Nullable
    public AgeableMob m_142606_(ServerLevel serverLevel, AgeableMob ageableMob) {
        CandicornEntity candicornEntity = (CandicornEntity)((EntityType)ACEntityRegistry.CANDICORN.get()).m_20615_((Level)serverLevel);
        candicornEntity.setVariant(this.getVariant());
        return candicornEntity;
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public boolean isRunning() {
        return (Boolean)this.f_19804_.m_135370_(RUNNING);
    }

    public void setRunning(boolean bool) {
        this.f_19804_.m_135381_(RUNNING, (Object)bool);
    }

    public boolean isLeaping() {
        return (Boolean)this.f_19804_.m_135370_(LEAPING);
    }

    public void setLeaping(boolean bool) {
        this.f_19804_.m_135381_(LEAPING, (Object)bool);
    }

    public boolean isCharging() {
        return (Boolean)this.f_19804_.m_135370_(CHARGING);
    }

    public void setCharging(boolean bool) {
        this.f_19804_.m_135381_(CHARGING, (Object)bool);
    }

    public boolean m_6741_() {
        return this.m_6084_() && !this.m_6162_() && this.m_21824_();
    }

    public void m_5853_(@org.jetbrains.annotations.Nullable SoundSource soundSource) {
        this.setSaddled(true);
        if (soundSource != null) {
            this.m_9236_().m_6269_((Player)null, (Entity)this, SoundEvents.f_12236_, soundSource, 0.5f, 1.0f);
        }
    }

    public boolean m_6254_() {
        return (Boolean)this.f_19804_.m_135370_(SADDLED);
    }

    public void setSaddled(boolean bool) {
        this.f_19804_.m_135381_(SADDLED, (Object)bool);
    }

    public int getCommand() {
        return (Integer)this.f_19804_.m_135370_(COMMAND);
    }

    public void setCommand(int command) {
        this.f_19804_.m_135381_(COMMAND, (Object)command);
    }

    public int getVariant() {
        return (Integer)this.f_19804_.m_135370_(VARIANT);
    }

    public void setVariant(int variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)variant);
    }

    public float getChargeYaw() {
        return ((Float)this.f_19804_.m_135370_(CHARGE_YAW)).floatValue();
    }

    public void setChargeYaw(float chargeYaw) {
        this.f_19804_.m_135381_(CHARGE_YAW, (Object)Float.valueOf(chargeYaw));
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("Command", this.getCommand());
        compound.m_128379_("Saddled", this.m_6254_());
        compound.m_128405_("Variant", this.getVariant());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setCommand(compound.m_128451_("Command"));
        this.setSaddled(compound.m_128471_("Saddled"));
        this.setVariant(compound.m_128451_("Variant"));
    }

    public void m_8119_() {
        LivingEntity controllingPassenger;
        super.m_8119_();
        this.prevLeapProgress = this.leapProgress;
        this.prevRunProgress = this.runProgress;
        this.prevChargeProgress = this.chargeProgress;
        this.prevSitProgress = this.sitProgress;
        this.prevTailYaw = this.tailYaw;
        this.prevVehicleProgress = this.vehicleProgress;
        this.prevManeAngle = this.maneAngle;
        this.prevLeapPitch = this.leapPitch;
        this.leapPitch = Mth.m_14036_((float)((float)this.m_20184_().f_82480_), (float)-0.5f, (float)1.5f) * -57.295776f;
        if (this.isLeaping() && this.leapProgress < 5.0f) {
            this.leapProgress += 1.0f;
        }
        if (!this.isLeaping() && this.leapProgress > 0.0f) {
            this.leapProgress -= 1.0f;
        }
        if (this.isRunning() && this.runProgress < 5.0f) {
            this.runProgress += 1.0f;
        }
        if (!this.isRunning() && this.runProgress > 0.0f) {
            this.runProgress -= 1.0f;
        }
        if (this.isCharging() && this.chargeProgress < 5.0f) {
            this.chargeProgress += 1.0f;
        }
        if (!this.isCharging() && this.chargeProgress > 0.0f) {
            this.chargeProgress = Math.max(0.0f, this.chargeProgress - 0.25f);
        }
        if (this.m_21825_() && this.sitProgress < 5.0f) {
            this.sitProgress += 1.0f;
        }
        if (!this.m_21825_() && this.sitProgress > 0.0f) {
            this.sitProgress -= 1.0f;
        }
        if (this.m_6688_() != null && this.vehicleProgress < 5.0f) {
            this.vehicleProgress += 1.0f;
        }
        if (this.m_6688_() == null && this.vehicleProgress > 0.0f) {
            this.vehicleProgress -= 1.0f;
        }
        if (this.m_20096_() && this.isLeaping() && !this.leapImpulse) {
            this.setLeaping(false);
        }
        if (this.leapImpulse) {
            this.leapImpulse = false;
        }
        if (this.isCharging()) {
            Vec3 chargeFocalPoint = this.m_20182_().m_82549_(new Vec3(0.0, 0.0, 1.0).m_82524_((float)Math.toRadians(-this.getChargeYaw())));
            for (LivingEntity entity : this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82400_(3.5))) {
                float dist = (float)entity.m_20238_(chargeFocalPoint);
                if (this.m_21824_() && this.m_7307_((Entity)entity) || entity.m_20365_((Entity)this) || entity instanceof CandicornEntity || entity == this || !(dist < 7.0f)) continue;
                float dmgExtra = 7.0f - dist;
                entity.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), 7.0f + dmgExtra);
                entity.m_147240_(2.0, chargeFocalPoint.f_82479_ - entity.m_20185_(), chargeFocalPoint.f_82481_ - entity.m_20189_());
            }
            if (!this.m_20160_()) {
                this.m_146922_(Mth.m_14148_((float)this.f_19859_, (float)this.getChargeYaw(), (float)25.0f));
                this.f_20884_ = this.f_20883_ = Mth.m_14148_((float)this.f_20883_, (float)this.getChargeYaw(), (float)25.0f);
                this.f_20886_ = this.f_20885_ = this.m_146908_();
            }
        }
        if (this.chargeParticleCooldown <= 0 && this.chargeProgress > 2.5f) {
            this.chargeParticleCooldown = 3;
            this.m_9236_().m_6485_((ParticleOptions)ACParticleRegistry.CANDICORN_CHARGE.get(), true, this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), (double)this.m_19879_(), 0.0, (double)this.getChargeYaw());
        }
        if (this.chargeParticleCooldown > 0) {
            --this.chargeParticleCooldown;
        }
        if (!this.m_9236_().f_46443_) {
            if (this.m_20184_().m_165924_() < 0.02 && this.f_19796_.m_188503_(200) == 0 && this.controllerForwardsTicks <= 0 && this.getAnimation() == NO_ANIMATION && !this.m_21525_() && !this.m_21825_()) {
                float rand = this.f_19796_.m_188501_();
                Animation idle = rand < 0.15f ? ANIMATION_BUCK : (rand < 0.6f ? (this.f_19796_.m_188499_() ? ANIMATION_TAIL_FLICK_1 : ANIMATION_TAIL_FLICK_2) : ANIMATION_NIBBLE_IDLE);
                this.setAnimation(idle);
            }
            if (this.isRunning() && !this.hasRunningAttributes) {
                this.hasRunningAttributes = true;
                this.m_21051_(Attributes.f_22279_).m_22100_(0.5);
            }
            if (!this.isRunning() && this.hasRunningAttributes) {
                this.hasRunningAttributes = false;
                this.m_21051_(Attributes.f_22279_).m_22100_(0.25);
            }
        } else {
            Player player = AlexsCaves.PROXY.getClientSidePlayer();
            if (player != null && player.m_20365_((Entity)this) && AlexsCaves.PROXY.isKeyDown(2) && this.getMeterAmount() >= 1.0f && this.isRunning()) {
                AlexsCaves.sendMSGToServer(new MountedEntityKeyMessage(this.m_19879_(), player.m_19879_(), 2));
            }
            this.spawnPossessedParticles(this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), this.m_9236_());
        }
        if ((controllingPassenger = this.m_6688_()) != null) {
            float f = Mth.m_14118_((float)controllingPassenger.m_6080_(), (float)this.f_20883_);
            if (Math.abs(f) > 2.0f) {
                this.maneAngle = f < 0.0f ? Mth.m_14121_((float)this.maneAngle, (float)-1.0f, (float)0.3f) : Mth.m_14121_((float)this.maneAngle, (float)1.0f, (float)0.3f);
            }
            if (!this.m_9236_().f_46443_) {
                if (this.touchingWall()) {
                    this.setRunning(false);
                    this.setCharging(false);
                    this.playerDrivenChargeTicks = 0;
                    this.controllerForwardsTicks = 0;
                }
                if (this.playerDrivenChargeTicks > 0) {
                    this.setCharging(true);
                    this.setRunning(true);
                    this.setChargeYaw(controllingPassenger.m_6080_());
                    --this.playerDrivenChargeTicks;
                } else if (this.isCharging()) {
                    this.setCharging(false);
                }
                if (this.controllerForwardsTicks > 20) {
                    this.setRunning(true);
                } else {
                    this.setRunning(false);
                    this.setCharging(false);
                    this.playerDrivenChargeTicks = 0;
                }
                if (this.getMeterAmount() < 1.0f && !this.isCharging() && this.isRunning()) {
                    this.setMeterAmount(Math.min(this.getMeterAmount() + 0.005f, 1.0f));
                }
            }
        } else {
            if (this.controllerForwardsTicks > 0) {
                this.controllerForwardsTicks = 0;
                this.setRunning(false);
            }
            if (this.playerDrivenChargeTicks > 0) {
                this.playerDrivenChargeTicks = 0;
                this.setCharging(false);
            }
            this.setMeterAmount(0.0f);
        }
        if (this.isCharging() && this.m_6084_()) {
            AlexsCaves.PROXY.playWorldSound(this, (byte)19);
        }
        this.tailYaw = Mth.m_14148_((float)this.tailYaw, (float)this.f_20883_, (float)10.0f);
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
    }

    public void m_142687_(Entity.RemovalReason removalReason) {
        AlexsCaves.PROXY.clearSoundCacheFor((Entity)this);
        super.m_142687_(removalReason);
    }

    public boolean touchingWall() {
        if (this.f_19794_) {
            return false;
        }
        float f = this.m_20205_() + 0.1f;
        AABB aabb = AABB.m_165882_((Vec3)this.m_146892_(), (double)f, (double)1.0E-6, (double)f);
        return BlockPos.m_121921_((AABB)aabb).anyMatch(p_201942_ -> {
            BlockState blockstate = this.m_9236_().m_8055_(p_201942_);
            return !blockstate.m_60795_() && blockstate.m_60828_((BlockGetter)this.m_9236_(), p_201942_) && Shapes.m_83157_((VoxelShape)blockstate.m_60812_((BlockGetter)this.m_9236_(), p_201942_).m_83216_((double)p_201942_.m_123341_(), (double)p_201942_.m_123342_(), (double)p_201942_.m_123343_()), (VoxelShape)Shapes.m_83064_((AABB)aabb), (BooleanOp)BooleanOp.f_82689_);
        });
    }

    public boolean m_21825_() {
        return super.m_21825_() && !this.m_20160_() && !this.m_20159_();
    }

    public float getLeapProgress(float partialTicks) {
        return (this.prevLeapProgress + (this.leapProgress - this.prevLeapProgress) * partialTicks) * 0.2f;
    }

    public float getRunProgress(float partialTicks) {
        return (this.prevRunProgress + (this.runProgress - this.prevRunProgress) * partialTicks) * 0.2f;
    }

    public float getChargeProgress(float partialTicks) {
        return (this.prevChargeProgress + (this.chargeProgress - this.prevChargeProgress) * partialTicks) * 0.2f;
    }

    public float getSitProgress(float partialTicks) {
        return (this.prevSitProgress + (this.sitProgress - this.prevSitProgress) * partialTicks) * 0.2f;
    }

    public float getVehicleProgress(float partialTicks) {
        return (this.prevVehicleProgress + (this.vehicleProgress - this.prevVehicleProgress) * partialTicks) * 0.2f;
    }

    public float getManeAngle(float partialTicks) {
        return this.prevManeAngle + (this.maneAngle - this.prevManeAngle) * partialTicks;
    }

    public float getTailYaw(float partialTick) {
        return this.prevTailYaw + (this.tailYaw - this.prevTailYaw) * partialTick;
    }

    public float getLeapPitch(float partialTicks) {
        return this.prevLeapPitch + (this.leapPitch - this.prevLeapPitch) * partialTicks;
    }

    public float getStepHeight() {
        return this.isCharging() && this.m_20160_() ? 2.2f : 1.2f;
    }

    @Override
    public void onKeyPacket(Entity keyPresser, int type) {
        if (keyPresser.m_20365_((Entity)this) && type == 2 && this.getMeterAmount() >= 1.0f) {
            this.setChargeYaw(keyPresser.m_6080_());
            this.playerDrivenChargeTicks = 100;
            this.setMeterAmount(0.0f);
        }
    }

    public boolean m_6898_(ItemStack itemStack) {
        return itemStack.m_150930_(((Block)ACBlockRegistry.CANDY_CANE.get()).m_5456_());
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (itemstack.m_150930_((Item)ACItemRegistry.CARAMEL_APPLE.get()) && !this.m_21824_()) {
            this.m_142075_(player, hand, itemstack);
            if (this.m_217043_().m_188503_(3) == 0) {
                this.m_21828_(player);
                this.m_9236_().m_7605_((Entity)this, (byte)7);
            } else {
                this.m_9236_().m_7605_((Entity)this, (byte)6);
            }
            return InteractionResult.SUCCESS;
        }
        if (this.m_6741_() && !this.m_6254_() && itemstack.m_150930_(Items.f_42450_)) {
            this.m_142075_(player, hand, itemstack);
            this.setSaddled(true);
            return InteractionResult.SUCCESS;
        }
        InteractionResult interactionresult = itemstack.m_41647_(player, (LivingEntity)this, hand);
        InteractionResult type = super.m_6071_(player, hand);
        if (!interactionresult.m_19077_() && !type.m_19077_()) {
            if (itemstack.m_150930_(Items.f_42574_) && this.m_6254_() && this.m_21824_() && this.m_21830_((LivingEntity)player)) {
                this.m_146852_(GameEvent.f_157781_, (Entity)player);
                itemstack.m_41622_(1, (LivingEntity)player, player1 -> player1.m_21190_(hand));
                this.m_9236_().m_6269_((Player)null, (Entity)this, SoundEvents.f_12344_, SoundSource.PLAYERS, 1.0f, 1.0f);
                this.setSaddled(false);
                return InteractionResult.SUCCESS;
            }
            if (this.m_21824_() && this.m_21830_((LivingEntity)player) && !this.m_6898_(itemstack)) {
                if (player.m_6144_()) {
                    boolean sit;
                    this.setCommand(this.getCommand() + 1);
                    if (this.getCommand() == 3) {
                        this.setCommand(0);
                    }
                    player.m_5661_((Component)Component.m_237110_((String)("entity.alexscaves.all.command_" + this.getCommand()), (Object[])new Object[]{this.m_7755_()}), true);
                    boolean bl = sit = this.getCommand() == 1;
                    if (sit) {
                        this.m_21839_(true);
                    } else {
                        this.m_21839_(false);
                    }
                    return InteractionResult.SUCCESS;
                }
                if (this.m_6254_()) {
                    if (!this.m_9236_().f_46443_ && player.m_20329_((Entity)this)) {
                        return InteractionResult.CONSUME;
                    }
                    return InteractionResult.SUCCESS;
                }
            }
        }
        return type;
    }

    public Animation[] getAnimations() {
        return new Animation[]{ANIMATION_BUCK, ANIMATION_TAIL_FLICK_1, ANIMATION_TAIL_FLICK_2, ANIMATION_NIBBLE_IDLE, ANIMATION_STAB};
    }

    public int getParticleColor() {
        switch (this.getVariant()) {
            case 1: {
                return 16756178;
            }
            case 2: {
                return 0xDFF3FF;
            }
            case 3: {
                return 11010000;
            }
            case 4: {
                return 16759540;
            }
        }
        return 16772951;
    }

    public void m_7888_(int i) {
        this.setLeaping(true);
        if (this.m_20096_()) {
            this.leapImpulse = true;
            float f = 0.2f + (float)i * 0.01f;
            Vec3 jumpForwards = new Vec3(0.0, (double)f, (double)this.f_20902_).m_82524_((float)Math.toRadians(-this.f_20883_));
            this.m_20256_(this.m_20184_().m_82549_(jumpForwards));
        }
    }

    public boolean m_7132_() {
        return this.m_6254_() && !this.isLeaping();
    }

    public void m_7199_(int i) {
    }

    public void m_8012_() {
    }

    protected Vec3 m_274312_(Player player, Vec3 deltaIn) {
        float f = player.f_20902_ < 0.0f ? 0.5f : 1.0f;
        return new Vec3((double)(player.f_20900_ * 0.35f), 0.0, (double)(player.f_20902_ * 0.8f * f));
    }

    protected int m_5639_(float f1, float f2) {
        return Mth.m_14167_((float)((f1 * 0.33f - 5.0f) * f2));
    }

    public boolean m_142535_(float f1, float f2, DamageSource damageSource) {
        float[] ret = ForgeHooks.onLivingFall((LivingEntity)this, (float)f1, (float)f2);
        if (ret == null) {
            return false;
        }
        f1 = ret[0];
        f2 = ret[1];
        boolean flag = this.causeInternalFallDamage(f1, f2, damageSource);
        int i = this.m_5639_(f1, f2);
        if (i > 0) {
            this.m_5496_(i > 4 ? this.m_196493_().f_196627_() : this.m_196493_().f_196626_(), 1.0f, 1.0f);
            this.m_21229_();
            this.m_6469_(damageSource, i);
            return true;
        }
        return flag;
    }

    private boolean causeInternalFallDamage(float f1, float f2, DamageSource damageSource) {
        float[] ret = ForgeHooks.onLivingFall((LivingEntity)this, (float)f1, (float)f2);
        if (ret == null) {
            return false;
        }
        f1 = ret[0];
        f2 = ret[1];
        int i = this.m_5639_(f1, f2);
        if (i > 0) {
            this.m_21229_();
            this.m_6469_(damageSource, i);
            return true;
        }
        return this.m_6095_().m_204039_(EntityTypeTags.f_273841_);
    }

    protected void m_274498_(Player player, Vec3 vec3) {
        super.m_274498_(player, vec3);
        if (player.f_20902_ != 0.0f || player.f_20900_ != 0.0f) {
            this.m_19915_(player.m_146908_(), player.m_146909_() * 0.25f);
            this.m_5616_(player.m_6080_());
            this.m_6710_(null);
        }
        if (vec3.f_82481_ <= 0.0) {
            this.gallopSoundCounter = 0;
        }
        this.controllerForwardsTicks = player.f_20902_ > 0.0f ? ++this.controllerForwardsTicks : 0;
    }

    protected float m_245547_(Player rider) {
        float f = 0.0f;
        if (this.isCharging()) {
            f = 0.25f;
        } else if (this.controllerForwardsTicks < 20) {
            f = (float)(20 - this.controllerForwardsTicks) * -0.005f;
        }
        return (float)this.m_21133_(Attributes.f_22279_) + f;
    }

    public void m_7350_(EntityDataAccessor<?> dataAccessor) {
        if (CHARGING.equals(dataAccessor) && this.isCharging()) {
            this.m_216990_((SoundEvent)ACSoundRegistry.CANDICORN_CHARGE_START.get());
        }
        super.m_7350_(dataAccessor);
    }

    public LivingEntity m_6688_() {
        Entity entity = this.m_146895_();
        if (entity instanceof Player) {
            return (Player)entity;
        }
        return null;
    }

    protected void m_5907_() {
        super.m_5907_();
        if (this.m_6254_()) {
            this.m_19998_((ItemLike)Items.f_42450_);
        }
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ACSoundRegistry.CANDICORN_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)ACSoundRegistry.CANDICORN_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ACSoundRegistry.CANDICORN_DEATH.get();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void m_19956_(Entity passenger, Entity.MoveFunction moveFunction) {
        if (this.m_20365_(passenger) && passenger instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)passenger;
            if (!this.m_146899_()) {
                float f;
                float animationUp = 0.0f;
                float animationBack = 0.0f;
                if (this.getAnimation() == ANIMATION_BUCK) {
                    f = ACMath.cullAnimationTick(this.getAnimationTick(), 2.5f, this.getAnimation(), 1.0f, 0, 25);
                    animationUp = 0.25f * f;
                    animationBack = f;
                }
                if (this.getAnimation() == ANIMATION_STAB) {
                    f = ACMath.cullAnimationTick(this.getAnimationTick(), 2.0f, this.getAnimation(), 1.0f, 0, 11);
                    animationUp = 0.15f * f;
                    animationBack = 1.5f * f;
                }
                Vec3 seatOffset = new Vec3(0.0, (double)(-0.4f + animationUp), (double)(-0.2f - animationBack)).m_82524_((float)Math.toRadians(-this.f_20883_));
                passenger.m_5618_(this.f_20883_);
                passenger.f_19789_ = 0.0f;
                moveFunction.m_20372_(passenger, this.m_20185_() + seatOffset.f_82479_, this.m_20186_() + seatOffset.f_82480_ + this.m_6048_(), this.m_20189_() + seatOffset.f_82481_);
                return;
            }
        }
        super.m_19956_(passenger, moveFunction);
    }

    public Vec3 m_7688_(LivingEntity p_20123_) {
        return new Vec3(this.m_20185_(), this.m_20191_().f_82289_, this.m_20189_());
    }

    @Override
    public boolean hasRidingMeter() {
        return true;
    }

    @Override
    public float getMeterAmount() {
        return ((Float)this.f_19804_.m_135370_(METER_AMOUNT)).floatValue();
    }

    public void setMeterAmount(float roarPower) {
        this.f_19804_.m_135381_(METER_AMOUNT, (Object)Float.valueOf(roarPower));
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        if (spawnDataIn == null) {
            spawnDataIn = new AgeableMob.AgeableMobGroupData(0.2f);
        }
        this.setVariant(this.f_19796_.m_188503_(5));
        return super.m_6518_(level, difficultyIn, reason, spawnDataIn, dataTag);
    }

    @Override
    public void setPossessedByLicowitchId(int entityId) {
        this.f_19804_.m_135381_(POSSESSOR_LICOWITCH_ID, (Object)entityId);
    }

    @Override
    public int getPossessedByLicowitchId() {
        return (Integer)this.f_19804_.m_135370_(POSSESSOR_LICOWITCH_ID);
    }

    protected boolean m_6125_() {
        return super.m_6125_() && this.getPossessedByLicowitchId() == -1;
    }

    public boolean m_6779_(LivingEntity living) {
        LicowitchEntity licowitch;
        if (this.getPossessedByLicowitchId() != -1 && (licowitch = this.getPossessingLicowitch(this.m_9236_())) != null && licowitch.isFriendlyFire(living)) {
            return false;
        }
        return super.m_6779_(living);
    }

    public boolean m_7301_(MobEffectInstance effectInstance) {
        return super.m_7301_(effectInstance) && effectInstance.m_19544_() != MobEffects.f_19612_;
    }

    protected void m_7355_(BlockPos blockPos, BlockState blockState) {
        if (!blockState.m_278721_()) {
            BlockState blockstate = this.m_9236_().m_8055_(blockPos.m_7494_());
            SoundType soundtype = blockState.getSoundType((LevelReader)this.m_9236_(), blockPos, (Entity)this);
            if (blockstate.m_60713_(Blocks.f_50125_)) {
                soundtype = blockstate.getSoundType((LevelReader)this.m_9236_(), blockPos, (Entity)this);
            }
            if (this.m_20160_()) {
                ++this.gallopSoundCounter;
                if (this.gallopSoundCounter > 5 && this.gallopSoundCounter % 6 == 0) {
                    this.m_5496_((SoundEvent)ACSoundRegistry.CANDICORN_GALLOP.get(), soundtype.m_56773_() * 0.2f, soundtype.m_56774_());
                } else if (this.gallopSoundCounter <= 10) {
                    this.m_5496_((SoundEvent)ACSoundRegistry.CANDICORN_STEP.get(), soundtype.m_56773_() * 0.15f, soundtype.m_56774_());
                }
            } else {
                this.m_5496_((SoundEvent)ACSoundRegistry.CANDICORN_STEP.get(), soundtype.m_56773_() * 0.15f, soundtype.m_56774_());
            }
        }
    }
}

