/*
 * Decompiled with CFR 0.152.
 */
package com.lupicus.vm;

import com.lupicus.vm.block.ModBlocks;
import com.lupicus.vm.config.MyConfig;
import com.lupicus.vm.item.ModItems;
import com.lupicus.vm.sound.ModSounds;
import com.lupicus.vm.tileentity.ModTileEntities;
import com.lupicus.vm.tileentity.VendingMachineTileEntity;
import com.lupicus.vm.world.ModVillage;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegisterEvent;
import org.jetbrains.annotations.NotNull;

@Mod(value="vm")
public class Main {
    public static final String MODID = "vm";

    public Main() {
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)this);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)MyConfig.COMMON_SPEC);
    }

    @SubscribeEvent
    public void setupCommon(FMLCommonSetupEvent event) {
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void setupClient(FMLClientSetupEvent event) {
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class ForgeEvents {
        @SubscribeEvent
        public static void onStart(ServerAboutToStartEvent event) {
            if (MyConfig.villages) {
                ModVillage.updatePools(event.getServer());
            }
        }

        @SubscribeEvent
        public static void onStop(ServerStoppedEvent event) {
            if (!event.getServer().m_6982_()) {
                VendingMachineTileEntity.clearData();
            }
        }

        @SubscribeEvent
        public static void onTags(TagsUpdatedEvent event) {
            if (event.getUpdateCause() == TagsUpdatedEvent.UpdateCause.SERVER_DATA_LOAD) {
                MyConfig.updateTags();
            }
        }
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ModEvents {
        @SubscribeEvent
        public static void onRegister(RegisterEvent event) {
            @NotNull ResourceKey key = event.getRegistryKey();
            if (key.equals((Object)ForgeRegistries.Keys.BLOCKS)) {
                ModBlocks.register((IForgeRegistry<Block>)event.getForgeRegistry());
            } else if (key.equals((Object)ForgeRegistries.Keys.ITEMS)) {
                ModItems.register((IForgeRegistry<Item>)event.getForgeRegistry());
            } else if (key.equals((Object)ForgeRegistries.Keys.BLOCK_ENTITY_TYPES)) {
                ModTileEntities.register(event.getForgeRegistry());
            } else if (key.equals((Object)ForgeRegistries.Keys.SOUND_EVENTS)) {
                ModSounds.register((IForgeRegistry<SoundEvent>)event.getForgeRegistry());
            }
        }

        @SubscribeEvent
        public static void onCreativeTab(BuildCreativeModeTabContentsEvent event) {
            ModItems.setupTabs(event);
        }
    }
}

