/*
 * Decompiled with CFR 0.152.
 */
package com.lupicus.vm.block;

import com.lupicus.vm.block.RotateContainerBase;
import com.lupicus.vm.config.MyConfig;
import com.lupicus.vm.item.ModItems;
import com.lupicus.vm.tileentity.VendingMachineTileEntity;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;

public class VendingMachine
extends RotateContainerBase {
    public static final BooleanProperty BOTTOM = BlockStateProperties.f_61427_;
    private BlockEntity saveTE;
    private BlockState saveState;

    public VendingMachine(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)HORIZONTAL_FACING, (Comparable)Direction.NORTH)).m_61124_((Property)BOTTOM, (Comparable)Boolean.valueOf(true)));
    }

    public static boolean isNormalCube(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return false;
    }

    public static int lightValue(BlockState state) {
        return 8;
    }

    public static boolean isEnabled(BlockState state) {
        return (Boolean)state.m_61143_((Property)BOTTOM);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        if (!context.m_43725_().m_8055_(context.m_8083_().m_7494_()).m_60629_(context)) {
            return null;
        }
        return (BlockState)this.m_49966_().m_61124_((Property)HORIZONTAL_FACING, (Comparable)context.m_8125_().m_122424_());
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (!worldIn.f_46443_) {
            BlockEntity te;
            if (!((Boolean)state.m_61143_((Property)BOTTOM)).booleanValue()) {
                pos = pos.m_7495_();
            }
            if ((te = worldIn.m_7702_(pos)) instanceof VendingMachineTileEntity) {
                ((VendingMachineTileEntity)te).openGui(player);
            }
        }
        return InteractionResult.SUCCESS;
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.m_6402_(worldIn, pos, state, placer, stack);
        if (!worldIn.f_46443_) {
            BlockEntity te;
            worldIn.m_7731_(pos.m_7494_(), (BlockState)state.m_61124_((Property)BOTTOM, (Comparable)Boolean.valueOf(false)), 3);
            CompoundTag tag = stack.m_41783_();
            if (tag != null && (te = worldIn.m_7702_(pos)) instanceof VendingMachineTileEntity) {
                VendingMachineTileEntity vte = (VendingMachineTileEntity)te;
                vte.readMined(tag);
                if (stack.m_41788_()) {
                    vte.setCustomName(stack.m_41786_());
                }
            }
        }
    }

    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockPos pos2;
        if (!worldIn.f_46443_ && state.m_60734_() != newState.m_60734_() && worldIn.m_8055_(pos2 = pos.m_121945_((Boolean)state.m_61143_((Property)BOTTOM) != false ? Direction.UP : Direction.DOWN)).m_60734_() == this) {
            worldIn.m_7731_(pos2, Blocks.f_50016_.m_49966_(), 3);
        }
        super.m_6810_(state, worldIn, pos, newState, isMoving);
    }

    public boolean onDestroyedByPlayer(BlockState state, Level world, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        boolean flag;
        boolean bl = flag = !world.f_46443_;
        if (flag) {
            this.saveTE = null;
            if (!((Boolean)state.m_61143_((Property)BOTTOM)).booleanValue()) {
                this.saveMainBlock((BlockGetter)world, pos);
            }
        }
        boolean removed = super.onDestroyedByPlayer(state, world, pos, player, willHarvest, fluid);
        if (!(!flag || removed && willHarvest)) {
            this.saveTE = null;
        }
        return removed;
    }

    public boolean canDropFromExplosion(BlockState state, BlockGetter world, BlockPos pos, Explosion explosion) {
        if (world instanceof ServerLevel) {
            this.saveTE = null;
            if (!((Boolean)state.m_61143_((Property)BOTTOM)).booleanValue()) {
                this.saveMainBlock(world, pos);
            }
        }
        return true;
    }

    private void saveMainBlock(BlockGetter world, BlockPos pos) {
        BlockPos blockpos = pos.m_121945_(Direction.DOWN);
        BlockState blockstate = world.m_8055_(blockpos);
        if (blockstate.m_60734_() == this && ((Boolean)blockstate.m_61143_((Property)BOTTOM)).booleanValue()) {
            this.saveTE = world.m_7702_(blockpos);
            this.saveState = blockstate;
        }
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        BlockEntity entity;
        if (this.saveTE != null) {
            builder.m_287289_(LootContextParams.f_81462_, (Object)this.saveTE);
            state = this.saveState;
            this.saveTE = null;
        }
        if (!MyConfig.minable) {
            return Collections.emptyList();
        }
        List ret = super.m_49635_(state, builder);
        if (!ret.isEmpty() && (entity = (BlockEntity)builder.m_287261_(LootContextParams.f_81462_)) instanceof VendingMachineTileEntity) {
            VendingMachineTileEntity vte = (VendingMachineTileEntity)entity;
            for (ItemStack e : ret) {
                if (e.m_41720_() != ModItems.VENDING_MACHINE) continue;
                CompoundTag tag = e.m_41784_();
                vte.writeMined(tag);
                if (!vte.m_8077_()) continue;
                e.m_41714_(vte.m_7770_());
            }
        }
        return ret;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new VendingMachineTileEntity(pos, state);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{HORIZONTAL_FACING, BOTTOM});
    }
}

