/*
 * Decompiled with CFR 0.152.
 */
package com.lupicus.vm.config;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.logging.LogUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.LiteralContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.ForgeSpawnEggItem;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;

@Mod.EventBusSubscriber(modid="vm", bus=Mod.EventBusSubscriber.Bus.MOD)
public class MyConfig {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int ITEM_COUNT = 7;
    public static final Common COMMON;
    public static final ForgeConfigSpec COMMON_SPEC;
    public static int loadId;
    public static boolean disableGroups;
    private static boolean tagsLoaded;
    private static boolean anyTags;
    public static boolean restock;
    public static boolean fixed;
    public static boolean minable;
    public static boolean villages;
    public static boolean includeAllItems;
    public static HashSet<Item> excludeItemSet;
    public static HashSet<Item> includeItemSet;
    public static HashSet<Item> addItemSet;
    public static HashSet<String> excludeModSet;
    public static HashSet<String> includeModSet;
    public static HashSet<String> excludeGroupSet;
    public static HashSet<String> includeGroupSet;
    public static HashMap<Item, Rarity> itemRarityMap;
    public static HashMap<Item, CostData> itemCostMap;
    public static HashMap<Rarity, CostData> rarityCostMap;
    public static int commonCost;
    public static int uncommonCost;
    public static int rareCost;
    public static int epicCost;
    public static int commonUses;
    public static int uncommonUses;
    public static int rareUses;
    public static int epicUses;
    public static Item commonItem;
    public static Item uncommonItem;
    public static Item rareItem;
    public static Item epicItem;
    public static boolean[] fixedExtended;
    public static Item[] fixedItems;
    public static CompoundTag[] fixedTags;
    public static int[] fixedAmount;
    public static int[] fixedUses;
    public static ItemStack[] fixedPayment;
    public static HashMap<CreativeModeTab, String> groupName;

    @SubscribeEvent
    public static void onModConfigEvent(ModConfigEvent configEvent) {
        if (configEvent.getConfig().getSpec() == COMMON_SPEC) {
            MyConfig.bakeConfig();
        }
    }

    public static void setDisableGroups(Throwable t) {
        LOGGER.error("Disabling tab group logic due to the following exception", t);
        disableGroups = true;
        MyConfig.updateItems();
    }

    public static void updateTags() {
        tagsLoaded = true;
        if (!anyTags) {
            return;
        }
        if (!includeAllItems) {
            includeItemSet = null;
            includeItemSet = MyConfig.itemSet(MyConfig.toArray((List)MyConfig.COMMON.includeItems.get()), "IncludeItems");
        }
        excludeItemSet = null;
        excludeItemSet = MyConfig.itemSet(MyConfig.toArray((List)MyConfig.COMMON.excludeItems.get()), "ExcludeItems");
        addItemSet = null;
        addItemSet = MyConfig.itemSet(MyConfig.toArray((List)MyConfig.COMMON.addItems.get()), "AddItems");
        itemRarityMap = null;
        itemRarityMap = MyConfig.itemMap(MyConfig.toArray((List)MyConfig.COMMON.itemRarity.get()));
        itemCostMap = null;
        itemCostMap = MyConfig.costMap(MyConfig.toArray((List)MyConfig.COMMON.itemCost.get()));
        if (disableGroups) {
            MyConfig.updateItems();
        }
    }

    public static synchronized void bakeConfig() {
        anyTags = false;
        restock = (Boolean)MyConfig.COMMON.restock.get();
        fixed = (Boolean)MyConfig.COMMON.fixed.get();
        minable = (Boolean)MyConfig.COMMON.minable.get();
        villages = (Boolean)MyConfig.COMMON.villages.get();
        commonCost = (Integer)MyConfig.COMMON.commonCost.get();
        uncommonCost = (Integer)MyConfig.COMMON.uncommonCost.get();
        rareCost = (Integer)MyConfig.COMMON.rareCost.get();
        epicCost = (Integer)MyConfig.COMMON.epicCost.get();
        commonUses = (Integer)MyConfig.COMMON.commonUses.get();
        uncommonUses = (Integer)MyConfig.COMMON.uncommonUses.get();
        rareUses = (Integer)MyConfig.COMMON.rareUses.get();
        epicUses = (Integer)MyConfig.COMMON.epicUses.get();
        commonItem = MyConfig.getItem((String)MyConfig.COMMON.commonItem.get());
        uncommonItem = MyConfig.getItem((String)MyConfig.COMMON.uncommonItem.get());
        rareItem = MyConfig.getItem((String)MyConfig.COMMON.rareItem.get());
        epicItem = MyConfig.getItem((String)MyConfig.COMMON.epicItem.get());
        rarityCostMap = MyConfig.rarityCostMap();
        MyConfig.extractFixed(MyConfig.toArray((List)MyConfig.COMMON.fixedItems.get()));
        includeModSet = MyConfig.stringSet(MyConfig.toArray((List)MyConfig.COMMON.includeMods.get()));
        excludeModSet = MyConfig.stringSet(MyConfig.toArray((List)MyConfig.COMMON.excludeMods.get()));
        String[] temp = MyConfig.toArray((List)MyConfig.COMMON.includeItems.get());
        includeAllItems = MyConfig.hasAll(temp);
        if (includeAllItems) {
            temp = new String[]{};
        }
        includeItemSet = MyConfig.itemSet(temp, "IncludeItems");
        excludeItemSet = MyConfig.itemSet(MyConfig.toArray((List)MyConfig.COMMON.excludeItems.get()), "ExcludeItems");
        addItemSet = MyConfig.itemSet(MyConfig.toArray((List)MyConfig.COMMON.addItems.get()), "AddItems");
        includeGroupSet = MyConfig.stringSet(MyConfig.toArray((List)MyConfig.COMMON.includeGroups.get()));
        excludeGroupSet = MyConfig.stringSet(MyConfig.toArray((List)MyConfig.COMMON.excludeGroups.get()));
        itemRarityMap = MyConfig.itemMap(MyConfig.toArray((List)MyConfig.COMMON.itemRarity.get()));
        itemCostMap = MyConfig.costMap(MyConfig.toArray((List)MyConfig.COMMON.itemCost.get()));
        MyConfig.validateMods(includeModSet, "IncludeMods");
        MyConfig.validateMods(excludeModSet, "ExcludeMods");
        MyConfig.fillGroups();
        MyConfig.validateGroups(includeGroupSet, "IncludeGroups");
        MyConfig.validateGroups(excludeGroupSet, "ExcludeGroups");
        if (disableGroups) {
            MyConfig.updateItems();
        }
        if (++loadId > 100) {
            loadId = 0;
        }
    }

    private static void updateItems() {
        ArrayList<String> list = new ArrayList<String>();
        if (excludeGroupSet.contains("op")) {
            list.add("#vm:op");
        }
        if (excludeGroupSet.contains("!")) {
            list.add("#vm:nogroup");
        }
        if (!list.isEmpty()) {
            HashSet<Item> set = MyConfig.itemSet(list.toArray(new String[0]), "ExcludeItems");
            excludeItemSet.addAll(set);
        }
    }

    private static boolean hasAll(String[] values) {
        for (String name : values) {
            if (!name.equals("*")) continue;
            return true;
        }
        return false;
    }

    private static Item getItem(String name) {
        Item ret = Items.f_42616_;
        try {
            ResourceLocation key = new ResourceLocation(name);
            if (ForgeRegistries.ITEMS.containsKey(key)) {
                ret = (Item)ForgeRegistries.ITEMS.getValue(key);
            } else {
                LOGGER.warn("Unknown item: " + name);
            }
        }
        catch (Exception e) {
            LOGGER.warn("Bad item: " + name);
        }
        return ret;
    }

    private static void extractFixed(String[] values) {
        for (int i = 0; i < fixedItems.length; ++i) {
            MyConfig.fixedExtended[i] = false;
            MyConfig.fixedItems[i] = Items.f_41852_;
            MyConfig.fixedTags[i] = null;
            if (i >= values.length) continue;
            try {
                int count;
                StringReader reader = new StringReader(values[i]);
                ItemResult result = MyConfig.parseItemKey(reader);
                ResourceLocation key = result.res;
                if (!ForgeRegistries.ITEMS.containsKey(key)) {
                    LOGGER.warn("Unknown item: " + key.toString());
                    continue;
                }
                MyConfig.fixedItems[i] = (Item)ForgeRegistries.ITEMS.getValue(key);
                MyConfig.fixedTags[i] = result.nbt;
                reader.skipWhitespace();
                int cost = 0;
                for (count = 0; count < 4 && reader.canRead() && reader.peek() == ','; ++count) {
                    reader.skip();
                    reader.skipWhitespace();
                    if (count == 0) {
                        MyConfig.fixedAmount[i] = reader.readInt();
                    } else if (count == 1) {
                        result = MyConfig.parseItemKey(reader);
                        key = result.res;
                        if (ForgeRegistries.ITEMS.containsKey(key)) {
                            Item payItem = (Item)ForgeRegistries.ITEMS.getValue(key);
                            MyConfig.fixedPayment[i] = new ItemStack((ItemLike)payItem);
                            if (result.nbt != null) {
                                fixedPayment[i].m_41784_().m_128391_(result.nbt);
                            }
                        } else {
                            LOGGER.warn("Unknown item: " + key.toString());
                            MyConfig.fixedPayment[i] = null;
                        }
                    } else if (count == 2) {
                        cost = reader.readInt();
                    } else if (count == 3) {
                        MyConfig.fixedUses[i] = reader.readInt();
                    }
                    reader.skipWhitespace();
                }
                if (count == 4 && fixedPayment[i] != null) {
                    fixedPayment[i].m_41764_(cost);
                    MyConfig.fixedExtended[i] = true;
                } else if (count > 0) {
                    LOGGER.warn("Bad number of subfields: " + values[i]);
                }
                if (reader.getRemainingLength() <= 0) continue;
                LOGGER.warn("Ignoring extra data: " + reader.getRemaining());
                continue;
            }
            catch (Exception e) {
                LOGGER.warn("Bad entry: " + values[i]);
                String msg = e.getMessage();
                if (msg == null) continue;
                LOGGER.warn(msg);
            }
        }
    }

    private static ItemResult parseItemKey(StringReader sr) throws CommandSyntaxException {
        CompoundTag nbt = null;
        Object rl = sr.readUnquotedString();
        if (sr.canRead() && sr.peek() == ':') {
            sr.skip();
            rl = (String)rl + ":" + sr.readUnquotedString();
        }
        sr.skipWhitespace();
        if (sr.canRead() && sr.peek() == '{' && (nbt = new TagParser(sr).m_129373_()).m_128456_()) {
            nbt = null;
        }
        return new ItemResult(new ResourceLocation((String)rl), nbt);
    }

    private static HashSet<String> stringSet(String[] values) {
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < values.length; ++i) {
            set.add(values[i].trim());
        }
        return set;
    }

    private static HashSet<Item> itemSet(String[] values, String configName) {
        HashSet<Item> ret = new HashSet<Item>();
        IForgeRegistry reg = ForgeRegistries.ITEMS;
        for (String name : values) {
            boolean remove = false;
            if (name.charAt(0) == '-') {
                remove = true;
                name = name.substring(1);
            }
            if (name.charAt(0) == '#') {
                try {
                    TagKey key = ItemTags.create((ResourceLocation)new ResourceLocation(name.substring(1)));
                    anyTags = true;
                    if (!tagsLoaded) continue;
                    Optional opt = BuiltInRegistries.f_257033_.m_203431_(key);
                    if (opt.isPresent()) {
                        List<Item> list = MyConfig.processTag((HolderSet.Named<Item>)((HolderSet.Named)opt.get()));
                        if (remove) {
                            ret.removeAll(list);
                            continue;
                        }
                        ret.addAll(list);
                        continue;
                    }
                    LOGGER.warn("Unknown tag entry in " + configName + ": " + name);
                }
                catch (Exception e) {
                    LOGGER.warn("Bad tag entry in " + configName + ": " + name);
                }
                continue;
            }
            if (name.endsWith(":*")) {
                MyConfig.expandMod((IForgeRegistry<Item>)reg, ret, name.substring(0, name.length() - 2), configName, remove);
                continue;
            }
            List<String> list = MyConfig.expandItem(name);
            for (String entry : list) {
                try {
                    ResourceLocation key = new ResourceLocation(entry);
                    if (reg.containsKey(key)) {
                        Item item = (Item)reg.getValue(key);
                        if (remove) {
                            ret.remove(item);
                            continue;
                        }
                        ret.add(item);
                        continue;
                    }
                    LOGGER.warn("Unknown entry in " + configName + ": " + entry);
                }
                catch (Exception e) {
                    LOGGER.warn("Bad entry in " + configName + ": " + entry);
                }
            }
        }
        return ret;
    }

    private static HashMap<Item, Rarity> itemMap(String[] values) {
        HashMap<Item, Rarity> ret = new HashMap<Item, Rarity>();
        IForgeRegistry reg = ForgeRegistries.ITEMS;
        for (String name : values) {
            Rarity rarity = Rarity.COMMON;
            int i = name.indexOf(61);
            if (i < 0) {
                LOGGER.warn("Bad entry in ItemRarity: " + name);
                continue;
            }
            String part1 = name.substring(0, i).trim();
            String part2 = name.substring(i + 1).trim();
            if (!part2.isEmpty()) {
                try {
                    int j = Integer.parseInt(part2);
                    if (j == 1) {
                        rarity = Rarity.UNCOMMON;
                    } else if (j == 2) {
                        rarity = Rarity.RARE;
                    } else if (j >= 3) {
                        rarity = Rarity.EPIC;
                    }
                }
                catch (Exception j) {
                    // empty catch block
                }
            }
            if (part1.charAt(0) == '#') {
                try {
                    TagKey key = ItemTags.create((ResourceLocation)new ResourceLocation(part1.substring(1)));
                    anyTags = true;
                    if (!tagsLoaded) continue;
                    Optional opt = BuiltInRegistries.f_257033_.m_203431_(key);
                    if (opt.isPresent()) {
                        for (Item item : MyConfig.processTag((HolderSet.Named<Item>)((HolderSet.Named)opt.get()))) {
                            ret.put(item, rarity);
                        }
                        continue;
                    }
                    LOGGER.warn("Unknown tag entry in ItemRarity: " + part1);
                }
                catch (Exception e) {
                    LOGGER.warn("Bad tag entry in ItemRarity: " + part1);
                }
                continue;
            }
            if (part1.endsWith(":*")) {
                MyConfig.expandMod((IForgeRegistry<Item>)reg, ret, part1.substring(0, part1.length() - 2), rarity);
                continue;
            }
            List<String> list = MyConfig.expandItem(part1);
            for (String entry : list) {
                try {
                    ResourceLocation key = new ResourceLocation(entry);
                    if (reg.containsKey(key)) {
                        Item item = (Item)reg.getValue(key);
                        ret.put(item, rarity);
                        continue;
                    }
                    LOGGER.warn("Unknown entry in ItemRarity: " + entry);
                }
                catch (Exception e) {
                    LOGGER.warn("Bad entry in ItemRarity: " + entry);
                }
            }
        }
        return ret;
    }

    private static HashMap<Rarity, CostData> rarityCostMap() {
        HashMap<Rarity, CostData> ret = new HashMap<Rarity, CostData>();
        ret.put(Rarity.COMMON, MyConfig.makeCost(commonItem, commonCost, commonUses));
        ret.put(Rarity.UNCOMMON, MyConfig.makeCost(uncommonItem, uncommonCost, uncommonUses));
        ret.put(Rarity.RARE, MyConfig.makeCost(rareItem, rareCost, rareUses));
        ret.put(Rarity.EPIC, MyConfig.makeCost(epicItem, epicCost, epicUses));
        return ret;
    }

    private static CostData makeCost(Item item, int count, int uses) {
        ItemStack stack;
        CostData ret = new CostData();
        ret.maxUses = uses;
        ret.costA = stack = new ItemStack((ItemLike)item, count);
        int max = stack.m_41741_();
        if (count > max) {
            stack.m_41764_(max);
            int countB = count - max;
            if (countB > max) {
                countB = max;
            }
            ret.costB = new ItemStack((ItemLike)item, countB);
        }
        return ret;
    }

    private static HashMap<Item, CostData> costMap(String[] values) {
        HashMap<Item, CostData> ret = new HashMap<Item, CostData>();
        IForgeRegistry reg = ForgeRegistries.ITEMS;
        for (String name : values) {
            CostData cost = new CostData();
            int i = name.indexOf(61);
            if (i < 0) {
                LOGGER.warn("Bad entry in ItemCost: " + name);
                continue;
            }
            String part1 = name.substring(0, i).trim();
            String part2 = name.substring(i + 1).trim();
            if (!part2.isEmpty()) {
                try {
                    String[] fs = part2.split(",");
                    int n = fs.length;
                    if (n < 2 || n > 5) {
                        LOGGER.warn("Bad entry in ItemCost (fields): " + name);
                        continue;
                    }
                    cost.costA = MyConfig.parseStack((IForgeRegistry<Item>)reg, fs[0], fs[1]);
                    if (n >= 4) {
                        cost.costB = MyConfig.parseStack((IForgeRegistry<Item>)reg, fs[2], fs[3]);
                    }
                    if (n == 3 || n == 5) {
                        cost.maxUses = Integer.parseInt(fs[n - 1]);
                    }
                }
                catch (Exception e) {
                    LOGGER.warn("Bad entry in ItemCost (fields): " + name);
                }
            } else {
                LOGGER.warn("Bad entry in ItemCost: " + name);
            }
            if (cost.costA == null || cost.costB == null) continue;
            if (part1.charAt(0) == '#') {
                try {
                    TagKey key = ItemTags.create((ResourceLocation)new ResourceLocation(part1.substring(1)));
                    anyTags = true;
                    if (!tagsLoaded) continue;
                    Optional opt = BuiltInRegistries.f_257033_.m_203431_(key);
                    if (opt.isPresent()) {
                        for (Item item : MyConfig.processTag((HolderSet.Named<Item>)((HolderSet.Named)opt.get()))) {
                            ret.put(item, cost);
                        }
                        continue;
                    }
                    LOGGER.warn("Unknown tag entry in ItemCost: " + part1);
                }
                catch (Exception e) {
                    LOGGER.warn("Bad tag entry in ItemCost: " + part1);
                }
                continue;
            }
            if (part1.endsWith(":*")) {
                MyConfig.expandMod((IForgeRegistry<Item>)reg, ret, part1.substring(0, part1.length() - 2), cost);
                continue;
            }
            List<String> list = MyConfig.expandItem(part1);
            for (String entry : list) {
                try {
                    ResourceLocation key = new ResourceLocation(entry);
                    if (reg.containsKey(key)) {
                        Item item = (Item)reg.getValue(key);
                        ret.put(item, cost);
                        continue;
                    }
                    LOGGER.warn("Unknown entry in ItemCost: " + entry);
                }
                catch (Exception e) {
                    LOGGER.warn("Bad entry in ItemCost: " + entry);
                }
            }
        }
        return ret;
    }

    private static ItemStack parseStack(IForgeRegistry<Item> reg, String r, String c) {
        Item item = null;
        int count = 0;
        try {
            ResourceLocation key = new ResourceLocation(r);
            if (reg.containsKey(key)) {
                item = (Item)reg.getValue(key);
                count = Integer.parseInt(c);
            } else {
                LOGGER.warn("Unknown entry in ItemCost: " + r);
            }
        }
        catch (Exception e) {
            LOGGER.warn("Bad entry in ItemCost: " + r);
        }
        if (item == null || count <= 0) {
            return null;
        }
        ItemStack stack = new ItemStack((ItemLike)item, count);
        int max = stack.m_41741_();
        if (count > max) {
            stack.m_41764_(max);
            LOGGER.warn("Bad entry (count) in ItemCost: " + r);
        }
        return stack;
    }

    private static List<Item> processTag(HolderSet.Named<Item> named) {
        ArrayList<Item> ret = new ArrayList<Item>();
        for (Holder o : named) {
            ret.add((Item)o.m_203334_());
        }
        return ret;
    }

    private static String[] toArray(List<? extends String> value) {
        return MyConfig.isEmpty(value) ? new String[]{} : value.toArray(new String[value.size()]);
    }

    private static boolean isEmpty(List<? extends String> value) {
        return value.isEmpty() || value.size() == 1 && value.get(0).isEmpty();
    }

    private static void validateMods(HashSet<String> set, String configName) {
        ModList list = ModList.get();
        set.removeIf(name -> {
            if (name.equals("*")) {
                return false;
            }
            if (list.isLoaded(name)) {
                return false;
            }
            LOGGER.warn("Unknown entry in " + configName + ": " + name);
            return true;
        });
    }

    private static void validateGroups(HashSet<String> set, String configName) {
        HashSet<String> groups = new HashSet<String>();
        for (CreativeModeTab g : CreativeModeTabs.m_257478_()) {
            if (g.m_257962_() != CreativeModeTab.Type.CATEGORY) continue;
            groups.add(groupName.get(g));
        }
        groups.add("*");
        groups.add("!");
        set.removeIf(name -> {
            if (groups.contains(name)) {
                return false;
            }
            LOGGER.warn("Unknown entry in " + configName + ": " + name);
            return true;
        });
    }

    private static void fillGroups() {
        for (CreativeModeTab g : CreativeModeTabs.m_257478_()) {
            if (g.m_257962_() != CreativeModeTab.Type.CATEGORY) continue;
            String name = "?";
            ComponentContents c = g.m_40786_().m_214077_();
            if (c instanceof TranslatableContents) {
                TranslatableContents tc = (TranslatableContents)c;
                name = tc.m_237508_();
                if (name.startsWith("itemGroup.")) {
                    name = name.substring(10);
                }
            } else if (c instanceof LiteralContents) {
                LiteralContents lc = (LiteralContents)c;
                name = lc.f_237368_().replaceAll(" ", "");
            }
            groupName.put(g, name);
        }
    }

    private static List<String> expandItem(String name) {
        ArrayList<String> ret;
        block12: {
            block10: {
                String temp;
                String ns;
                block13: {
                    block11: {
                        ret = new ArrayList<String>();
                        ret.add(name);
                        int i = name.indexOf(58);
                        if (i < 0 || name.indexOf(42) <= 0) break block10;
                        ns = name.substring(0, i + 1);
                        temp = name.substring(i + 1);
                        if (!temp.startsWith("toolset*")) break block11;
                        String type = temp.substring(8);
                        ret.clear();
                        ret.add(ns + type + "_sword");
                        ret.add(ns + type + "_shovel");
                        ret.add(ns + type + "_pickaxe");
                        ret.add(ns + type + "_axe");
                        ret.add(ns + type + "_hoe");
                        break block12;
                    }
                    if (!temp.startsWith("armorset*")) break block13;
                    String type = temp.substring(9);
                    ret.clear();
                    ret.add(ns + type + "_helmet");
                    ret.add(ns + type + "_chestplate");
                    ret.add(ns + type + "_leggings");
                    ret.add(ns + type + "_boots");
                    break block12;
                }
                if (!temp.startsWith("colorset*")) break block12;
                String type = temp.substring(9);
                ret.clear();
                for (DyeColor dye : DyeColor.values()) {
                    ret.add(ns + dye.toString() + "_" + type);
                }
                break block12;
            }
            if (name.startsWith("eggset*")) {
                IForgeRegistry reg = ForgeRegistries.ITEMS;
                List<SpawnEggItem> allEggs = MyConfig.getAllEggs();
                String mode = name.substring(7);
                if (mode.equals("all")) {
                    ret.clear();
                    for (SpawnEggItem e : allEggs) {
                        ResourceLocation res = reg.getKey((Object)e);
                        ret.add(res.toString());
                    }
                } else if (mode.equals("monster")) {
                    ret.clear();
                    for (SpawnEggItem e : allEggs) {
                        EntityType type = e.m_43228_(null);
                        if (type.m_20674_().m_21609_()) continue;
                        ResourceLocation res = reg.getKey((Object)e);
                        ret.add(res.toString());
                    }
                } else if (mode.equals("peaceful")) {
                    ret.clear();
                    for (SpawnEggItem e : allEggs) {
                        EntityType type = e.m_43228_(null);
                        if (!type.m_20674_().m_21609_()) continue;
                        ResourceLocation res = reg.getKey((Object)e);
                        ret.add(res.toString());
                    }
                }
            }
        }
        return ret;
    }

    private static void expandMod(IForgeRegistry<Item> reg, HashSet<Item> set, String name, String configName, boolean remove) {
        if (!ModList.get().isLoaded(name)) {
            LOGGER.warn("Unknown mod entry in " + configName + ": " + name);
            return;
        }
        if (remove) {
            set.removeIf(item -> name.equals(reg.getKey(item).m_135827_()));
        } else {
            for (Map.Entry entry : reg.getEntries()) {
                if (!name.equals(((ResourceKey)entry.getKey()).m_135782_().m_135827_())) continue;
                Item item2 = (Item)entry.getValue();
                set.add(item2);
            }
        }
    }

    private static void expandMod(IForgeRegistry<Item> reg, HashMap<Item, Rarity> map, String name, Rarity newRarity) {
        if (!ModList.get().isLoaded(name)) {
            LOGGER.warn("Unknown mod entry in ItemRarity: " + name);
            return;
        }
        for (Map.Entry entry : reg.getEntries()) {
            if (!name.equals(((ResourceKey)entry.getKey()).m_135782_().m_135827_())) continue;
            Item item = (Item)entry.getValue();
            Rarity rarity = map.get(item);
            if (rarity == null) {
                rarity = item.m_41460_(new ItemStack((ItemLike)item));
            }
            if (rarity == newRarity) continue;
            map.put(item, newRarity);
        }
    }

    private static void expandMod(IForgeRegistry<Item> reg, HashMap<Item, CostData> map, String name, CostData newCost) {
        if (!ModList.get().isLoaded(name)) {
            LOGGER.warn("Unknown mod entry in ItemCost: " + name);
            return;
        }
        for (Map.Entry entry : reg.getEntries()) {
            if (!name.equals(((ResourceKey)entry.getKey()).m_135782_().m_135827_())) continue;
            Item item = (Item)entry.getValue();
            map.put(item, newCost);
        }
    }

    private static List<SpawnEggItem> getAllEggs() {
        ArrayList<SpawnEggItem> ret = new ArrayList<SpawnEggItem>();
        SpawnEggItem.m_43233_().forEach(ret::add);
        try {
            Field f = ForgeSpawnEggItem.class.getDeclaredField("MOD_EGGS");
            f.setAccessible(true);
            Object o = f.get(null);
            if (o != null) {
                ret.addAll((List)o);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
        loadId = 0;
        disableGroups = false;
        tagsLoaded = false;
        anyTags = false;
        fixedExtended = new boolean[7];
        fixedItems = new Item[7];
        fixedTags = new CompoundTag[7];
        fixedAmount = new int[7];
        fixedUses = new int[7];
        fixedPayment = new ItemStack[7];
        groupName = new HashMap();
    }

    public static class Common {
        public final ForgeConfigSpec.BooleanValue restock;
        public final ForgeConfigSpec.BooleanValue fixed;
        public final ForgeConfigSpec.BooleanValue minable;
        public final ForgeConfigSpec.BooleanValue villages;
        public final ForgeConfigSpec.ConfigValue<String> commonItem;
        public final ForgeConfigSpec.ConfigValue<String> uncommonItem;
        public final ForgeConfigSpec.ConfigValue<String> rareItem;
        public final ForgeConfigSpec.ConfigValue<String> epicItem;
        public final ForgeConfigSpec.IntValue commonCost;
        public final ForgeConfigSpec.IntValue uncommonCost;
        public final ForgeConfigSpec.IntValue rareCost;
        public final ForgeConfigSpec.IntValue epicCost;
        public final ForgeConfigSpec.IntValue commonUses;
        public final ForgeConfigSpec.IntValue uncommonUses;
        public final ForgeConfigSpec.IntValue rareUses;
        public final ForgeConfigSpec.IntValue epicUses;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> fixedItems;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> includeMods;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> excludeMods;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> includeItems;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> excludeItems;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> addItems;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> includeGroups;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> excludeGroups;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> itemRarity;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> itemCost;

        public Common(ForgeConfigSpec.Builder builder) {
            List<String> fixedItemsList = Arrays.asList("minecraft:air", "minecraft:air", "minecraft:air", "minecraft:air", "minecraft:air", "minecraft:air", "minecraft:air");
            List<String> includeModsList = Arrays.asList("*");
            List<String> excludeModsList = Arrays.asList("draconicevolution", "avaritia", "botania");
            List<String> includeItemsList = Arrays.asList("*");
            List<String> excludeItemsList = Arrays.asList("minecraft:nether_star", "minecraft:beacon", "minecraft:bedrock", "minecraft:shulker_box", "minecraft:colorset*shulker_box", "minecraft:elytra", "minecraft:end_portal_frame", "minecraft:armorset*netherite", "minecraft:toolset*netherite", "minecraft:netherite_block", "minecraft:netherite_ingot", "minecraft:spawner", "minecraft:netherite_upgrade_smithing_template", "#minecraft:trim_templates", "-minecraft:coast_armor_trim_smithing_template", "vm:vending_machine");
            List<String> addItemsList = Arrays.asList("");
            List<String> includeGroupsList = Arrays.asList("*");
            List<String> excludeGroupsList = Arrays.asList("!", "op");
            List<String> itemRarityList = Arrays.asList("minecraft:emerald_block=1", "minecraft:diamond_block=1", "minecraft:armorset*diamond=1", "minecraft:toolset*diamond=1", "minecraft:anvil=2", "minecraft:trident=3", "minecraft:bell=2", "minecraft:conduit=3", "minecraft:nautilus_shell=1", "eggset*peaceful=1", "eggset*monster=2", "minecraft:evoker_spawn_egg=3", "minecraft:warden_spawn_egg=3", "minecraft:netherite_scrap=2", "minecraft:ancient_debris=2", "minecraft:axolotl_bucket=1", "minecraft:echo_shard=3", "minecraft:lodestone=3", "minecraft:respawn_anchor=1", "minecraft:coast_armor_trim_smithing_template=3", "#minecraft:decorated_pot_sherds=1", "minecraft:arms_up_pottery_sherd=0");
            List<String> itemCostList = Arrays.asList("");
            String baseTrans = "vm.config.";
            String sectionTrans = baseTrans + "general.";
            this.restock = builder.comment("Restock").translation(sectionTrans + "restock").define("Restock", true);
            this.fixed = builder.comment("Use fixed items").translation(sectionTrans + "use_fixed").define("UseFixedItems", false);
            this.minable = builder.comment("Minable").translation(sectionTrans + "minable").define("Minable", false);
            this.villages = builder.comment("Add structure to Villages").translation(sectionTrans + "villages").define("Villages", true);
            this.fixedItems = builder.comment("Fixed items; item or item,amount,pay_item,cost,uses").translation(sectionTrans + "fixed_items").defineList("FixedItems", fixedItemsList, Common::isString);
            this.includeMods = builder.comment("Include Mods").translation(sectionTrans + "include_mods").defineList("IncludeMods", includeModsList, Common::isString);
            this.excludeMods = builder.comment("Exclude Mods").translation(sectionTrans + "exclude_mods").defineList("ExcludeMods", excludeModsList, Common::isString);
            this.includeItems = builder.comment("Include Items").translation(sectionTrans + "include_items").defineList("IncludeItems", includeItemsList, Common::isString);
            this.excludeItems = builder.comment("Exclude Items").translation(sectionTrans + "exclude_items").defineList("ExcludeItems", excludeItemsList, Common::isString);
            this.addItems = builder.comment("Add Items").translation(sectionTrans + "add_items").defineList("AddItems", addItemsList, Common::isString);
            this.includeGroups = builder.comment("Include Creative Tab Groups").translation(sectionTrans + "include_groups").defineList("IncludeGroups", includeGroupsList, Common::isString);
            this.excludeGroups = builder.comment("Exclude Creative Tab Groups").translation(sectionTrans + "exclude_groups").defineList("ExcludeGroups", excludeGroupsList, Common::isString);
            this.itemRarity = builder.comment("Change item rarity value for pricing").translation(sectionTrans + "item_rarity").defineList("ItemRarity", itemRarityList, Common::isString);
            this.itemCost = builder.comment("Custom item pricing").translation(sectionTrans + "item_cost").defineList("ItemCost", itemCostList, Common::isString);
            builder.push("RarityData");
            sectionTrans = baseTrans + ".rarity.";
            this.commonItem = builder.comment("Common Item").translation(sectionTrans + "common_item").define("CommonItem", (Object)"minecraft:emerald");
            this.uncommonItem = builder.comment("Uncommon Item").translation(sectionTrans + "uncommon_item").define("UncommonItem", (Object)"minecraft:emerald");
            this.rareItem = builder.comment("Rare Item").translation(sectionTrans + "rare_item").define("RareItem", (Object)"minecraft:emerald");
            this.epicItem = builder.comment("Epic Item").translation(sectionTrans + "epic_item").define("EpicItem", (Object)"minecraft:emerald");
            this.commonCost = builder.comment("Common Cost").translation(sectionTrans + "common_cost").defineInRange("CommonCost", 1, 0, 128);
            this.uncommonCost = builder.comment("Uncommon Cost").translation(sectionTrans + "uncommon_cost").defineInRange("UncommonCost", 16, 0, 128);
            this.rareCost = builder.comment("Rare Cost").translation(sectionTrans + "rare_cost").defineInRange("RareCost", 32, 0, 128);
            this.epicCost = builder.comment("Epic Cost").translation(sectionTrans + "epic_cost").defineInRange("EpicCost", 64, 0, 128);
            this.commonUses = builder.comment("Common Uses").translation(sectionTrans + "common_uses").defineInRange("CommonUses", 8, 0, 32);
            this.uncommonUses = builder.comment("Uncommon Uses").translation(sectionTrans + "uncommon_uses").defineInRange("UncommonUses", 4, 0, 32);
            this.rareUses = builder.comment("Rare Uses").translation(sectionTrans + "rare_uses").defineInRange("RareUses", 2, 0, 32);
            this.epicUses = builder.comment("Epic Uses").translation(sectionTrans + "epic_uses").defineInRange("EpicUses", 1, 0, 32);
            builder.pop();
        }

        public static boolean isString(Object o) {
            return o instanceof String;
        }
    }

    private static class ItemResult {
        public final ResourceLocation res;
        public final CompoundTag nbt;

        public ItemResult(ResourceLocation res, @Nullable CompoundTag nbt) {
            this.res = res;
            this.nbt = nbt;
        }
    }

    public static class CostData {
        public ItemStack costA = null;
        public ItemStack costB = ItemStack.f_41583_;
        public int maxUses = 0;
    }
}

