/*
 * Decompiled with CFR 0.152.
 */
package com.lupicus.vm.datafix;

import com.lupicus.vm.datafix.RotationFix;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.DataFixerBuilder;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectSortedMap;
import java.lang.reflect.Field;
import net.minecraft.util.datafix.schemas.NamespacedSchema;
import org.slf4j.Logger;

public class ModFixers {
    private static Logger LOGGER = LogUtils.getLogger();

    public static void apply(DataFixerBuilder builder) {
        Int2ObjectSortedMap schemas = null;
        try {
            Field fld = builder.getClass().getDeclaredField("schemas");
            fld.setAccessible(true);
            schemas = (Int2ObjectSortedMap)fld.get(builder);
        }
        catch (Exception fld) {
            // empty catch block
        }
        if (schemas == null || schemas.size() == 0) {
            LOGGER.error("failed to install mod datafixers");
            return;
        }
        int version = 2730;
        int key = DataFixUtils.makeKey((int)version);
        Schema s = (Schema)schemas.get(key);
        if (s == null) {
            s = builder.addSchema(version, NamespacedSchema::new);
        }
        builder.addFixer((DataFix)new RotationFix(s, false));
    }
}

