/*
 * Decompiled with CFR 0.152.
 */
package com.lupicus.vm.tileentity;

import com.lupicus.vm.block.ModBlocks;
import com.lupicus.vm.block.VendingMachine;
import com.lupicus.vm.config.MyConfig;
import com.lupicus.vm.sound.ModSounds;
import com.lupicus.vm.tileentity.ModTileEntities;
import com.lupicus.vm.tileentity.MultiItems;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.GameMasterBlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemStackLinkedSet;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.trading.Merchant;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

public class VendingMachineTileEntity
extends BlockEntity
implements Merchant,
Nameable {
    final boolean enabled;
    MerchantOffers offers = null;
    Player customer = null;
    boolean fixed = MyConfig.fixed;
    long stockTime = 0L;
    Component customName = null;
    private static final long DAY = 24000L;
    private static final int ITEM_COUNT = 7;
    private static final int RETRIES = 8;
    private static int initId = -1;
    private static Item[] inputItems;
    private static Map<Item, Set<ItemStack>> groupMultiItems;
    private static Map<Item, Set<ItemStack>> allMultiItems;

    public VendingMachineTileEntity(BlockPos pos, BlockState state) {
        super(ModTileEntities.VENDING_MACHINE, pos, state);
        this.enabled = VendingMachine.isEnabled(state);
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        if (!this.enabled) {
            return;
        }
        this.stockTime = compound.m_128454_("stockTime");
        this.fixed = compound.m_128471_("fixed");
        this.offers = new MerchantOffers(compound);
        if (this.offers.isEmpty()) {
            this.offers = null;
        }
        if (compound.m_128425_("CustomName", 8)) {
            this.customName = Component.Serializer.m_130701_((String)compound.m_128461_("CustomName"));
        }
    }

    protected void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        if (!this.enabled) {
            return;
        }
        compound.m_128356_("stockTime", this.stockTime);
        compound.m_128379_("fixed", this.fixed);
        if (this.offers != null) {
            compound.m_128391_(this.offers.m_45388_());
        }
        if (this.customName != null) {
            compound.m_128359_("CustomName", Component.Serializer.m_130703_((Component)this.customName));
        }
    }

    public void readMined(CompoundTag compound) {
        if (compound.m_128441_("mined")) {
            this.stockTime = this.f_58857_.m_46468_();
            this.stockTime -= Math.abs(this.stockTime % 24000L);
            this.fixed = compound.m_128471_("fixed");
            this.offers = new MerchantOffers(compound);
            if (this.offers.isEmpty()) {
                this.offers = null;
            }
        }
    }

    public void writeMined(CompoundTag compound) {
        compound.m_128379_("mined", true);
        compound.m_128379_("fixed", this.fixed);
        if (this.offers != null) {
            compound.m_128391_(this.offers.m_45388_());
        }
    }

    public void m_7189_(Player player) {
        this.customer = player;
    }

    public Player m_7962_() {
        return this.customer;
    }

    public MerchantOffers m_6616_() {
        if (MyConfig.restock) {
            long time = this.f_58857_.m_46468_();
            if (time < this.stockTime) {
                this.stockTime = time;
                this.stockTime -= Math.abs(this.stockTime % 24000L);
            }
            if (time - this.stockTime >= 24000L) {
                this.stockTime = time;
                this.stockTime -= Math.abs(this.stockTime % 24000L);
                if (this.fixed) {
                    this.restock();
                } else {
                    this.offers = null;
                }
            }
        }
        if (this.offers == null) {
            this.initData();
            if (this.fixed) {
                this.configOffers();
            } else {
                this.fillOffers();
            }
            this.m_6596_();
        }
        return this.offers;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_6255_(MerchantOffers offers) {
        this.offers = offers;
    }

    public void m_6996_(MerchantOffer offer) {
        offer.m_45374_();
        this.f_58857_.m_5594_((Player)null, this.f_58858_, ModSounds.VENDING_MACHINE_TAKE_RESULT, SoundSource.BLOCKS, 1.0f, 1.0f);
        this.m_6596_();
    }

    public void m_7713_(ItemStack stack) {
    }

    public int m_7809_() {
        return 0;
    }

    public void m_6621_(int xpIn) {
    }

    public boolean m_7826_() {
        return false;
    }

    public SoundEvent m_7596_() {
        return SoundEvents.f_12509_;
    }

    public boolean m_183595_() {
        return this.f_58857_.f_46443_;
    }

    public void setCustomName(Component name) {
        this.customName = name;
    }

    public Component m_7770_() {
        return this.customName;
    }

    public Component m_7755_() {
        return this.customName != null ? this.customName : Component.m_237115_((String)ModBlocks.VENDING_MACHINE.m_7705_());
    }

    public void openGui(Player player) {
        this.m_7189_(player);
        this.m_45301_(player, this.m_7755_(), 5);
    }

    private void fillOffers() {
        int tryCount = 0;
        this.offers = new MerchantOffers();
        Item[] values = inputItems;
        NonNullList items = NonNullList.m_122779_();
        int i = 0;
        while (i < 7) {
            int maxUses;
            MyConfig.CostData cost;
            ++tryCount;
            int j = this.f_58857_.f_46441_.m_188503_(values.length);
            Item item = values[j];
            items.clear();
            this.fillItems(groupMultiItems, item, (NonNullList<ItemStack>)items);
            ItemStack stack = !items.isEmpty() ? (ItemStack)items.get(this.f_58857_.f_46441_.m_188503_(items.size())) : new ItemStack((ItemLike)item);
            Rarity rarity = MyConfig.itemRarityMap.get(item);
            if (rarity == null) {
                rarity = item.m_41460_(stack);
            }
            if ((cost = MyConfig.itemCostMap.get(item)) != null) {
                maxUses = cost.maxUses > 0 ? cost.maxUses : this.itemUses(rarity);
            } else {
                cost = this.itemPayment(rarity);
                maxUses = cost.maxUses;
            }
            if (cost.costA.m_41619_() || this.invalidItem(item)) {
                if (tryCount < 8) continue;
                stack.m_41764_(0);
                cost = this.itemPayment(this.defRarity());
                maxUses = 1;
            }
            MerchantOffer offer = new MerchantOffer(cost.costA, cost.costB, stack, maxUses, 0, 0.0f);
            this.offers.add((Object)offer);
            tryCount = 0;
            ++i;
        }
    }

    private void configOffers() {
        this.offers = new MerchantOffers();
        NonNullList items = NonNullList.m_122779_();
        for (int i = 0; i < 7; ++i) {
            int maxUses;
            MyConfig.CostData cost;
            Item item = MyConfig.fixedItems[i];
            items.clear();
            this.fillItems(allMultiItems, item, (NonNullList<ItemStack>)items);
            ItemStack stack = !items.isEmpty() ? (ItemStack)items.get(this.f_58857_.f_46441_.m_188503_(items.size())) : new ItemStack((ItemLike)item);
            if (MyConfig.fixedTags[i] != null) {
                stack.m_41784_().m_128391_(MyConfig.fixedTags[i]);
            }
            if (MyConfig.fixedExtended[i]) {
                stack.m_41769_(MyConfig.fixedAmount[i] - 1);
                cost = new MyConfig.CostData();
                cost.costA = MyConfig.fixedPayment[i];
                maxUses = MyConfig.fixedUses[i];
            } else {
                Rarity rarity = MyConfig.itemRarityMap.get(item);
                if (rarity == null) {
                    rarity = item.m_41460_(stack);
                }
                if ((cost = MyConfig.itemCostMap.get(item)) != null) {
                    maxUses = cost.maxUses > 0 ? cost.maxUses : this.itemUses(rarity);
                } else {
                    cost = this.itemPayment(rarity);
                    maxUses = cost.maxUses;
                }
                if (cost.costA.m_41619_()) {
                    cost = this.itemPayment(Rarity.EPIC);
                    maxUses = cost.maxUses;
                }
            }
            MerchantOffer offer = new MerchantOffer(cost.costA, cost.costB, stack, maxUses, 0, 0.0f);
            this.offers.add((Object)offer);
        }
    }

    private void restock() {
        if (this.offers == null) {
            return;
        }
        for (MerchantOffer offer : this.offers) {
            offer.m_45372_();
        }
        this.m_6596_();
    }

    private void initData() {
        if (initId == MyConfig.loadId) {
            return;
        }
        initId = MyConfig.loadId;
        if (!MyConfig.disableGroups) {
            try {
                CreativeModeTabs.m_269226_((FeatureFlagSet)this.f_58857_.m_246046_(), (boolean)true, (HolderLookup.Provider)this.f_58857_.m_9598_());
            }
            catch (Throwable t) {
                MyConfig.setDisableGroups(t);
            }
        }
        HashSet<Item> work = new HashSet<Item>();
        if (MyConfig.disableGroups) {
            this.fillMultiItems();
            this.buildItemList(work);
        } else {
            this.findMultiItems();
            HashSet<Item> tempItems = new HashSet<Item>();
            this.buildGroupList(tempItems);
            if (MyConfig.includeAllItems) {
                work = tempItems;
            } else {
                work.addAll(MyConfig.includeItemSet);
                work.retainAll(tempItems);
            }
        }
        if (!MyConfig.includeModSet.contains("*") || !MyConfig.excludeModSet.isEmpty()) {
            this.filterMods(work);
        }
        this.addItemList(work, MyConfig.addItemSet);
        this.filterCost(work);
        if (work.isEmpty()) {
            work.add(Items.f_41852_);
        }
        inputItems = work.toArray(new Item[0]);
    }

    public static void clearData() {
        if (initId >= 0) {
            if (MyConfig.disableGroups) {
                MyConfig.disableGroups = false;
            } else {
                CreativeModeTabs.m_269226_((FeatureFlagSet)FeatureFlagSet.m_246902_(), (boolean)false, (HolderLookup.Provider)RegistryAccess.f_243945_);
            }
        }
        initId = -1;
        inputItems = null;
        groupMultiItems.clear();
        allMultiItems.clear();
    }

    private void buildGroupList(Collection<Item> set) {
        HashSet<String> includeSet = MyConfig.includeGroupSet;
        HashSet<String> excludeSet = MyConfig.excludeGroupSet;
        if (includeSet.contains("*")) {
            for (Map.Entry<CreativeModeTab, String> e : MyConfig.groupName.entrySet()) {
                if (excludeSet.contains(e.getValue())) continue;
                this.addItems(set, e.getKey().m_261235_());
            }
            if (!excludeSet.contains("!")) {
                this.addNoGroupItems(set);
            }
        } else {
            HashSet<String> workSet = new HashSet<String>(includeSet);
            workSet.removeAll(excludeSet);
            for (Map.Entry<CreativeModeTab, String> e : MyConfig.groupName.entrySet()) {
                if (!workSet.contains(e.getValue())) continue;
                this.addItems(set, e.getKey().m_261235_());
            }
            if (workSet.contains("!")) {
                this.addNoGroupItems(set);
            }
        }
    }

    private void addItems(Collection<Item> set, Collection<ItemStack> stacks) {
        for (ItemStack stack : stacks) {
            set.add(stack.m_41720_());
        }
    }

    private void addNoGroupItems(Collection<Item> set) {
        HashSet<Item> groupItems = new HashSet<Item>();
        for (CreativeModeTab g : MyConfig.groupName.keySet()) {
            this.addItems(groupItems, g.m_261235_());
        }
        for (Item item : ForgeRegistries.ITEMS.getValues()) {
            if (groupItems.contains(item) || !item.m_245993_(this.f_58857_.m_246046_())) continue;
            set.add(item);
        }
    }

    private void findMultiItems() {
        HashSet<ItemStack> work = new HashSet<ItemStack>();
        HashSet<String> includeSet = MyConfig.includeGroupSet;
        HashSet<String> excludeSet = MyConfig.excludeGroupSet;
        boolean addAll = includeSet.contains("*");
        groupMultiItems.clear();
        allMultiItems.clear();
        for (Map.Entry<CreativeModeTab, String> entry : MyConfig.groupName.entrySet()) {
            Map<Item, Set<ItemStack>> multiItems = groupMultiItems;
            String name = entry.getValue();
            if (!addAll && !includeSet.contains(name) || excludeSet.contains(name)) {
                multiItems = allMultiItems;
            }
            CreativeModeTab g = entry.getKey();
            boolean dups = false;
            Item lastItem = null;
            ItemStack lastStack = null;
            for (ItemStack s : g.m_261235_()) {
                Item item = s.m_41720_();
                if (item == lastItem) {
                    if (!dups) {
                        dups = true;
                        work.add(lastStack);
                    }
                    work.add(s);
                } else {
                    if (dups) {
                        this.processItem(multiItems, lastItem, work);
                        work.clear();
                        dups = false;
                    }
                    lastItem = item;
                }
                lastStack = s;
            }
            if (!dups) continue;
            this.processItem(multiItems, lastItem, work);
            work.clear();
        }
        groupMultiItems.remove(Items.f_42487_);
        allMultiItems.remove(Items.f_42487_);
        for (Map.Entry<Object, Object> entry : groupMultiItems.entrySet()) {
            this.processItem(allMultiItems, (Item)entry.getKey(), (Set)entry.getValue());
        }
    }

    private void processItem(Map<Item, Set<ItemStack>> multiItems, Item item, Set<ItemStack> work) {
        Set<ItemStack> work2 = multiItems.get(item);
        if (work2 != null) {
            Set temp = ItemStackLinkedSet.m_261170_();
            temp.addAll(work2);
            temp.addAll(work);
            if (temp.size() != work2.size()) {
                work2.clear();
                work2.addAll(temp);
            }
        } else {
            multiItems.put(item, new HashSet<ItemStack>(work));
        }
    }

    private void buildItemList(Collection<Item> set) {
        Collection<Object> items = MyConfig.includeAllItems ? ForgeRegistries.ITEMS.getValues() : MyConfig.includeItemSet;
        FeatureFlagSet featureFlagSet = this.f_58857_.m_246046_();
        for (Item item : items) {
            if (!item.m_245993_(featureFlagSet)) continue;
            set.add(item);
        }
    }

    private void addItemList(Collection<Item> set, Collection<Item> items) {
        FeatureFlagSet featureFlagSet = this.f_58857_.m_246046_();
        for (Item item : items) {
            if (!item.m_245993_(featureFlagSet)) continue;
            set.add(item);
        }
    }

    private void fillMultiItems() {
        groupMultiItems.clear();
        allMultiItems.clear();
        MultiItems.generate(groupMultiItems);
        allMultiItems.putAll(groupMultiItems);
    }

    private void fillItems(Map<Item, Set<ItemStack>> multiItems, Item item, NonNullList<ItemStack> items) {
        Set<ItemStack> v = multiItems.get(item);
        if (v != null) {
            items.addAll(v);
        }
    }

    private void filterMods(Collection<Item> set) {
        HashSet<String> includeSet = MyConfig.includeModSet;
        HashSet<String> excludeSet = MyConfig.excludeModSet;
        boolean addAll = includeSet.contains("*");
        set.removeIf(item -> {
            String name = ForgeRegistries.ITEMS.getKey(item).m_135827_();
            return !addAll && !includeSet.contains(name) || excludeSet.contains(name);
        });
    }

    private void filterCost(Collection<Item> set) {
        ItemStack stack = new ItemStack((ItemLike)Items.f_41852_);
        HashMap<Item, Rarity> map = MyConfig.itemRarityMap;
        HashMap<Item, MyConfig.CostData> map2 = MyConfig.itemCostMap;
        if (MyConfig.commonCost == 0) {
            set.removeIf(item -> {
                Rarity rarity = (Rarity)map.get(item);
                if (rarity == null) {
                    rarity = item.m_41460_(stack);
                }
                return rarity == Rarity.COMMON && !map2.containsKey(item);
            });
        }
        if (MyConfig.uncommonCost == 0) {
            set.removeIf(item -> {
                Rarity rarity = (Rarity)map.get(item);
                if (rarity == null) {
                    rarity = item.m_41460_(stack);
                }
                return rarity == Rarity.UNCOMMON && !map2.containsKey(item);
            });
        }
        if (MyConfig.rareCost == 0) {
            set.removeIf(item -> {
                Rarity rarity = (Rarity)map.get(item);
                if (rarity == null) {
                    rarity = item.m_41460_(stack);
                }
                return rarity == Rarity.RARE && !map2.containsKey(item);
            });
        }
        if (MyConfig.epicCost == 0) {
            set.removeIf(item -> {
                Rarity rarity = (Rarity)map.get(item);
                if (rarity == null) {
                    rarity = item.m_41460_(stack);
                }
                return rarity == Rarity.EPIC && !map2.containsKey(item);
            });
        }
    }

    private boolean invalidItem(Item item) {
        if (MyConfig.addItemSet.contains(item)) {
            return false;
        }
        if (item instanceof GameMasterBlockItem) {
            return true;
        }
        String modName = ForgeRegistries.ITEMS.getKey((Object)item).m_135827_();
        if (!MyConfig.includeModSet.contains("*") && !MyConfig.includeModSet.contains(modName)) {
            return true;
        }
        if (MyConfig.excludeModSet.contains(modName)) {
            return true;
        }
        if (!MyConfig.includeAllItems && !MyConfig.includeItemSet.contains(item)) {
            return true;
        }
        return MyConfig.excludeItemSet.contains(item);
    }

    private Rarity defRarity() {
        if (MyConfig.commonCost > 0) {
            return Rarity.COMMON;
        }
        if (MyConfig.uncommonCost > 0) {
            return Rarity.UNCOMMON;
        }
        if (MyConfig.rareCost > 0) {
            return Rarity.RARE;
        }
        return Rarity.EPIC;
    }

    private MyConfig.CostData itemPayment(Rarity type) {
        MyConfig.CostData cost = MyConfig.rarityCostMap.get(type);
        if (cost == null) {
            cost = new MyConfig.CostData();
            cost.costA = ItemStack.f_41583_;
        }
        return cost;
    }

    private int itemUses(Rarity type) {
        MyConfig.CostData cost = MyConfig.rarityCostMap.get(type);
        return cost != null ? cost.maxUses : 0;
    }

    static {
        groupMultiItems = new HashMap<Item, Set<ItemStack>>();
        allMultiItems = new HashMap<Item, Set<ItemStack>>();
    }
}

