/*
 * Decompiled with CFR 0.152.
 */
package th.tamkungz.letyourfriendeating;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import th.tamkungz.letyourfriendeating.command.FeedFriendCommand;
import th.tamkungz.letyourfriendeating.config.FeedFriendSettings;
import th.tamkungz.letyourfriendeating.config.ServerConfig;
import th.tamkungz.letyourfriendeating.handler.FriendFeeder;

@Mod(value="letyourfriendeating")
public class LetYourFriendEatingMod {
    public static final String MOD_ID = "letyourfriendeating";
    private static final Logger LOGGER = LogManager.getLogger(LetYourFriendEatingMod.class);
    public static final Map<UUID, Long> feedCooldowns = new HashMap<UUID, Long>();

    public LetYourFriendEatingMod() {
        ServerConfig.register();
        FeedFriendSettings.load();
        if (FeedFriendSettings.getGlobalFeedCooldown() == 600 && !((Integer)ServerConfig.FEED_COOLDOWN.get()).equals(600)) {
            FeedFriendSettings.setGlobalFeedCooldown((Integer)ServerConfig.FEED_COOLDOWN.get());
        }
        if (FeedFriendSettings.isFeedFriendEnabled() && !((Boolean)ServerConfig.FEED_FRIEND_ENABLED.get()).booleanValue()) {
            FeedFriendSettings.setFeedFriendEnabled(false);
        }
        MinecraftForge.EVENT_BUS.addListener(this::onEntityInteract);
        MinecraftForge.EVENT_BUS.addListener(this::onRegisterCommands);
        LOGGER.info("[{}] Mod initialized successfully.", (Object)MOD_ID);
    }

    public static void setFeedCooldownGlobal(int cooldown) {
        FeedFriendSettings.setGlobalFeedCooldown(cooldown);
    }

    public static int getFeedCooldownGlobal() {
        return FeedFriendSettings.getGlobalFeedCooldown();
    }

    public static boolean toggleFeedFriendEnabled() {
        boolean newValue = !FeedFriendSettings.isFeedFriendEnabled();
        FeedFriendSettings.setFeedFriendEnabled(newValue);
        return newValue;
    }

    public static boolean isFeedFriendEnabled() {
        return FeedFriendSettings.isFeedFriendEnabled();
    }

    public static void setFeedCooldown(UUID playerId, long time) {
        if (playerId != null) {
            feedCooldowns.put(playerId, time);
        }
    }

    private void onRegisterCommands(RegisterCommandsEvent event) {
        if (event != null && event.getDispatcher() != null) {
            event.getDispatcher().register(FeedFriendCommand.register());
        }
    }

    private void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        if (event != null) {
            FriendFeeder.tryFeedEvent(event);
        }
    }
}

