/*
 * Decompiled with CFR 0.152.
 */
package th.tamkungz.letyourfriendeating.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.LongArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import th.tamkungz.letyourfriendeating.LetYourFriendEatingMod;
import th.tamkungz.letyourfriendeating.manager.FeedCountsManager;

public class FeedFriendCommand {
    private static final Logger LOGGER = LogManager.getLogger((String)"FeedFriend");

    public static LiteralArgumentBuilder<CommandSourceStack> register() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"feedfriend").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"stats").requires(src -> true)).executes(ctx -> {
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_230896_();
            int count = FeedCountsManager.get(player.m_284548_()).getFeedCount(player.m_20148_());
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("You have been fed " + count + " time(s).")), false);
            LOGGER.info("{} checked their feed stats: {}", (Object)player.m_7755_().getString(), (Object)count);
            return 1;
        })).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).requires(src -> true)).executes(ctx -> {
            ServerPlayer target = EntityArgument.m_91474_((CommandContext)ctx, (String)"player");
            int count = 0;
            if (target instanceof ServerPlayer) {
                ServerPlayer serverTarget = target;
                count = FeedCountsManager.get(serverTarget.m_284548_()).getFeedCount(target.m_20148_());
            }
            int countFinal = count;
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> FeedFriendCommand.lambda$register$4((Player)target, countFinal), false);
            LOGGER.info("{} checked feed stats for {}: {}", (Object)((CommandSourceStack)ctx.getSource()).m_81368_(), (Object)target.m_7755_().getString(), (Object)countFinal);
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"toggle").requires(src -> true)).executes(ctx -> {
            MinecraftServer server = ((CommandSourceStack)ctx.getSource()).m_81377_();
            String toggler = ((CommandSourceStack)ctx.getSource()).m_81368_();
            FeedFriendCommand.toggleFeedFriendEnabled(server, toggler);
            return 1;
        }))).then(Commands.m_82127_((String)"cooldown").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"ms", (ArgumentType)LongArgumentType.longArg((long)0L)).requires(src -> true)).executes(ctx -> {
            long ms = LongArgumentType.getLong((CommandContext)ctx, (String)"ms");
            MinecraftServer server = ((CommandSourceStack)ctx.getSource()).m_81377_();
            String setter = ((CommandSourceStack)ctx.getSource()).m_81368_();
            FeedFriendCommand.setCooldownMs(server, ms, setter);
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("[FeedFriend] Set cooldown to " + ms + " ms.")), false);
            return 1;
        })));
    }

    public static void toggleFeedFriendEnabled(MinecraftServer server, String togglerName) {
        boolean enabled = LetYourFriendEatingMod.toggleFeedFriendEnabled();
        String state = enabled ? "enabled" : "disabled";
        String message = "[FeedFriend] Feature " + state + " by " + togglerName;
        server.m_6846_().m_11314_().forEach(p -> p.m_213846_((Component)Component.m_237113_((String)message)));
        LOGGER.info("FeedFriend {} by {}", (Object)state, (Object)togglerName);
    }

    public static void setCooldownMs(MinecraftServer server, long ms, String setterName) {
        LetYourFriendEatingMod.setFeedCooldownGlobal((int)ms);
        String message = "[FeedFriend] Cooldown set to " + ms + " ms by " + setterName;
        server.m_6846_().m_11314_().forEach(p -> p.m_213846_((Component)Component.m_237113_((String)message)));
        LOGGER.info("Cooldown set to {} ms by {}", (Object)ms, (Object)setterName);
    }

    private static /* synthetic */ Component lambda$register$4(Player target, int countFinal) {
        return Component.m_237113_((String)(target.m_7755_().getString() + " has been fed " + countFinal + " time(s)."));
    }
}

