/*
 * Decompiled with CFR 0.152.
 */
package th.tamkungz.letyourfriendeating.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FeedFriendSettings {
    private static final Logger SettingLogger = LogManager.getLogger(FeedFriendSettings.class);
    private static final Path FILE = Path.of("config", "letyourfriendeating-settings.json");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static boolean feedFriendEnabled = true;
    private static int globalFeedCooldown = 600;

    public static boolean isFeedFriendEnabled() {
        return feedFriendEnabled;
    }

    public static void setFeedFriendEnabled(boolean enabled) {
        feedFriendEnabled = enabled;
        FeedFriendSettings.save();
    }

    public static int getGlobalFeedCooldown() {
        return globalFeedCooldown;
    }

    public static void setGlobalFeedCooldown(int cooldown) {
        globalFeedCooldown = cooldown;
        FeedFriendSettings.save();
    }

    public static void load() {
        if (Files.exists(FILE, new LinkOption[0])) {
            try {
                String json = Files.readString(FILE);
                Data data = (Data)GSON.fromJson(json, Data.class);
                if (data != null) {
                    feedFriendEnabled = data.feedFriendEnabled;
                    globalFeedCooldown = data.globalFeedCooldown;
                }
            }
            catch (JsonSyntaxException | IOException e) {
                SettingLogger.info("[FeedFriendSettings] Failed to load settings: {}", (Object)e.getMessage());
            }
        } else {
            FeedFriendSettings.save();
        }
    }

    public static void save() {
        try {
            Files.createDirectories(FILE.getParent(), new FileAttribute[0]);
            Data data = new Data(feedFriendEnabled, globalFeedCooldown);
            String json = GSON.toJson((Object)data);
            Files.writeString(FILE, (CharSequence)json, new OpenOption[0]);
        }
        catch (IOException e) {
            SettingLogger.info("[FeedFriendSettings] Failed to save settings: {}", (Object)e.getMessage());
        }
    }

    private static class Data {
        boolean feedFriendEnabled;
        int globalFeedCooldown;

        Data(boolean enabled, int cooldown) {
            this.feedFriendEnabled = enabled;
            this.globalFeedCooldown = cooldown;
        }
    }
}

