/*
 * Decompiled with CFR 0.152.
 */
package th.tamkungz.letyourfriendeating.handler;

import com.mojang.datafixers.util.Pair;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.registries.ForgeRegistries;
import th.tamkungz.letyourfriendeating.LetYourFriendEatingMod;
import th.tamkungz.letyourfriendeating.manager.FeedCountsManager;

public class FriendFeeder {
    public static void tryFeedEvent(PlayerInteractEvent.EntityInteract event) {
        Entity entity;
        if (event == null) {
            return;
        }
        Player feeder = event.getEntity();
        if (feeder == null) {
            return;
        }
        if (LetYourFriendEatingMod.isFeedFriendEnabled() && (entity = event.getTarget()) instanceof Player) {
            Player target = (Player)entity;
            if (!event.getLevel().m_5776_()) {
                event.setCancellationResult(FriendFeeder.tryFeedPlayer(feeder, target, event.getHand()));
            }
        }
    }

    private static InteractionResult tryFeedPlayer(Player feeder, Player target, InteractionHand hand) {
        ServerLevel sl;
        ServerLevel serverLevel;
        if (feeder == null || target == null || hand == null) {
            return InteractionResult.PASS;
        }
        ItemStack stack = feeder.m_21120_(hand);
        if (stack.m_41619_() || feeder == target || !stack.m_41720_().m_41472_() && !FriendFeeder.isMilk(stack) || target.m_36324_() == null || !FriendFeeder.isMilk(stack) && target.m_36324_().m_38702_() >= 20) {
            return InteractionResult.PASS;
        }
        if (!FriendFeeder.isMilk(stack) && stack.m_41720_().getFoodProperties(stack, (LivingEntity)target) == null) {
            return InteractionResult.PASS;
        }
        if (FriendFeeder.isMilk(stack) && target.m_21220_().isEmpty()) {
            return InteractionResult.PASS;
        }
        Level level = feeder.m_20193_();
        ServerLevel serverLevel2 = serverLevel = level instanceof ServerLevel ? (sl = (ServerLevel)level) : null;
        if (serverLevel == null) {
            return InteractionResult.PASS;
        }
        Map<UUID, Long> cooldowns = LetYourFriendEatingMod.feedCooldowns;
        UUID feederId = feeder.m_20148_();
        long now = System.currentTimeMillis();
        Long lastTime = cooldowns.get(feederId);
        if (lastTime != null && now - lastTime < (long)LetYourFriendEatingMod.getFeedCooldownGlobal()) {
            return InteractionResult.PASS;
        }
        cooldowns.put(feederId, now);
        if (FriendFeeder.isMilk(stack)) {
            FriendFeeder.applyMilkClearEffects(target);
            FriendFeeder.playMilkEffects(target);
            if (!feeder.m_7500_()) {
                feeder.m_21008_(hand, new ItemStack((ItemLike)Items.f_42446_));
            }
        } else {
            FriendFeeder.feedPlayer(target, stack);
            FriendFeeder.applyFoodEffects(target, stack);
            FriendFeeder.playFoodEffects(target);
            if (!feeder.m_7500_() && !FriendFeeder.isEternalFood(stack)) {
                stack.m_41774_(1);
            }
        }
        FeedCountsManager.get(serverLevel).incrementFeedCount(target.m_20148_());
        return InteractionResult.SUCCESS;
    }

    private static void feedPlayer(Player target, ItemStack stack) {
        FoodProperties food = stack.m_41720_().getFoodProperties(stack, (LivingEntity)target);
        if (food != null && target.m_36324_() != null) {
            target.m_36324_().m_38707_(food.m_38744_(), food.m_38745_());
        }
    }

    private static void applyFoodEffects(Player target, ItemStack stack) {
        Level level;
        FoodProperties food = stack.m_41720_().getFoodProperties(stack, (LivingEntity)target);
        if (food == null) {
            return;
        }
        for (Pair effectPair : food.m_38749_()) {
            if (effectPair == null) continue;
            MobEffectInstance effect = (MobEffectInstance)effectPair.getFirst();
            Float chance = (Float)effectPair.getSecond();
            if (effect == null || chance == null || !(target.m_217043_().m_188501_() < chance.floatValue())) continue;
            target.m_7292_(new MobEffectInstance(effect));
        }
        if (target.m_217043_().m_188501_() < 0.05f && (level = target.m_20193_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123750_, target.m_20185_(), target.m_20186_() + 1.0, target.m_20189_(), 5, 0.5, 0.5, 0.5, 0.0);
        }
    }

    private static void playFoodEffects(Player target) {
        target.m_5496_(SoundEvents.f_12321_, 1.0f, 1.0f);
        Level level = target.m_20193_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123748_, target.m_20185_(), target.m_20186_() + 1.0, target.m_20189_(), 5, 0.5, 0.5, 0.5, 0.0);
        }
    }

    private static boolean isMilk(ItemStack stack) {
        return stack != null && stack.m_150930_(Items.f_42455_);
    }

    private static void applyMilkClearEffects(Player target) {
        target.m_21219_();
    }

    private static void playMilkEffects(Player player) {
        player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11911_, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    private static boolean isEternalFood(ItemStack stack) {
        if (stack == null || stack.m_41619_()) {
            return false;
        }
        ResourceLocation id = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_());
        String displayName = stack.m_41786_().getString().toLowerCase();
        return id.m_135815_().toLowerCase().contains("eternal") || displayName.contains("eternal");
    }
}

