/*
 * Decompiled with CFR 0.152.
 */
package th.tamkungz.letyourfriendeating.manager;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;

public class FeedCountsManager
extends SavedData {
    private static final String NAME = "letyourfriendeating_feedcounts";
    private final Map<UUID, Integer> feedCounts = new HashMap<UUID, Integer>();

    public static FeedCountsManager get(ServerLevel level) {
        return (FeedCountsManager)level.m_8895_().m_164861_(FeedCountsManager::load, FeedCountsManager::new, NAME);
    }

    public int getFeedCount(UUID playerId) {
        return playerId == null ? 0 : this.feedCounts.getOrDefault(playerId, 0);
    }

    public void incrementFeedCount(UUID playerId) {
        if (playerId == null) {
            return;
        }
        this.feedCounts.put(playerId, this.feedCounts.getOrDefault(playerId, 0) + 1);
        this.m_77762_();
    }

    public Map<UUID, Integer> getFeedCountsView() {
        return Map.copyOf(this.feedCounts);
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        ListTag list = new ListTag();
        for (Map.Entry<UUID, Integer> entry : this.feedCounts.entrySet()) {
            CompoundTag entryTag = new CompoundTag();
            entryTag.m_128362_("uuid", entry.getKey());
            entryTag.m_128405_("count", entry.getValue().intValue());
            list.add((Object)entryTag);
        }
        tag.m_128365_("feedCounts", (Tag)list);
        return tag;
    }

    public static FeedCountsManager load(CompoundTag tag) {
        FeedCountsManager data = new FeedCountsManager();
        ListTag list = tag.m_128437_("feedCounts", 10);
        for (Tag entry : list) {
            CompoundTag entryTag = (CompoundTag)entry;
            UUID uuid = entryTag.m_128342_("uuid");
            int count = entryTag.m_128451_("count");
            data.feedCounts.put(uuid, count);
        }
        return data;
    }
}

