/*
 * Decompiled with CFR 0.152.
 */
package com.aqupd.caracal.entity;

import com.aqupd.caracal.ai.CaracalSitOnBlockGoal;
import com.aqupd.caracal.setup.CaracalEntities;
import com.aqupd.caracal.setup.CaracalSounds;
import com.aqupd.caracal.utils.AqConfig;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.OcelotAttackGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.target.NonTameRandomTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.example.entity.BatEntity;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class CaracalEntity
extends TamableAnimal
implements GeoEntity {
    private static final Ingredient TAMING_INGREDIENT;
    private static final EntityDataAccessor<Boolean> IN_SLEEPING_POSE;
    private static final EntityDataAccessor<Integer> CARACAL_BIRTHDAY_COLOR;
    private static final EntityDataAccessor<Integer> CURRENT_ANIMATION;
    private boolean songPlaying;
    @Nullable
    private BlockPos songSource;
    private CaracalTemptGoal temptGoal;
    private static double health;
    private static double speed;
    private static double follow;
    private static double damage;
    private static double knockback;
    private static final HashSet<UUID> peopleToAttack;
    private boolean commander;
    private final AnimatableInstanceCache aFactory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final RawAnimation IDLE;
    private static final RawAnimation IDLE2SIT;
    private static final RawAnimation IDLE2SLEEP;
    private static final RawAnimation WALK;
    private static final RawAnimation SNEAK;
    private static final RawAnimation RUN;
    private static final RawAnimation SIT;
    private static final RawAnimation SIT2IDLE;
    private static final RawAnimation SIT2SLEEP;
    private static final RawAnimation SLEEP;
    private static final RawAnimation SLEEP2IDLE;
    private static final RawAnimation SLEEP2SIT;
    private static final RawAnimation DANCE;

    public CaracalEntity(EntityType<? extends CaracalEntity> entityType, Level level) {
        super(entityType, level);
    }

    protected void m_8099_() {
        this.temptGoal = new CaracalTemptGoal(this, 1.0, TAMING_INGREDIENT, true);
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new SleepWithOwnerGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(2, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.0, 10.0f, 5.0f, true));
        this.f_21345_.m_25352_(3, (Goal)new PanicGoal((PathfinderMob)this, 1.4));
        this.f_21345_.m_25352_(3, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)this.temptGoal);
        this.f_21345_.m_25352_(5, (Goal)new LeapAtTargetGoal((Mob)this, 0.3f));
        this.f_21345_.m_25352_(6, (Goal)new OcelotAttackGoal((Mob)this));
        this.f_21345_.m_25352_(7, (Goal)new CaracalSitOnBlockGoal(this, 0.8));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 10.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.5));
        this.f_21346_.m_25352_(1, (Goal)new NonTameRandomTargetGoal((TamableAnimal)this, Player.class, false, le -> {
            UUID uuid = le.m_20148_();
            if (uuid == null) {
                return false;
            }
            return peopleToAttack.contains(uuid);
        }));
        this.f_21346_.m_25352_(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(3, (Goal)new NonTameRandomTargetGoal((TamableAnimal)this, Chicken.class, true, null));
        this.f_21346_.m_25352_(3, (Goal)new NonTameRandomTargetGoal((TamableAnimal)this, Rabbit.class, true, null));
        this.f_21346_.m_25352_(3, (Goal)new NonTameRandomTargetGoal((TamableAnimal)this, BatEntity.class, true, null));
    }

    public void m_8024_() {
        if (this.m_21566_().m_24995_()) {
            double d = this.m_21566_().m_24999_();
            if (d == 0.6) {
                this.m_20124_(Pose.CROUCHING);
                this.m_6858_(false);
            } else if (d == 1.33) {
                this.m_20124_(Pose.STANDING);
                this.m_6858_(true);
            } else {
                this.m_20124_(Pose.STANDING);
                this.m_6858_(false);
            }
        } else {
            this.m_20124_(Pose.STANDING);
            this.m_6858_(false);
        }
        if (this.temptGoal != null && this.temptGoal.m_25955_() && !this.m_21824_() && this.f_146733_ % 100 == 0) {
            this.m_5496_((SoundEvent)CaracalSounds.ENTITY_CARACAL_BEG_FOR_FOOD.get(), 1.0f, 1.0f);
        }
        this.updateAnimations();
    }

    private void updateAnimations() {
        if (this.isLying() && this.f_146733_ % 5 == 0 && (double)this.f_19796_.m_188501_() > 0.7) {
            this.m_5496_((SoundEvent)CaracalSounds.ENTITY_CARACAL_PURR.get(), 0.6f + 0.4f * (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()), 1.0f);
        }
        if (this.songSource == null || !this.songSource.m_203195_((Position)this.m_20182_(), 5.0) || !this.m_9236_().m_8055_(this.songSource).m_60713_(Blocks.f_50131_)) {
            this.songPlaying = false;
            this.songSource = null;
        }
    }

    private PlayState predicate(AnimationState<CaracalEntity> state) {
        AnimationController contr = state.getController();
        String animName = "";
        if (contr.getCurrentAnimation() != null) {
            animName = contr.getCurrentAnimation().animation().name();
        }
        if (this.isSongPlaying()) {
            if (!animName.equals("animation.caracal.dance1") || !animName.equals("animation.caracal.dance2")) {
                this.setCurrentAnimation(6);
            }
        } else {
            if (this.getCurrentAnimation() == 4 && !this.m_21825_()) {
                contr.setAnimation(SIT2IDLE);
                if (contr.getAnimationState() == AnimationController.State.PAUSED) {
                    this.setCurrentAnimation(0);
                }
                return PlayState.CONTINUE;
            }
            if (this.getCurrentAnimation() == 5 && !this.isLying() && !this.m_21825_()) {
                contr.setAnimation(SLEEP2IDLE);
                if (contr.getAnimationState() == AnimationController.State.PAUSED) {
                    this.setCurrentAnimation(0);
                }
                return PlayState.CONTINUE;
            }
            if (this.getCurrentAnimation() != 4 && this.m_21825_() && !this.isLying()) {
                if (this.getCurrentAnimation() <= 3) {
                    contr.setAnimation(IDLE2SIT);
                } else if (this.getCurrentAnimation() == 5) {
                    contr.setAnimation(SLEEP2SIT);
                }
                if (contr.getAnimationState() == AnimationController.State.PAUSED) {
                    this.setCurrentAnimation(4);
                }
                return PlayState.CONTINUE;
            }
            if (this.getCurrentAnimation() != 5 && this.isLying()) {
                if (this.getCurrentAnimation() <= 3) {
                    contr.setAnimation(IDLE2SLEEP);
                } else if (this.getCurrentAnimation() == 4) {
                    contr.setAnimation(SIT2SLEEP);
                }
                if (contr.getAnimationState() == AnimationController.State.PAUSED) {
                    this.setCurrentAnimation(5);
                }
                return PlayState.CONTINUE;
            }
            if (this.isLying()) {
                this.setCurrentAnimation(5);
            } else if (this.m_21825_()) {
                this.setCurrentAnimation(4);
            } else if (state.isMoving()) {
                this.setCurrentAnimation(1);
            } else {
                this.setCurrentAnimation(0);
            }
        }
        switch (this.getCurrentAnimation()) {
            case 0: {
                contr.setAnimation(IDLE);
                break;
            }
            case 1: {
                contr.setAnimation(WALK);
                break;
            }
            case 2: {
                contr.setAnimation(SNEAK);
                break;
            }
            case 3: {
                contr.setAnimation(RUN);
                break;
            }
            case 4: {
                contr.setAnimation(SIT);
                break;
            }
            case 5: {
                contr.setAnimation(SLEEP);
                break;
            }
            case 6: {
                contr.setAnimation(DANCE);
            }
        }
        return PlayState.CONTINUE;
    }

    protected PlayState idle(AnimationState<CaracalEntity> state) {
        if (this.getCurrentAnimation() <= 3 && this.getCurrentAnimation() > 0) {
            state.setAnimation(IDLE);
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "animations", 0, this::predicate), new AnimationController((GeoAnimatable)this, "idle", 0, this::idle)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.aFactory;
    }

    public static AttributeSupplier.Builder createCaracalAttributes() {
        return AgeableMob.m_21183_().m_22268_(Attributes.f_22276_, health).m_22268_(Attributes.f_22279_, speed).m_22268_(Attributes.f_22277_, follow).m_22268_(Attributes.f_22281_, damage).m_22268_(Attributes.f_22282_, knockback);
    }

    public int getCurrentAnimation() {
        return (Integer)this.f_19804_.m_135370_(CURRENT_ANIMATION);
    }

    public void setCurrentAnimation(int animation) {
        this.f_19804_.m_135381_(CURRENT_ANIMATION, (Object)animation);
    }

    public int getMaskColor() {
        return (Integer)this.f_19804_.m_135370_(CARACAL_BIRTHDAY_COLOR);
    }

    public void setMaskColor(int type) {
        if (type < 1 || type > 3) {
            type = this.f_19796_.m_188503_(3) + 1;
        }
        this.f_19804_.m_135381_(CARACAL_BIRTHDAY_COLOR, (Object)type);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("CaracalBirthdayColor", this.getMaskColor());
        if (this.commander) {
            tag.m_128379_("Commander", true);
        }
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setMaskColor(tag.m_128451_("CaracalBirthdayColor"));
        if (tag.m_128425_("Commander", 99)) {
            this.commander = tag.m_128471_("Commander");
        }
    }

    public void m_6593_(@Nullable Component name) {
        super.m_6593_(name);
        if (this.m_7770_() != null) {
            String n = this.m_7770_().getString().toLowerCase(Locale.ENGLISH);
            this.commander = (n.contains("\u043a\u043e\u043c\u0430\u043d\u0434\u0438\u0440") || n.contains("commander")) && !n.contains("\u043c\u0438\u0440\u043d\u044b\u0439") && !n.contains("peaceful");
        }
    }

    public void m_6818_(BlockPos songPosition, boolean playing) {
        this.songSource = songPosition;
        this.songPlaying = playing;
    }

    public boolean isSongPlaying() {
        return this.songPlaying;
    }

    public boolean m_142535_(float fallDistance, float damageMultiplier, DamageSource damageSource) {
        return false;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        if (this.m_21824_()) {
            if (this.m_27593_()) {
                return (SoundEvent)CaracalSounds.ENTITY_CARACAL_PURR.get();
            }
            return this.f_19796_.m_188503_(4) == 0 ? (SoundEvent)CaracalSounds.ENTITY_CARACAL_PURREOW.get() : (this.m_146764_() < 0 ? (SoundEvent)CaracalSounds.ENTITY_CARACAL_SMALL_SCREAM.get() : (SoundEvent)CaracalSounds.ENTITY_CARACAL_SCREAM.get());
        }
        return this.m_146764_() < 0 ? (SoundEvent)CaracalSounds.ENTITY_CARACAL_SMALL_SCREAM.get() : (SoundEvent)CaracalSounds.ENTITY_CARACAL_SCREAM.get();
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)CaracalSounds.ENTITY_CARACAL_HISS.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)CaracalSounds.ENTITY_CARACAL_DEATH.get();
    }

    private float getAttackDamage() {
        return (float)this.m_21133_(Attributes.f_22281_);
    }

    public boolean m_7327_(Entity target) {
        return target.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), this.getAttackDamage());
    }

    protected void m_142075_(Player player, InteractionHand hand, ItemStack stack) {
        if (this.isBreedingItem(stack)) {
            this.m_5496_((SoundEvent)CaracalSounds.ENTITY_CARACAL_EAT.get(), 1.0f, 1.0f);
        }
        super.m_142075_(player, hand, stack);
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel level, AgeableMob entity) {
        CaracalEntity caracalEntity = (CaracalEntity)((EntityType)CaracalEntities.CARACAL.get()).m_20615_((Level)level);
        if (entity instanceof CaracalEntity && this.m_21824_()) {
            caracalEntity.m_21816_(this.m_21805_());
            caracalEntity.m_7105_(true);
        }
        caracalEntity.setMaskColor(10);
        return caracalEntity;
    }

    public boolean m_7848_(Animal other) {
        if (!this.m_21824_()) {
            return false;
        }
        if (!(other instanceof CaracalEntity)) {
            return false;
        }
        CaracalEntity caracalEntity = (CaracalEntity)other;
        return caracalEntity.m_21824_() && super.m_7848_(other);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(CARACAL_BIRTHDAY_COLOR, (Object)10);
        this.f_19804_.m_135372_(IN_SLEEPING_POSE, (Object)false);
        this.f_19804_.m_135372_(CURRENT_ANIMATION, (Object)0);
    }

    public void setLying(boolean sleeping) {
        this.f_19804_.m_135381_(IN_SLEEPING_POSE, (Object)sleeping);
    }

    public boolean isLying() {
        return (Boolean)this.f_19804_.m_135370_(IN_SLEEPING_POSE);
    }

    @NotNull
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        Item item = itemStack.m_41720_();
        if (this.m_9236_().m_5776_()) {
            if (this.m_21824_() && this.m_21830_((LivingEntity)player)) {
                return InteractionResult.SUCCESS;
            }
            if (this.isBreedingItem(itemStack)) {
                return InteractionResult.SUCCESS;
            }
            if (this.m_21223_() < this.m_21233_() && this.m_21824_()) {
                return InteractionResult.CONSUME;
            }
        } else if (this.m_21824_() && this.m_21830_((LivingEntity)player)) {
            if (this.isBreedingItem(itemStack)) {
                if (this.m_21223_() < this.m_21233_()) {
                    this.m_142075_(player, hand, itemStack);
                    this.m_5634_(item.m_41473_().m_38744_());
                    return InteractionResult.CONSUME;
                }
                if (this.m_146764_() == 0 && this.m_5957_()) {
                    this.m_142075_(player, hand, itemStack);
                    this.m_27595_(player);
                    return InteractionResult.SUCCESS;
                }
                if (this.m_6162_()) {
                    this.m_142075_(player, hand, itemStack);
                    this.m_146740_(CaracalEntity.m_216967_((int)(-this.m_146764_())), true);
                    return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
                }
            }
            this.m_21839_(!this.m_21827_());
        } else if (this.isBreedingItem(itemStack)) {
            this.m_142075_(player, hand, itemStack);
            if (this.f_19796_.m_188503_(3) == 0) {
                this.m_21828_(player);
                this.m_21839_(true);
                this.m_21530_();
                this.m_9236_().m_7605_((Entity)this, (byte)7);
            } else {
                this.m_9236_().m_7605_((Entity)this, (byte)6);
            }
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        spawnData = super.m_6518_(level, difficulty, reason, spawnData, dataTag);
        this.setMaskColor(10);
        return spawnData;
    }

    public boolean isBreedingItem(ItemStack stack) {
        return TAMING_INGREDIENT.test(stack);
    }

    protected float m_6431_(Pose pose, EntityDimensions dimensions) {
        return dimensions.f_20378_ * 0.98f;
    }

    public boolean m_6785_(double distanceSquared) {
        return !this.m_21824_() && this.f_146733_ > 2400;
    }

    public static boolean canSpawn(EntityType<CaracalEntity> entity, LevelAccessor level, MobSpawnType type, BlockPos pos, RandomSource random) {
        return Animal.m_218104_(entity, (LevelAccessor)level, (MobSpawnType)type, (BlockPos)pos, (RandomSource)random);
    }

    static {
        health = AqConfig.INSTANCE.getDoubleProperty("entity.health");
        speed = AqConfig.INSTANCE.getDoubleProperty("entity.speed");
        follow = AqConfig.INSTANCE.getDoubleProperty("entity.follow");
        damage = AqConfig.INSTANCE.getDoubleProperty("entity.damage");
        knockback = AqConfig.INSTANCE.getDoubleProperty("entity.knockback");
        peopleToAttack = new HashSet<UUID>(){
            {
                this.add(UUID.fromString("06e02a3f-dc56-43b5-95b9-191387a59e01"));
            }
        };
        IDLE = RawAnimation.begin().thenLoop("animation.caracal.idle");
        IDLE2SIT = RawAnimation.begin().thenPlay("animation.caracal.idle2sit");
        IDLE2SLEEP = RawAnimation.begin().thenPlay("animation.caracal.idle2sleep");
        WALK = RawAnimation.begin().thenLoop("animation.caracal.walk");
        SNEAK = RawAnimation.begin().thenLoop("animation.caracal.sneak");
        RUN = RawAnimation.begin().thenLoop("animation.caracal.run");
        SIT = RawAnimation.begin().thenLoop("animation.caracal.sit");
        SIT2IDLE = RawAnimation.begin().thenPlay("animation.caracal.sit2idle");
        SIT2SLEEP = RawAnimation.begin().thenPlay("animation.caracal.sit2sleep");
        SLEEP = RawAnimation.begin().thenLoop("animation.caracal.sleep");
        SLEEP2IDLE = RawAnimation.begin().thenPlay("animation.caracal.sleep2idle");
        SLEEP2SIT = RawAnimation.begin().thenPlay("animation.caracal.sleep2sit");
        DANCE = RawAnimation.begin().thenPlayXTimes("animation.caracal.dance1", 9).thenLoop("animation.caracal.dance2");
        TAMING_INGREDIENT = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42526_, Items.f_42527_, Items.f_42581_, Items.f_42697_});
        IN_SLEEPING_POSE = SynchedEntityData.m_135353_(CaracalEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
        CARACAL_BIRTHDAY_COLOR = SynchedEntityData.m_135353_(CaracalEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        CURRENT_ANIMATION = SynchedEntityData.m_135353_(CaracalEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    }

    static class CaracalTemptGoal
    extends TemptGoal {
        @Nullable
        private Player selectedPlayer;
        private final CaracalEntity caracalEntity;

        public CaracalTemptGoal(CaracalEntity caracalEntity, double speed, Ingredient food, boolean canBeScared) {
            super((PathfinderMob)caracalEntity, speed, food, canBeScared);
            this.caracalEntity = caracalEntity;
        }

        public void m_8037_() {
            super.m_8037_();
            if (this.selectedPlayer == null && this.f_25924_.m_217043_().m_188503_(this.m_183277_(600)) == 0) {
                this.selectedPlayer = this.f_25925_;
            } else if (this.f_25924_.m_217043_().m_188503_(this.m_183277_(500)) == 0) {
                this.selectedPlayer = null;
            }
        }

        protected boolean m_7497_() {
            if (this.selectedPlayer != null && this.selectedPlayer.equals((Object)this.f_25925_)) {
                return false;
            }
            return super.m_7497_();
        }

        public boolean m_8036_() {
            return super.m_8036_() && !this.caracalEntity.m_21824_();
        }
    }

    static class SleepWithOwnerGoal
    extends Goal {
        private final CaracalEntity caracal;
        @Nullable
        private Player ownerPlayer;
        @Nullable
        private BlockPos goalPos;
        private int onBedTicks;

        public SleepWithOwnerGoal(CaracalEntity caracalEntity) {
            this.caracal = caracalEntity;
        }

        public boolean m_8036_() {
            if (!this.caracal.m_21824_()) {
                return false;
            }
            if (this.caracal.m_21827_()) {
                return false;
            }
            LivingEntity livingEntity = this.caracal.m_269323_();
            if (livingEntity instanceof Player) {
                this.ownerPlayer = (Player)livingEntity;
                if (!livingEntity.m_5803_()) {
                    return false;
                }
                if (this.caracal.m_20280_((Entity)this.ownerPlayer) > 100.0) {
                    return false;
                }
                BlockPos blockPos = this.ownerPlayer.m_20183_();
                BlockState blockState = this.caracal.m_9236_().m_8055_(blockPos);
                if (blockState.m_204336_(BlockTags.f_13038_)) {
                    this.goalPos = blockState.m_61145_((Property)BedBlock.f_54117_).map(direction -> blockPos.m_121945_(direction.m_122424_())).orElseGet(() -> new BlockPos((Vec3i)blockPos));
                    return !this.spaceIsOccupied();
                }
            }
            return false;
        }

        private boolean spaceIsOccupied() {
            List list = this.caracal.m_9236_().m_45976_(CaracalEntity.class, new AABB(this.goalPos).m_82400_(2.0));
            for (CaracalEntity caracal : list) {
                if (caracal == this.caracal || !caracal.isLying()) continue;
                return true;
            }
            return false;
        }

        public boolean m_8045_() {
            return this.caracal.m_21824_() && !this.caracal.m_21827_() && this.ownerPlayer != null && this.ownerPlayer.m_5803_() && this.goalPos != null && !this.spaceIsOccupied();
        }

        public void m_8056_() {
            if (this.goalPos != null) {
                this.caracal.m_21837_(false);
                this.caracal.m_21573_().m_26519_((double)this.goalPos.m_123341_(), (double)this.goalPos.m_123342_(), (double)this.goalPos.m_123343_(), (double)1.1f);
            }
        }

        public void m_8041_() {
            this.caracal.setLying(false);
            float f = this.caracal.m_9236_().m_46942_(1.0f);
            if (this.ownerPlayer.m_36318_() >= 100 && (double)f > 0.77 && (double)f < 0.8 && (double)this.caracal.m_9236_().m_213780_().m_188501_() < 0.7) {
                this.giveMorningGift();
            }
            this.onBedTicks = 0;
            this.caracal.m_21573_().m_26573_();
        }

        private void giveMorningGift() {
            RandomSource randomSource = this.caracal.m_217043_();
            BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
            mutableBlockPos.m_122190_((Vec3i)(this.caracal.m_21523_() ? this.caracal.m_21524_().m_20183_() : this.caracal.m_20183_()));
            this.caracal.m_20984_(mutableBlockPos.m_123341_() + randomSource.m_188503_(11) - 5, mutableBlockPos.m_123342_() + randomSource.m_188503_(5) - 2, mutableBlockPos.m_123343_() + randomSource.m_188503_(11) - 5, false);
            mutableBlockPos.m_122190_((Vec3i)this.caracal.m_20183_());
            LootTable lootTable = this.caracal.m_9236_().m_7654_().m_278653_().m_278676_(BuiltInLootTables.f_78724_);
            LootParams lootParams = new LootParams.Builder((ServerLevel)this.caracal.m_9236_()).m_287286_(LootContextParams.f_81460_, (Object)this.caracal.m_20182_()).m_287286_(LootContextParams.f_81455_, (Object)this.caracal).m_287235_(LootContextParamSets.f_81416_);
            ObjectArrayList list = lootTable.m_287195_(lootParams);
            for (ItemStack itemStack : list) {
                this.caracal.m_9236_().m_7967_((Entity)new ItemEntity(this.caracal.m_9236_(), (double)mutableBlockPos.m_123341_() - (double)Mth.m_14031_((float)(this.caracal.f_20883_ * ((float)Math.PI / 180))), (double)mutableBlockPos.m_123342_(), (double)mutableBlockPos.m_123343_() + (double)Mth.m_14089_((float)(this.caracal.f_20883_ * ((float)Math.PI / 180))), itemStack));
            }
        }

        public void m_8037_() {
            if (this.ownerPlayer != null && this.goalPos != null) {
                this.caracal.m_21837_(false);
                this.caracal.m_21573_().m_26519_((double)this.goalPos.m_123341_(), (double)this.goalPos.m_123342_(), (double)this.goalPos.m_123343_(), (double)1.1f);
                if (this.caracal.m_20280_((Entity)this.ownerPlayer) < 2.5) {
                    ++this.onBedTicks;
                    if (this.onBedTicks > this.m_183277_(16)) {
                        this.caracal.setLying(true);
                    } else {
                        this.caracal.m_21391_((Entity)this.ownerPlayer, 45.0f, 45.0f);
                    }
                } else {
                    this.caracal.setLying(false);
                }
            }
        }
    }
}

